/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0012H\u0007J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0007J\u001e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012J\u001e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012J\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0007J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0007J\u0016\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J\u001e\u0010&\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/locationtech/jts/algorithm/Angle;", "", "<init>", "()V", "PI_TIMES_2", "", "PI_OVER_2", "PI_OVER_4", "COUNTERCLOCKWISE", "", "CLOCKWISE", "NONE", "toDegrees", "radians", "toRadians", "angleDegrees", "angle", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p", "isAcute", "", "p2", "isObtuse", "angleBetween", "tip1", "tail", "tip2", "angleBetweenOriented", "bisector", "interiorAngle", "getTurn", "ang1", "ang2", "normalize", "normalizePositive", "diff", "project", "dist", "kts-core"})
public final class Angle {
    @NotNull
    public static final Angle INSTANCE = new Angle();
    public static final double PI_TIMES_2 = java.lang.Math.PI * 2;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int CLOCKWISE = -1;
    public static final int NONE = 0;

    private Angle() {
    }

    public final double toDegrees(double radians) {
        return radians * (double)180 / java.lang.Math.PI;
    }

    public final double toRadians(double angleDegrees) {
        return angleDegrees * java.lang.Math.PI / 180.0;
    }

    public final double angle(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        return Math.INSTANCE.atan2(dy, dx);
    }

    @JvmStatic
    public static final double angle(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return Math.INSTANCE.atan2(p.y, p.x);
    }

    @JvmStatic
    public static final boolean isAcute(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        double dx0 = p0.x - p1.x;
        double dy0 = p0.y - p1.y;
        double dx1 = p2.x - p1.x;
        double dy1 = p2.y - p1.y;
        double dotprod = dx0 * dx1 + dy0 * dy1;
        return dotprod > 0.0;
    }

    public final boolean isObtuse(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        double dx0 = p0.x - p1.x;
        double dy0 = p0.y - p1.y;
        double dx1 = p2.x - p1.x;
        double dy1 = p2.y - p1.y;
        double dotprod = dx0 * dx1 + dy0 * dy1;
        return dotprod < 0.0;
    }

    public final double angleBetween(@NotNull Coordinate tip1, @NotNull Coordinate tail, @NotNull Coordinate tip2) {
        Intrinsics.checkNotNullParameter((Object)tip1, (String)"tip1");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        Intrinsics.checkNotNullParameter((Object)tip2, (String)"tip2");
        double a1 = this.angle(tail, tip1);
        double a2 = this.angle(tail, tip2);
        return this.diff(a1, a2);
    }

    public final double angleBetweenOriented(@NotNull Coordinate tip1, @NotNull Coordinate tail, @NotNull Coordinate tip2) {
        Intrinsics.checkNotNullParameter((Object)tip1, (String)"tip1");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        Intrinsics.checkNotNullParameter((Object)tip2, (String)"tip2");
        double a1 = this.angle(tail, tip1);
        double a2 = this.angle(tail, tip2);
        double angDel = a2 - a1;
        if (angDel <= -java.lang.Math.PI) {
            return angDel + java.lang.Math.PI * 2;
        }
        return angDel > java.lang.Math.PI ? angDel - java.lang.Math.PI * 2 : angDel;
    }

    @JvmStatic
    public static final double bisector(@NotNull Coordinate tip1, @NotNull Coordinate tail, @NotNull Coordinate tip2) {
        Intrinsics.checkNotNullParameter((Object)tip1, (String)"tip1");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        Intrinsics.checkNotNullParameter((Object)tip2, (String)"tip2");
        double angDel = INSTANCE.angleBetweenOriented(tip1, tail, tip2);
        double angBi = INSTANCE.angle(tail, tip1) + angDel / (double)2;
        return Angle.normalize(angBi);
    }

    @JvmStatic
    public static final double interiorAngle(@NotNull Coordinate p0, @NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        double anglePrev = INSTANCE.angle(p1, p0);
        double angleNext = INSTANCE.angle(p1, p2);
        return Angle.normalizePositive(angleNext - anglePrev);
    }

    public final int getTurn(double ang1, double ang2) {
        double crossproduct = Math.INSTANCE.sin(ang2 - ang1);
        if (crossproduct > 0.0) {
            return 1;
        }
        return crossproduct < 0.0 ? -1 : 0;
    }

    @JvmStatic
    public static final double normalize(double angle) {
        double angle2;
        for (angle2 = angle; angle2 > java.lang.Math.PI; angle2 -= java.lang.Math.PI * 2) {
        }
        while (angle2 <= -java.lang.Math.PI) {
            angle2 += java.lang.Math.PI * 2;
        }
        return angle2;
    }

    @JvmStatic
    public static final double normalizePositive(double angle) {
        double angle2 = angle;
        if (angle2 < 0.0) {
            while (angle2 < 0.0) {
                angle2 += java.lang.Math.PI * 2;
            }
            if (angle2 >= java.lang.Math.PI * 2) {
                angle2 = 0.0;
            }
        } else {
            while (angle2 >= java.lang.Math.PI * 2) {
                angle2 -= java.lang.Math.PI * 2;
            }
            if (angle2 < 0.0) {
                angle2 = 0.0;
            }
        }
        return angle2;
    }

    public final double diff(double ang1, double ang2) {
        double delAngle = 0.0;
        double d = delAngle = ang1 < ang2 ? ang2 - ang1 : ang1 - ang2;
        if (delAngle > java.lang.Math.PI) {
            delAngle = java.lang.Math.PI * 2 - delAngle;
        }
        return delAngle;
    }

    @NotNull
    public final Coordinate project(@NotNull Coordinate p, double angle, double dist) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double x = p.x + dist * Math.INSTANCE.cos(angle);
        double y = p.y + dist * Math.INSTANCE.sin(angle);
        return new Coordinate(x, y);
    }
}

