/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\tH\u0007\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J#\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007\u00a2\u0006\u0002\u0010\nJ#\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/algorithm/PointLocation;", "", "<init>", "()V", "isOnLine", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "line", "", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Z", "Lorg/locationtech/jts/geom/CoordinateSequence;", "isInRing", "ring", "locateInRing", "", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)I", "kts-core"})
public final class PointLocation {
    @NotNull
    public static final PointLocation INSTANCE = new PointLocation();

    private PointLocation() {
    }

    @JvmStatic
    public static final boolean isOnLine(@Nullable Coordinate p, @NotNull Coordinate[] line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        LineIntersector lineIntersector = new RobustLineIntersector();
        int n = line.length;
        for (int i = 1; i < n; ++i) {
            Coordinate p0 = line[i - 1];
            Coordinate p1 = line[i];
            lineIntersector.computeIntersection(p, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean isOnLine(@Nullable Coordinate p, @NotNull CoordinateSequence line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        LineIntersector lineIntersector = new RobustLineIntersector();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        int n = line.size();
        for (int i = 1; i < n; ++i) {
            line.getCoordinate(i - 1, p0);
            line.getCoordinate(i, p1);
            lineIntersector.computeIntersection(p, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean isInRing(@NotNull Coordinate p, @NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return PointLocation.locateInRing(p, ring) != 2;
    }

    @JvmStatic
    public static final int locateInRing(@NotNull Coordinate p, @NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return RayCrossingCounter.Companion.locatePointInRing(p, ring);
    }
}

