/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ0\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0007J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u001e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\nJ\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010#\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010$\u001a\u00020\n2\b\b\u0002\u0010%\u001a\u00020\nH\u0007J\u0016\u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\"J\"\u0010&\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020\u0014H\u0007J\u0018\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006,"}, d2={"Lorg/locationtech/jts/geom/CoordinateSequences;", "", "<init>", "()V", "reverse", "", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "swap", "i", "", "j", "copy", "src", "srcPos", "dest", "destPos", "length", "copyCoord", "isRing", "", "ensureValidRing", "fact", "Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "createClosedRing", "size", "extend", "isEqual", "cs1", "cs2", "toString", "", "cs", "minCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "minCoordinateIndex", "from", "to", "scroll", "firstCoordinate", "indexOfFirstCoordinate", "ensureRing", "indexOf", "coordinate", "kts-core"})
public final class CoordinateSequences {
    @NotNull
    public static final CoordinateSequences INSTANCE = new CoordinateSequences();

    private CoordinateSequences() {
    }

    @JvmStatic
    public static final void reverse(@NotNull CoordinateSequence seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        if (seq.size() <= 1) {
            return;
        }
        int i = 0;
        int last = seq.size() - 1;
        int mid = last / 2;
        if (i <= mid) {
            while (true) {
                INSTANCE.swap(seq, i, last - i);
                if (i == mid) break;
                ++i;
            }
        }
    }

    public final void swap(@NotNull CoordinateSequence seq, int i, int j) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        if (i == j) {
            return;
        }
        int n = seq.getDimension();
        for (int dim = 0; dim < n; ++dim) {
            double tmp = seq.getOrdinate(i, dim);
            seq.setOrdinate(i, dim, seq.getOrdinate(j, dim));
            seq.setOrdinate(j, dim, tmp);
        }
    }

    @JvmStatic
    public static final void copy(@NotNull CoordinateSequence src, int srcPos, @NotNull CoordinateSequence dest, int destPos, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        for (int i = 0; i < length; ++i) {
            INSTANCE.copyCoord(src, srcPos + i, dest, destPos + i);
        }
    }

    public final void copyCoord(@NotNull CoordinateSequence src, int srcPos, @NotNull CoordinateSequence dest, int destPos) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int minDim = Math.INSTANCE.min(src.getDimension(), dest.getDimension());
        for (int dim = 0; dim < minDim; ++dim) {
            dest.setOrdinate(destPos, dim, src.getOrdinate(srcPos, dim));
        }
    }

    @JvmStatic
    public static final boolean isRing(@NotNull CoordinateSequence seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        int n = seq.size();
        if (n == 0) {
            return true;
        }
        return n <= 3 ? false : seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
    }

    @JvmStatic
    @NotNull
    public static final CoordinateSequence ensureValidRing(@NotNull CoordinateSequenceFactory fact, @NotNull CoordinateSequence seq) {
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        int n = seq.size();
        if (n == 0) {
            return seq;
        }
        if (n <= 3) {
            return INSTANCE.createClosedRing(fact, seq, 4);
        }
        boolean isClosed = seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
        return isClosed ? seq : INSTANCE.createClosedRing(fact, seq, n + 1);
    }

    private final CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        for (int i = n; i < size; ++i) {
            CoordinateSequences.copy(seq, 0, newseq, i, 1);
        }
        return newseq;
    }

    @NotNull
    public final CoordinateSequence extend(@NotNull CoordinateSequenceFactory fact, @NotNull CoordinateSequence seq, int size) {
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        if (n > 0) {
            for (int i = n; i < size; ++i) {
                CoordinateSequences.copy(seq, n - 1, newseq, i, 1);
            }
        }
        return newseq;
    }

    @JvmStatic
    public static final boolean isEqual(@NotNull CoordinateSequence cs1, @NotNull CoordinateSequence cs2) {
        Intrinsics.checkNotNullParameter((Object)cs1, (String)"cs1");
        Intrinsics.checkNotNullParameter((Object)cs2, (String)"cs2");
        int cs1Size = cs1.size();
        int cs2Size = cs2.size();
        if (cs1Size != cs2Size) {
            return false;
        }
        int dim = Math.INSTANCE.min(cs1.getDimension(), cs2.getDimension());
        for (int i = 0; i < cs1Size; ++i) {
            for (int d = 0; d < dim; ++d) {
                double v1 = cs1.getOrdinate(i, d);
                double v2 = cs2.getOrdinate(i, d);
                if (cs1.getOrdinate(i, d) == cs2.getOrdinate(i, d) || Math.INSTANCE.isNaN(v1) && Math.INSTANCE.isNaN(v2)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull CoordinateSequence cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        int size = cs.size();
        if (size == 0) {
            return "()";
        }
        int dim = cs.getDimension();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            for (int d = 0; d < dim; ++d) {
                if (d > 0) {
                    builder.append(",");
                }
                builder.append(OrdinateFormat.DEFAULT.format(cs.getOrdinate(i, d)));
            }
        }
        builder.append(')');
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final Coordinate minCoordinate(@NotNull CoordinateSequence seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Coordinate minCoord = null;
        int n = seq.size();
        for (int i = 0; i < n; ++i) {
            Coordinate testCoord = seq.getCoordinate(i);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
        }
        return minCoord;
    }

    @JvmStatic
    @JvmOverloads
    public static final int minCoordinateIndex(@NotNull CoordinateSequence seq, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        int minCoordIndex = -1;
        Coordinate minCoord = null;
        int i = from;
        if (i <= to) {
            while (true) {
                Coordinate testCoord = seq.getCoordinate(i);
                if (minCoord == null || minCoord.compareTo(testCoord) > 0) {
                    minCoord = testCoord;
                    minCoordIndex = i;
                }
                if (i == to) break;
                ++i;
            }
        }
        return minCoordIndex;
    }

    public static /* synthetic */ int minCoordinateIndex$default(CoordinateSequence coordinateSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = coordinateSequence.size() - 1;
        }
        return CoordinateSequences.minCoordinateIndex(coordinateSequence, n, n2);
    }

    public final void scroll(@NotNull CoordinateSequence seq, @NotNull Coordinate firstCoordinate) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Intrinsics.checkNotNullParameter((Object)firstCoordinate, (String)"firstCoordinate");
        int i = CoordinateSequences.indexOf(firstCoordinate, seq);
        if (i <= 0) {
            return;
        }
        CoordinateSequences.scroll$default(seq, i, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void scroll(@NotNull CoordinateSequence seq, int indexOfFirstCoordinate, boolean ensureRing) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        if (indexOfFirstCoordinate <= 0) {
            return;
        }
        CoordinateSequence copy = seq.copy();
        int last = ensureRing ? seq.size() - 1 : seq.size();
        for (int j = 0; j < last; ++j) {
            int n = seq.getDimension();
            for (int k = 0; k < n; ++k) {
                seq.setOrdinate(j, k, copy.getOrdinate((indexOfFirstCoordinate + j) % last, k));
            }
        }
        if (ensureRing) {
            int n = seq.getDimension();
            for (int k = 0; k < n; ++k) {
                seq.setOrdinate(last, k, seq.getOrdinate(0, k));
            }
        }
    }

    public static /* synthetic */ void scroll$default(CoordinateSequence coordinateSequence, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = CoordinateSequences.isRing(coordinateSequence);
        }
        CoordinateSequences.scroll(coordinateSequence, n, bl);
    }

    @JvmStatic
    public static final int indexOf(@NotNull Coordinate coordinate, @NotNull CoordinateSequence seq) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        int n = seq.size();
        for (int i = 0; i < n; ++i) {
            if (!(coordinate.x == seq.getOrdinate(i, 0)) || !(coordinate.y == seq.getOrdinate(i, 1))) continue;
            return i;
        }
        return -1;
    }

    @JvmStatic
    @JvmOverloads
    public static final int minCoordinateIndex(@NotNull CoordinateSequence seq, int from) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        return CoordinateSequences.minCoordinateIndex$default(seq, from, 0, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final int minCoordinateIndex(@NotNull CoordinateSequence seq) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        return CoordinateSequences.minCoordinateIndex$default(seq, 0, 0, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void scroll(@NotNull CoordinateSequence seq, int indexOfFirstCoordinate) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        CoordinateSequences.scroll$default(seq, indexOfFirstCoordinate, false, 4, null);
    }
}

