/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b!\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 K2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0001KB\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006B)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0005\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0005\u0010\u0012B\u0011\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0014J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004J\b\u0010!\u001a\u00020\"H\u0016J&\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010#\u001a\u00020\u0000J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0000H\u0016J\b\u0010$\u001a\u00020\"H\u0016J\b\u00100\u001a\u00020\bH\u0016J\b\u00101\u001a\u00020\bH\u0016J\u0010\u00102\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\bH\u0016J\u0016\u00103\u001a\u00020\"2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\bJ\u0016\u00102\u001a\u00020\"2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bJ\u0010\u00102\u001a\u00020\"2\u0006\u00109\u001a\u00020\u0000H\u0016J\u0016\u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\bJ\n\u0010=\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010>\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0016J\u000e\u0010?\u001a\u00020&2\u0006\u00109\u001a\u00020\u0000J\u0018\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u000eH\u0016J\u000e\u0010B\u001a\u00020&2\u0006\u00109\u001a\u00020\u0000J\u0010\u0010C\u001a\u00020&2\u0006\u00109\u001a\u00020\u0000H\u0007J\u0010\u0010?\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010C\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u000eH\u0017J\u0016\u0010?\u001a\u00020&2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bJ\u0018\u0010C\u001a\u00020&2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0007J\u0011\u0010D\u001a\u00020&2\u0006\u00109\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010D\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u000eH\u0096\u0002J\u0018\u0010D\u001a\u00020&2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bH\u0016J\u0016\u0010E\u001a\u00020&2\u0006\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\bJ\u0010\u0010E\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u000e\u0010E\u001a\u00020&2\u0006\u00109\u001a\u00020\u0000J\u000e\u00104\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0000J\u0014\u0010F\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010G\u001a\u00020HH\u0096\u0080\u0004J\u0014\u0010I\u001a\u00020\u00162\b\u0010J\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004R\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u001e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0011\u0010(\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001aR\u0011\u0010*\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001aR\u0011\u0010,\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001aR\u0014\u0010.\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001a\u00a8\u0006L"}, d2={"Lorg/locationtech/jts/geom/Envelope;", "", "", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "<init>", "()V", "x1", "", "x2", "y1", "y2", "(DDDD)V", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "p", "(Lorg/locationtech/jts/geom/Coordinate;)V", "env", "(Lorg/locationtech/jts/geom/Envelope;)V", "hashCode", "", "value", "minX", "getMinX", "()D", "maxX", "getMaxX", "minY", "getMinY", "maxY", "getMaxY", "init", "", "copy", "setToNull", "isNull", "", "()Z", "width", "getWidth", "height", "getHeight", "diameter", "getDiameter", "area", "getArea", "minExtent", "maxExtent", "expandToInclude", "expandBy", "distance", "deltaX", "deltaY", "x", "y", "other", "translate", "transX", "transY", "centre", "intersection", "intersects", "a", "b", "disjoint", "overlaps", "contains", "covers", "equals", "toString", "", "compareTo", "o", "Companion", "kts-core"})
public class Envelope
implements Comparable<Object>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private static final long serialVersionUID = 5873921885273102420L;

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.minX);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.maxX);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.minY);
        result2 = 37 * result2 + Coordinate.Companion.hashCode(this.maxY);
        return result2;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public Envelope() {
        this.init();
    }

    public Envelope(double x1, double x2, double y1, double y2) {
        this.init(x1, x2, y1, y2);
    }

    public Envelope(@NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.init(p1.x, p2.x, p1.y, p2.y);
    }

    public Envelope(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.init(p.x, p.x, p.y, p.y);
    }

    public Envelope(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.init(env);
    }

    public void init() {
        this.setToNull();
    }

    public final void init(double x1, double x2, double y1, double y2) {
        if (x1 < x2) {
            this.minX = x1;
            this.maxX = x2;
        } else {
            this.minX = x2;
            this.maxX = x1;
        }
        if (y1 < y2) {
            this.minY = y1;
            this.maxY = y2;
        } else {
            this.minY = y2;
            this.maxY = y1;
        }
    }

    @NotNull
    public final Envelope copy() {
        return new Envelope(this);
    }

    public void init(@NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.init(p1.x, p2.x, p1.y, p2.y);
    }

    public void init(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.init(p.x, p.x, p.y, p.y);
    }

    public void init(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.minX = env.minX;
        this.maxX = env.maxX;
        this.minY = env.minY;
        this.maxY = env.maxY;
    }

    public void setToNull() {
        this.minX = 0.0;
        this.maxX = -1.0;
        this.minY = 0.0;
        this.maxY = -1.0;
    }

    public boolean isNull() {
        return this.maxX < this.minX;
    }

    public final double getWidth() {
        return this.isNull() ? 0.0 : this.maxX - this.minX;
    }

    public final double getHeight() {
        return this.isNull() ? 0.0 : this.maxY - this.minY;
    }

    public final double getDiameter() {
        if (this.isNull()) {
            return 0.0;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        return Math.sqrt(w * w + h * h);
    }

    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    public double minExtent() {
        double h;
        if (this.isNull()) {
            return 0.0;
        }
        double w = this.getWidth();
        return w < (h = this.getHeight()) ? w : h;
    }

    public double maxExtent() {
        double h;
        if (this.isNull()) {
            return 0.0;
        }
        double w = this.getWidth();
        return w > (h = this.getHeight()) ? w : h;
    }

    public void expandToInclude(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.expandToInclude(p.x, p.y);
    }

    public void expandBy(double distance) {
        this.expandBy(distance, distance);
    }

    public final void expandBy(double deltaX, double deltaY) {
        if (this.isNull()) {
            return;
        }
        this.minX -= deltaX;
        this.maxX += deltaX;
        this.minY -= deltaY;
        this.maxY += deltaY;
        if (this.minX > this.maxX || this.minY > this.maxY) {
            this.setToNull();
        }
    }

    public final void expandToInclude(double x, double y) {
        if (this.isNull()) {
            this.minX = x;
            this.maxX = x;
            this.minY = y;
            this.maxY = y;
        } else {
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
        }
    }

    public void expandToInclude(@NotNull Envelope other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.isNull()) {
            return;
        }
        if (this.isNull()) {
            this.minX = other.minX;
            this.maxX = other.maxX;
            this.minY = other.minY;
            this.maxY = other.maxY;
        } else {
            if (other.minX < this.minX) {
                this.minX = other.minX;
            }
            if (other.maxX > this.maxX) {
                this.maxX = other.maxX;
            }
            if (other.minY < this.minY) {
                this.minY = other.minY;
            }
            if (other.maxY > this.maxY) {
                this.maxY = other.maxY;
            }
        }
    }

    public final void translate(double transX, double transY) {
        if (this.isNull()) {
            return;
        }
        this.init(this.minX + transX, this.maxX + transX, this.minY + transY, this.maxY + transY);
    }

    @Nullable
    public Coordinate centre() {
        return this.isNull() ? null : new Coordinate((this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0);
    }

    @NotNull
    public Envelope intersection(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        if (this.isNull() || env.isNull() || !this.intersects(env)) {
            return new Envelope();
        }
        double intMinX = this.minX > env.minX ? this.minX : env.minX;
        double intMinY = this.minY > env.minY ? this.minY : env.minY;
        double intMaxX = this.maxX < env.maxX ? this.maxX : env.maxX;
        double intMaxY = this.maxY < env.maxY ? this.maxY : env.maxY;
        return new Envelope(intMinX, intMaxX, intMinY, intMaxY);
    }

    public final boolean intersects(@NotNull Envelope other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.isNull() || other.isNull() ? false : !(other.minX > this.maxX || other.maxX < this.minX || other.minY > this.maxY || other.maxY < this.minY);
    }

    public boolean intersects(@NotNull Coordinate a, @NotNull Coordinate b) {
        double envminy;
        double envmaxx;
        double envminx;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.isNull()) {
            return false;
        }
        double d = envminx = a.x < b.x ? a.x : b.x;
        if (envminx > this.maxX) {
            return false;
        }
        double d2 = envmaxx = a.x > b.x ? a.x : b.x;
        if (envmaxx < this.minX) {
            return false;
        }
        double d3 = envminy = a.y < b.y ? a.y : b.y;
        if (envminy > this.maxY) {
            return false;
        }
        double envmaxy = a.y > b.y ? a.y : b.y;
        return envmaxy >= this.minY;
    }

    public final boolean disjoint(@NotNull Envelope other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.isNull() || other.isNull() ? true : other.minX > this.maxX || other.maxX < this.minX || other.minY > this.maxY || other.maxY < this.minY;
    }

    @Deprecated(message="Use #intersects instead. In the future, #overlaps may be\n    changed to be a true overlap check; that is, whether the intersection is\n    two-dimensional.")
    public final boolean overlaps(@NotNull Envelope other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.intersects(other);
    }

    public boolean intersects(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.intersects(p.x, p.y);
    }

    @Deprecated(message="Use #intersects instead.")
    public boolean overlaps(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.intersects(p);
    }

    public final boolean intersects(double x, double y) {
        return this.isNull() ? false : !(x > this.maxX || x < this.minX || y > this.maxY || y < this.minY);
    }

    @Deprecated(message="Use #intersects instead.")
    public final boolean overlaps(double x, double y) {
        return this.intersects(x, y);
    }

    public boolean contains(@NotNull Envelope other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.covers(other);
    }

    public boolean contains(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.covers(p);
    }

    public boolean contains(double x, double y) {
        return this.covers(x, y);
    }

    public final boolean covers(double x, double y) {
        boolean bl;
        if (this.isNull()) {
            bl = false;
        } else {
            double d = this.minX;
            bl = (x <= this.maxX ? d <= x : false) && y >= this.minY && y <= this.maxY;
        }
        return bl;
    }

    public boolean covers(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.covers(p.x, p.y);
    }

    public final boolean covers(@NotNull Envelope other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.isNull() || other.isNull() ? false : other.minX >= this.minX && other.maxX <= this.maxX && other.minY >= this.minY && other.maxY <= this.maxY;
    }

    public final double distance(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        if (this.intersects(env)) {
            return 0.0;
        }
        double dx = 0.0;
        if (this.maxX < env.minX) {
            dx = env.minX - this.maxX;
        } else if (this.minX > env.maxX) {
            dx = this.minX - env.maxX;
        }
        double dy = 0.0;
        if (this.maxY < env.minY) {
            dy = env.minY - this.maxY;
        } else if (this.minY > env.maxY) {
            dy = this.minY - env.maxY;
        }
        if (dx == 0.0) {
            return dy;
        }
        return dy == 0.0 ? dx : Math.sqrt(dx * dx + dy * dy);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Envelope)) {
            return false;
        }
        return this.isNull() ? ((Envelope)other).isNull() : this.maxX == ((Envelope)other).maxX && this.maxY == ((Envelope)other).maxY && this.minX == ((Envelope)other).minX && this.minY == ((Envelope)other).minY;
    }

    @NotNull
    public String toString() {
        return "Env[" + this.minX + " : " + this.maxX + ", " + this.minY + " : " + this.maxY + "]";
    }

    @Override
    public int compareTo(@Nullable Object o) {
        Envelope env = (Envelope)o;
        if (this.isNull()) {
            Envelope envelope = env;
            Intrinsics.checkNotNull((Object)envelope);
            return envelope.isNull() ? 0 : -1;
        }
        Envelope envelope = env;
        Intrinsics.checkNotNull((Object)envelope);
        if (envelope.isNull()) {
            return 1;
        }
        if (this.minX < env.minX) {
            return -1;
        }
        if (this.minX > env.minX) {
            return 1;
        }
        if (this.minY < env.minY) {
            return -1;
        }
        if (this.minY > env.minY) {
            return 1;
        }
        if (this.maxX < env.maxX) {
            return -1;
        }
        if (this.maxX > env.maxX) {
            return 1;
        }
        if (this.maxY < env.maxY) {
            return -1;
        }
        return this.maxY > env.maxY ? 1 : 0;
    }

    @JvmStatic
    public static boolean intersects(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q) {
        return Companion.intersects(p1, p2, q);
    }

    @JvmStatic
    public static boolean intersects(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q1, @NotNull Coordinate q2) {
        return Companion.intersects(p1, p2, q1, q2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0017J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/geom/Envelope$Companion;", "", "<init>", "()V", "serialVersionUID", "", "intersects", "", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "q", "q1", "q2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public boolean intersects(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            double d = q.x;
            double d2 = p1.x < p2.x ? p1.x : p2.x;
            if (!(d >= d2)) return false;
            double d3 = q.x;
            double d4 = p1.x > p2.x ? p1.x : p2.x;
            if (!(d3 <= d4)) return false;
            double d5 = q.y;
            double d6 = p1.y < p2.y ? p1.y : p2.y;
            if (!(d5 >= d6)) return false;
            double d7 = q.y;
            double d8 = p1.y > p2.y ? p1.y : p2.y;
            if (!(d7 <= d8)) return false;
            return true;
        }

        @JvmStatic
        public boolean intersects(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q1, @NotNull Coordinate q2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            Intrinsics.checkNotNullParameter((Object)q1, (String)"q1");
            Intrinsics.checkNotNullParameter((Object)q2, (String)"q2");
            double minq = Math.min(q1.x, q2.x);
            double maxq = Math.max(q1.x, q2.x);
            double minp = Math.min(p1.x, p2.x);
            double maxp = Math.max(p1.x, p2.x);
            if (minp > maxq) {
                return false;
            }
            if (maxp < minq) {
                return false;
            }
            minq = Math.min(q1.y, q2.y);
            maxq = Math.max(q1.y, q2.y);
            minp = Math.min(p1.y, p2.y);
            maxp = Math.max(p1.y, p2.y);
            if (minp > maxq) {
                return false;
            }
            return maxp >= minq;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

