/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Centroid;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.InteriorPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.GeometryOverlay;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.legacy.Cloneable;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.locationtech.jts.operation.predicate.RectangleContains;
import org.locationtech.jts.operation.predicate.RectangleIntersects;
import org.locationtech.jts.operation.relate.RelateOp;
import org.locationtech.jts.operation.valid.IsSimpleOp;
import org.locationtech.jts.operation.valid.IsValidOp;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\t\b&\u0018\u0000 \u008d\u00012\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u00060\u0004j\u0002`\u0005:\u0002\u008d\u0001B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0000H\u0016J\u0018\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020\u00002\u0006\u00103\u001a\u000204H\u0016J\b\u0010K\u001a\u00020\u0000H\u0016J\u0006\u0010O\u001a\u00020\u001fJ\b\u0010P\u001a\u00020\u001fH\u0004J\u000e\u0010Q\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u000e\u0010R\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u000e\u0010S\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u000e\u0010T\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u000e\u0010U\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u0011\u0010V\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010W\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u000e\u0010X\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u000e\u0010Y\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u0016\u0010Z\u001a\u00020/2\u0006\u00105\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0016J\u000e\u0010Z\u001a\u00020\\2\u0006\u00105\u001a\u00020\u0000J\u0010\u0010]\u001a\u00020/2\b\u00105\u001a\u0004\u0018\u00010\u0000J\u000e\u0010^\u001a\u00020/2\u0006\u00105\u001a\u00020\u0000J\u0014\u0010]\u001a\u00020/2\b\u0010_\u001a\u0004\u0018\u00010\u0003H\u0096\u0082\u0004J\n\u0010`\u001a\u00020\u000fH\u0096\u0080\u0004J\n\u0010a\u001a\u00020\u0016H\u0096\u0080\u0004J\u0006\u0010b\u001a\u00020\u0016J\u000e\u0010c\u001a\u00020\u00002\u0006\u00103\u001a\u000204J\u0018\u0010c\u001a\u00020\u00002\u0006\u00103\u001a\u0002042\u0006\u0010d\u001a\u00020\u000fH\u0016J \u0010c\u001a\u00020\u00002\u0006\u00103\u001a\u0002042\u0006\u0010d\u001a\u00020\u000f2\u0006\u0010e\u001a\u00020\u000fH\u0016J\n\u0010f\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010g\u001a\u00020\u0000H\u0016J\b\u0010h\u001a\u00020\u0000H$J\u0010\u0010i\u001a\u00020\u00002\b\u0010j\u001a\u0004\u0018\u00010\u0000J\u0010\u0010k\u001a\u00020\u00002\b\u0010j\u001a\u0004\u0018\u00010\u0000J\u0010\u0010l\u001a\u00020\u00002\b\u0010j\u001a\u0004\u0018\u00010\u0000J\u0010\u0010m\u001a\u00020\u00002\b\u0010j\u001a\u0004\u0018\u00010\u0000J\b\u0010k\u001a\u0004\u0018\u00010\u0000J\u001a\u0010n\u001a\u00020/2\b\u0010j\u001a\u0004\u0018\u00010\u00002\u0006\u0010o\u001a\u000204H&J\u000e\u0010n\u001a\u00020/2\u0006\u0010j\u001a\u00020\u0000J\u0010\u0010p\u001a\u00020/2\b\u00105\u001a\u0004\u0018\u00010\u0000J\u0010\u0010q\u001a\u00020\u001f2\u0006\u0010r\u001a\u00020sH&J\u0010\u0010q\u001a\u00020\u001f2\u0006\u0010r\u001a\u00020tH&J\u0010\u0010q\u001a\u00020\u001f2\u0006\u0010r\u001a\u00020uH&J\u0010\u0010q\u001a\u00020\u001f2\u0006\u0010r\u001a\u00020vH&J\b\u0010w\u001a\u00020\u0003H\u0017J\u0006\u0010x\u001a\u00020\u0000J\b\u0010y\u001a\u00020\u0000H$J\b\u0010z\u001a\u00020\u001fH&J\u0006\u0010{\u001a\u00020\u0000J\u0014\u0010|\u001a\u00020\u000f2\b\u0010_\u001a\u0004\u0018\u00010\u0003H\u0096\u0082\u0004J\u0018\u0010|\u001a\u00020\u000f2\u0006\u0010_\u001a\u00020\u00032\u0006\u0010}\u001a\u00020~H\u0016J\u0010\u0010\u007f\u001a\u00020/2\u0006\u0010j\u001a\u00020\u0000H\u0014J\u000b\u0010\u0081\u0001\u001a\u0004\u0018\u00010\rH$J\u0013\u0010\u0082\u0001\u001a\u00020\u000f2\b\u0010_\u001a\u0004\u0018\u00010\u0003H$J\u001b\u0010\u0082\u0001\u001a\u00020\u000f2\b\u0010_\u001a\u0004\u0018\u00010\u00032\u0006\u0010}\u001a\u00020~H&J%\u0010\u0083\u0001\u001a\u00020\u000f2\f\u0010\u0084\u0001\u001a\u0007\u0012\u0002\b\u00030\u0085\u00012\f\u0010\u0086\u0001\u001a\u0007\u0012\u0002\b\u00030\u0085\u0001H\u0004J%\u0010\u0087\u0001\u001a\u00020/2\u0007\u0010\u0084\u0001\u001a\u00020%2\t\u0010\u0086\u0001\u001a\u0004\u0018\u00010%2\u0006\u0010o\u001a\u000204H\u0004J\u001d\u0010\u008a\u0001\u001a\u00020?2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010%2\u0007\u0010\u008c\u0001\u001a\u00020\u0000H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u0004\u0018\u00010%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010)X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0012\u0010,\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u00100R\u0011\u00101\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b1\u00100R\u0012\u00102\u001a\u00020/X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00100R\u0014\u00108\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00100R\u0014\u00109\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010;R\u0014\u0010>\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0014\u0010B\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010AR\u0012\u0010D\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0011R\u0014\u0010F\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u0012\u0010I\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0011R\u0014\u0010L\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0013\u0010\u0080\u0001\u001a\u00020/8F\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u00100R\u0014\u0010\u0088\u0001\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0089\u0001\u0010\u0011\u00a8\u0006\u008e\u0001"}, d2={"Lorg/locationtech/jts/geom/Geometry;", "Lorg/locationtech/jts/legacy/Cloneable;", "", "", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "getFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "SRID", "", "getSRID", "()I", "setSRID", "(I)V", "userData", "geometryType", "", "getGeometryType", "()Ljava/lang/String;", "getUserData", "numGeometries", "getNumGeometries", "getGeometryN", "n", "setUserData", "", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "getPrecisionModel", "()Lorg/locationtech/jts/geom/PrecisionModel;", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "coordinates", "", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "numPoints", "getNumPoints", "isSimple", "", "()Z", "isValid", "isEmpty", "distance", "", "g", "isWithinDistance", "geom", "isRectangle", "area", "getArea", "()D", "length", "getLength", "centroid", "Lorg/locationtech/jts/geom/Point;", "getCentroid", "()Lorg/locationtech/jts/geom/Point;", "interiorPoint", "getInteriorPoint", "dimension", "getDimension", "boundary", "getBoundary", "()Lorg/locationtech/jts/geom/Geometry;", "boundaryDimension", "getBoundaryDimension", "getEnvelope", "envelopeInternal", "getEnvelopeInternal", "()Lorg/locationtech/jts/geom/Envelope;", "geometryChanged", "geometryChangedAction", "disjoint", "touches", "intersects", "crosses", "within", "contains", "overlaps", "covers", "coveredBy", "relate", "intersectionPattern", "Lorg/locationtech/jts/geom/IntersectionMatrix;", "equals", "equalsTopo", "o", "hashCode", "toString", "toText", "buffer", "quadrantSegments", "endCapStyle", "convexHull", "reverse", "reverseInternal", "intersection", "other", "union", "difference", "symDifference", "equalsExact", "tolerance", "equalsNorm", "apply", "filter", "Lorg/locationtech/jts/geom/CoordinateFilter;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "Lorg/locationtech/jts/geom/GeometryFilter;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "clone", "copy", "copyInternal", "normalize", "norm", "compareTo", "comp", "Lorg/locationtech/jts/geom/CoordinateSequenceComparator;", "isEquivalentClass", "isGeometryCollection", "computeEnvelopeInternal", "compareToSameClass", "compare", "a", "", "b", "equal", "typeCode", "getTypeCode", "createPointFromInternalCoord", "coord", "exemplar", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\norg/locationtech/jts/geom/Geometry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1770:1\n1#2:1771\n*E\n"})
public abstract class Geometry
implements Cloneable,
Comparable<Object>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory factory;
    @Nullable
    private Envelope envelope;
    private int SRID;
    @Nullable
    private Object userData;
    private static final long serialVersionUID = 8763622679187376702L;
    public static final int TYPECODE_POINT = 0;
    public static final int TYPECODE_MULTIPOINT = 1;
    public static final int TYPECODE_LINESTRING = 2;
    public static final int TYPECODE_LINEARRING = 3;
    public static final int TYPECODE_MULTILINESTRING = 4;
    public static final int TYPECODE_POLYGON = 5;
    public static final int TYPECODE_MULTIPOLYGON = 6;
    public static final int TYPECODE_GEOMETRYCOLLECTION = 7;
    @NotNull
    public static final String TYPENAME_POINT = "Point";
    @NotNull
    public static final String TYPENAME_MULTIPOINT = "MultiPoint";
    @NotNull
    public static final String TYPENAME_LINESTRING = "LineString";
    @NotNull
    public static final String TYPENAME_LINEARRING = "LinearRing";
    @NotNull
    public static final String TYPENAME_MULTILINESTRING = "MultiLineString";
    @NotNull
    public static final String TYPENAME_POLYGON = "Polygon";
    @NotNull
    public static final String TYPENAME_MULTIPOLYGON = "MultiPolygon";
    @NotNull
    public static final String TYPENAME_GEOMETRYCOLLECTION = "GeometryCollection";
    @NotNull
    private static final Companion.GeometryComponentFilter1 geometryChangedFilter = new Companion.GeometryComponentFilter1();

    public Geometry(@NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
        this.SRID = this.factory.getSRID();
    }

    @NotNull
    public final GeometryFactory getFactory() {
        return this.factory;
    }

    public final int getSRID() {
        return this.SRID;
    }

    public final void setSRID(int n) {
        this.SRID = n;
    }

    @Nullable
    public abstract String getGeometryType();

    @Nullable
    public final Object getUserData() {
        return this.userData;
    }

    public int getNumGeometries() {
        return 1;
    }

    @NotNull
    public Geometry getGeometryN(int n) {
        return this;
    }

    public final void setUserData(@Nullable Object userData) {
        this.userData = userData;
    }

    @NotNull
    public final PrecisionModel getPrecisionModel() {
        return this.factory.getPrecisionModel();
    }

    @Nullable
    public abstract Coordinate getCoordinate();

    @Nullable
    public abstract Coordinate[] getCoordinates();

    public abstract int getNumPoints();

    public boolean isSimple() {
        IsSimpleOp op = new IsSimpleOp(this, null, 2, null);
        return op.isSimple();
    }

    public final boolean isValid() {
        return IsValidOp.Companion.isValid(this);
    }

    public abstract boolean isEmpty();

    public double distance(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return DistanceOp.Companion.distance(this, g);
    }

    public boolean isWithinDistance(@NotNull Geometry geom, double distance) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return DistanceOp.Companion.isWithinDistance(this, geom, distance);
    }

    public boolean isRectangle() {
        return false;
    }

    public double getArea() {
        return 0.0;
    }

    public double getLength() {
        return 0.0;
    }

    @NotNull
    public Point getCentroid() {
        if (this.isEmpty()) {
            return GeometryFactory.createPoint$default(this.factory, null, 1, null);
        }
        Coordinate centPt = Centroid.Companion.getCentroid(this);
        return this.createPointFromInternalCoord(centPt, this);
    }

    @NotNull
    public Point getInteriorPoint() {
        if (this.isEmpty()) {
            return GeometryFactory.createPoint$default(this.factory, null, 1, null);
        }
        Coordinate pt = InteriorPoint.INSTANCE.getInteriorPoint(this);
        return this.createPointFromInternalCoord(pt, this);
    }

    public abstract int getDimension();

    @Nullable
    public abstract Geometry getBoundary();

    public abstract int getBoundaryDimension();

    @NotNull
    public Geometry getEnvelope() {
        return this.factory.toGeometry(this.getEnvelopeInternal());
    }

    @NotNull
    public Envelope getEnvelopeInternal() {
        if (this.envelope == null) {
            this.envelope = this.computeEnvelopeInternal();
        }
        Envelope envelope = this.envelope;
        Intrinsics.checkNotNull((Object)envelope);
        return new Envelope(envelope);
    }

    public final void geometryChanged() {
        this.apply(geometryChangedFilter);
    }

    protected final void geometryChangedAction() {
        this.envelope = null;
    }

    public final boolean disjoint(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return !this.intersects(g);
    }

    public final boolean touches(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return !this.getEnvelopeInternal().intersects(g.getEnvelopeInternal()) ? false : this.relate(g).isTouches(this.getDimension(), g.getDimension());
    }

    public final boolean intersects(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.getEnvelopeInternal().intersects(g.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            return RectangleIntersects.Companion.intersects((Polygon)this, g);
        }
        if (g.isRectangle()) {
            return RectangleIntersects.Companion.intersects((Polygon)g, this);
        }
        if (this.isGeometryCollection() || g.isGeometryCollection()) {
            int n = this.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                int n2 = g.getNumGeometries();
                for (int j = 0; j < n2; ++j) {
                    if (!this.getGeometryN(i).intersects(g.getGeometryN(j))) continue;
                    return true;
                }
            }
            return false;
        }
        return this.relate(g).isIntersects();
    }

    public final boolean crosses(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return !this.getEnvelopeInternal().intersects(g.getEnvelopeInternal()) ? false : this.relate(g).isCrosses(this.getDimension(), g.getDimension());
    }

    public final boolean within(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return g.contains(this);
    }

    public final boolean contains(@NotNull Geometry g) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (g.getDimension() == 2 && this.getDimension() < 2) {
            return false;
        }
        if (g.getDimension() == 1 && this.getDimension() < 1 && g.getLength() > 0.0) {
            return false;
        }
        if (!this.getEnvelopeInternal().contains(g.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            bl = RectangleContains.Companion.contains((Polygon)this, g);
        } else {
            bl = this.relate(g).isContains();
        }
        return bl;
    }

    public final boolean overlaps(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return !this.getEnvelopeInternal().intersects(g.getEnvelopeInternal()) ? false : this.relate(g).isOverlaps(this.getDimension(), g.getDimension());
    }

    public final boolean covers(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (g.getDimension() == 2 && this.getDimension() < 2) {
            return false;
        }
        if (g.getDimension() == 1 && this.getDimension() < 1 && g.getLength() > 0.0) {
            return false;
        }
        if (!this.getEnvelopeInternal().covers(g.getEnvelopeInternal())) {
            return false;
        }
        return this.isRectangle() ? true : this.relate(g).isCovers();
    }

    public final boolean coveredBy(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return g.covers(this);
    }

    public final boolean relate(@NotNull Geometry g, @NotNull String intersectionPattern) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)intersectionPattern, (String)"intersectionPattern");
        return this.relate(g).matches(intersectionPattern);
    }

    @NotNull
    public final IntersectionMatrix relate(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Companion.checkNotGeometryCollection(this);
        Companion.checkNotGeometryCollection(g);
        return RelateOp.Companion.relate(this, g);
    }

    public final boolean equals(@Nullable Geometry g) {
        boolean bl;
        Geometry geometry = g;
        if (geometry != null) {
            Geometry it = geometry;
            boolean bl2 = false;
            bl = this.equalsTopo(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean equalsTopo(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        return !Intrinsics.areEqual((Object)this.getEnvelopeInternal(), (Object)g.getEnvelopeInternal()) ? false : this.relate(g).isEquals(this.getDimension(), g.getDimension());
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Geometry)) {
            return false;
        }
        return this.equalsExact((Geometry)o);
    }

    public int hashCode() {
        return this.getEnvelopeInternal().hashCode();
    }

    @NotNull
    public String toString() {
        return this.toText();
    }

    @NotNull
    public final String toText() {
        WKTWriter writer = new WKTWriter(0, 1, null);
        return writer.write(this);
    }

    @NotNull
    public final Geometry buffer(double distance) {
        return BufferOp.Companion.bufferOp(this, distance);
    }

    @NotNull
    public Geometry buffer(double distance, int quadrantSegments) {
        return BufferOp.Companion.bufferOp(this, distance, quadrantSegments);
    }

    @NotNull
    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return BufferOp.Companion.bufferOp(this, distance, quadrantSegments, endCapStyle);
    }

    @Nullable
    public Geometry convexHull() {
        return new ConvexHull(this).getConvexHull();
    }

    @NotNull
    public Geometry reverse() {
        Geometry res = this.reverseInternal();
        if (this.envelope != null) {
            Envelope envelope = this.envelope;
            Intrinsics.checkNotNull((Object)envelope);
            res.envelope = envelope.copy();
        }
        res.SRID = this.SRID;
        return res;
    }

    @NotNull
    protected abstract Geometry reverseInternal();

    @NotNull
    public final Geometry intersection(@Nullable Geometry other) {
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        return GeometryOverlay.INSTANCE.intersection(this, geometry);
    }

    @NotNull
    public final Geometry union(@Nullable Geometry other) {
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        return GeometryOverlay.INSTANCE.union(this, geometry);
    }

    @NotNull
    public final Geometry difference(@Nullable Geometry other) {
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        return GeometryOverlay.INSTANCE.difference(this, geometry);
    }

    @NotNull
    public final Geometry symDifference(@Nullable Geometry other) {
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        return GeometryOverlay.INSTANCE.symDifference(this, geometry);
    }

    @Nullable
    public final Geometry union() {
        return GeometryOverlay.INSTANCE.union(this);
    }

    public abstract boolean equalsExact(@Nullable Geometry var1, double var2);

    public final boolean equalsExact(@NotNull Geometry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this == other || this.equalsExact(other, 0.0);
    }

    public final boolean equalsNorm(@Nullable Geometry g) {
        return g == null ? false : this.norm().equalsExact(g.norm());
    }

    public abstract void apply(@NotNull CoordinateFilter var1);

    public abstract void apply(@NotNull CoordinateSequenceFilter var1);

    public abstract void apply(@NotNull GeometryFilter var1);

    public abstract void apply(@NotNull GeometryComponentFilter var1);

    @Override
    @Deprecated(message="")
    @NotNull
    public Object clone() {
        Geometry clone;
        Geometry geometry = clone = this.factory.createGeometry(this);
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.envelope != null) {
            Envelope envelope = clone.envelope;
            Intrinsics.checkNotNull((Object)envelope);
            clone.envelope = new Envelope(envelope);
        }
        return clone;
    }

    @NotNull
    public final Geometry copy() {
        Envelope envelope;
        Geometry copy = this.copyInternal();
        if (this.envelope == null) {
            envelope = null;
        } else {
            Envelope envelope2 = this.envelope;
            Intrinsics.checkNotNull((Object)envelope2);
            envelope = envelope2.copy();
        }
        copy.envelope = envelope;
        copy.SRID = this.SRID;
        copy.userData = this.userData;
        return copy;
    }

    @NotNull
    protected abstract Geometry copyInternal();

    public abstract void normalize();

    @NotNull
    public final Geometry norm() {
        Geometry copy = this.copy();
        copy.normalize();
        return copy;
    }

    @Override
    public int compareTo(@Nullable Object o) {
        Geometry other = (Geometry)o;
        int n = this.getTypeCode();
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        if (n != geometry.getTypeCode()) {
            return this.getTypeCode() - other.getTypeCode();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        return other.isEmpty() ? 1 : this.compareToSameClass(o);
    }

    public int compareTo(@NotNull Object o, @NotNull CoordinateSequenceComparator comp) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Geometry other = (Geometry)o;
        if (this.getTypeCode() != other.getTypeCode()) {
            return this.getTypeCode() - other.getTypeCode();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        return other.isEmpty() ? 1 : this.compareToSameClass(o, comp);
    }

    protected boolean isEquivalentClass(@NotNull Geometry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName(), (Object)Reflection.getOrCreateKotlinClass(other.getClass()).getSimpleName());
    }

    public final boolean isGeometryCollection() {
        return this.getTypeCode() == 7;
    }

    @Nullable
    protected abstract Envelope computeEnvelopeInternal();

    protected abstract int compareToSameClass(@Nullable Object var1);

    public abstract int compareToSameClass(@Nullable Object var1, @NotNull CoordinateSequenceComparator var2);

    protected final int compare(@NotNull Collection<?> a, @NotNull Collection<?> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        Iterator<?> i = a.iterator();
        Iterator<?> j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any?>");
            Comparable aElement = (Comparable)obj;
            Object obj2 = j.next();
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any?>");
            Comparable bElement = (Comparable)obj2;
            int comparison = aElement.compareTo(bElement);
            if (comparison == 0) continue;
            return comparison;
        }
        if (i.hasNext()) {
            return 1;
        }
        return j.hasNext() ? -1 : 0;
    }

    protected final boolean equal(@NotNull Coordinate a, @Nullable Coordinate b, double tolerance) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if (tolerance == 0.0) {
            bl = Intrinsics.areEqual((Object)a, (Object)b);
        } else {
            Coordinate coordinate = b;
            Intrinsics.checkNotNull((Object)coordinate);
            bl = a.distance(coordinate) <= tolerance;
        }
        return bl;
    }

    protected abstract int getTypeCode();

    private final Point createPointFromInternalCoord(Coordinate coord, Geometry exemplar) {
        if (coord == null) {
            return GeometryFactory.createPoint$default(exemplar.factory, null, 1, null);
        }
        exemplar.getPrecisionModel().makePrecise(coord);
        return exemplar.factory.createPoint(coord);
    }

    @JvmStatic
    protected static final boolean hasNonEmptyElements(@NotNull Geometry[] geometries) {
        return Companion.hasNonEmptyElements(geometries);
    }

    @JvmStatic
    protected static final boolean hasNullElements(@NotNull Geometry[] array) {
        return Companion.hasNullElements(array);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0005\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\u001b2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dH\u0005\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/geom/Geometry$Companion;", "", "<init>", "()V", "serialVersionUID", "", "TYPECODE_POINT", "", "TYPECODE_MULTIPOINT", "TYPECODE_LINESTRING", "TYPECODE_LINEARRING", "TYPECODE_MULTILINESTRING", "TYPECODE_POLYGON", "TYPECODE_MULTIPOLYGON", "TYPECODE_GEOMETRYCOLLECTION", "TYPENAME_POINT", "", "TYPENAME_MULTIPOINT", "TYPENAME_LINESTRING", "TYPENAME_LINEARRING", "TYPENAME_MULTILINESTRING", "TYPENAME_POLYGON", "TYPENAME_MULTIPOLYGON", "TYPENAME_GEOMETRYCOLLECTION", "geometryChangedFilter", "Lorg/locationtech/jts/geom/Geometry$Companion$GeometryComponentFilter1;", "hasNonEmptyElements", "", "geometries", "", "Lorg/locationtech/jts/geom/Geometry;", "([Lorg/locationtech/jts/geom/Geometry;)Z", "hasNullElements", "array", "checkNotGeometryCollection", "", "g", "GeometryComponentFilter1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        protected final boolean hasNonEmptyElements(@NotNull Geometry[] geometries) {
            Intrinsics.checkNotNullParameter((Object)geometries, (String)"geometries");
            int n = geometries.length;
            for (int i = 0; i < n; ++i) {
                if (geometries[i].isEmpty()) continue;
                return true;
            }
            return false;
        }

        @JvmStatic
        protected final boolean hasNullElements(@NotNull Geometry[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                if (array[i] != null) continue;
                return true;
            }
            return false;
        }

        public final void checkNotGeometryCollection(@NotNull Geometry g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (g.isGeometryCollection()) {
                throw new IllegalArgumentException("Operation does not support GeometryCollection arguments");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/geom/Geometry$Companion$GeometryComponentFilter1;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "<init>", "()V", "filter", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
        public static final class GeometryComponentFilter1
        implements GeometryComponentFilter {
            @Override
            public void filter(@NotNull Geometry geom) {
                Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
                geom.geometryChangedAction();
            }
        }
    }
}

