/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Length;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.BoundaryOp;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 X2\u00020\u00012\u00020\u0002:\u0001XB)\b\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u001b\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\n\u0010\u000fJ\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0003\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\tJ\b\u0010>\u001a\u00020\u0000H\u0016J\b\u0010?\u001a\u00020\u0000H\u0014J\u0010\u0010@\u001a\u00020&2\b\u0010A\u001a\u0004\u0018\u00010\u0005J\b\u0010B\u001a\u00020CH\u0014J\u001a\u0010D\u001a\u00020&2\b\u0010E\u001a\u0004\u0018\u00010\u00012\u0006\u0010F\u001a\u000208H\u0016J\u0010\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020JH\u0016J\u0010\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020KH\u0016J\u0010\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020NH\u0017J\b\u0010O\u001a\u00020\u0000H\u0014J\b\u0010P\u001a\u00020\u0017H\u0016J\u0010\u0010Q\u001a\u00020&2\u0006\u0010E\u001a\u00020\u0001H\u0014J\u0012\u0010R\u001a\u00020\t2\b\u0010S\u001a\u0004\u0018\u00010NH\u0016J\u001a\u0010R\u001a\u00020\t2\b\u0010S\u001a\u0004\u0018\u00010N2\u0006\u0010T\u001a\u00020UH\u0016R(\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\f@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0014\u0010(\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\"R\u0013\u0010,\u001a\u0004\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0013\u0010/\u001a\u0004\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0014\u00101\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010'R\u0011\u00102\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010'R\u0014\u00103\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0016\u0010;\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010V\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010\"\u00a8\u0006Y"}, d2={"Lorg/locationtech/jts/geom/LineString;", "Lorg/locationtech/jts/geom/Geometry;", "Lorg/locationtech/jts/geom/Lineal;", "points", "", "Lorg/locationtech/jts/geom/Coordinate;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "SRID", "", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/PrecisionModel;I)V", "Lorg/locationtech/jts/geom/CoordinateSequence;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "(Lorg/locationtech/jts/geom/CoordinateSequence;Lorg/locationtech/jts/geom/GeometryFactory;)V", "value", "coordinateSequence", "getCoordinateSequence", "()Lorg/locationtech/jts/geom/CoordinateSequence;", "setCoordinateSequence", "(Lorg/locationtech/jts/geom/CoordinateSequence;)V", "init", "", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "getCoordinateN", "n", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "dimension", "getDimension", "()I", "boundaryDimension", "getBoundaryDimension", "isEmpty", "", "()Z", "numPoints", "getNumPoints", "getPointN", "Lorg/locationtech/jts/geom/Point;", "startPoint", "getStartPoint", "()Lorg/locationtech/jts/geom/Point;", "endPoint", "getEndPoint", "isClosed", "isRing", "geometryType", "", "getGeometryType", "()Ljava/lang/String;", "length", "", "getLength", "()D", "boundary", "getBoundary", "()Lorg/locationtech/jts/geom/Geometry;", "reverse", "reverseInternal", "isCoordinate", "pt", "computeEnvelopeInternal", "Lorg/locationtech/jts/geom/Envelope;", "equalsExact", "other", "tolerance", "apply", "filter", "Lorg/locationtech/jts/geom/CoordinateFilter;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "Lorg/locationtech/jts/geom/GeometryFilter;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "clone", "", "copyInternal", "normalize", "isEquivalentClass", "compareToSameClass", "o", "comp", "Lorg/locationtech/jts/geom/CoordinateSequenceComparator;", "typeCode", "getTypeCode", "Companion", "kts-core"})
public class LineString
extends Geometry
implements Lineal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CoordinateSequence coordinateSequence;
    private static final long serialVersionUID = 3110669828065365560L;
    public static final int MINIMUM_VALID_SIZE = 2;

    @Nullable
    public CoordinateSequence getCoordinateSequence() {
        return this.coordinateSequence;
    }

    protected void setCoordinateSequence(@Nullable CoordinateSequence coordinateSequence) {
        this.coordinateSequence = coordinateSequence;
    }

    @Deprecated(message="Use GeometryFactory instead ")
    public LineString(@Nullable Coordinate[] points, @NotNull PrecisionModel precisionModel, int SRID) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        super(new GeometryFactory(precisionModel, SRID));
        this.init(this.getFactory().getCoordinateSequenceFactory().create(points));
    }

    public LineString(@Nullable CoordinateSequence points, @NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(factory);
        this.init(points);
    }

    private final void init(CoordinateSequence points) {
        int n;
        CoordinateSequence points2 = points;
        if (points2 == null) {
            points2 = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        boolean bl = 1 <= (n = points2.size()) ? n < 2 : false;
        if (bl) {
            throw new IllegalArgumentException("Invalid number of points in LineString (found " + points2.size() + " - must be 0 or >= 2)");
        }
        this.setCoordinateSequence(points2);
    }

    @Override
    @NotNull
    public Coordinate[] getCoordinates() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return coordinateSequence.toCoordinateArray();
    }

    @NotNull
    public Coordinate getCoordinateN(int n) {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return coordinateSequence.getCoordinate(n);
    }

    @Override
    @Nullable
    public Coordinate getCoordinate() {
        Coordinate coordinate;
        if (this.isEmpty()) {
            coordinate = null;
        } else {
            CoordinateSequence coordinateSequence = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence);
            coordinate = coordinateSequence.getCoordinate(0);
        }
        return coordinate;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public int getBoundaryDimension() {
        return this.isClosed() ? -1 : 0;
    }

    @Override
    public boolean isEmpty() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return coordinateSequence.size() == 0;
    }

    @Override
    public int getNumPoints() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return coordinateSequence.size();
    }

    @NotNull
    public final Point getPointN(int n) {
        GeometryFactory geometryFactory = this.getFactory();
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return geometryFactory.createPoint(coordinateSequence.getCoordinate(n));
    }

    @Nullable
    public final Point getStartPoint() {
        return this.isEmpty() ? null : this.getPointN(0);
    }

    @Nullable
    public final Point getEndPoint() {
        return this.isEmpty() ? null : this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        return this.isEmpty() ? false : this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public final boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    @Override
    @NotNull
    public String getGeometryType() {
        return "LineString";
    }

    @Override
    public double getLength() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return Length.ofLine(coordinateSequence);
    }

    @Override
    @Nullable
    public Geometry getBoundary() {
        return new BoundaryOp(this, null, 2, null).getBoundary();
    }

    @Override
    @NotNull
    public LineString reverse() {
        Geometry geometry = super.reverse();
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        return (LineString)geometry;
    }

    @Override
    @NotNull
    protected LineString reverseInternal() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        CoordinateSequence seq = coordinateSequence.copy();
        CoordinateSequences.reverse(seq);
        return this.getFactory().createLineString(seq);
    }

    public final boolean isCoordinate(@Nullable Coordinate pt) {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        for (int i = 0; i < n; ++i) {
            CoordinateSequence coordinateSequence2 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            if (!Intrinsics.areEqual((Object)coordinateSequence2.getCoordinate(i), (Object)pt)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected Envelope computeEnvelopeInternal() {
        Envelope envelope;
        if (this.isEmpty()) {
            envelope = new Envelope();
        } else {
            CoordinateSequence coordinateSequence = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence);
            envelope = coordinateSequence.expandEnvelope(new Envelope());
        }
        return envelope;
    }

    @Override
    public boolean equalsExact(@Nullable Geometry other, double tolerance) {
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        LineString otherLineString = (LineString)other;
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        CoordinateSequence coordinateSequence2 = otherLineString.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence2);
        if (n != coordinateSequence2.size()) {
            return false;
        }
        CoordinateSequence coordinateSequence3 = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence3);
        int n2 = coordinateSequence3.size();
        for (int i = 0; i < n2; ++i) {
            CoordinateSequence coordinateSequence4 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence4);
            Coordinate coordinate = coordinateSequence4.getCoordinate(i);
            CoordinateSequence coordinateSequence5 = otherLineString.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence5);
            if (this.equal(coordinate, coordinateSequence5.getCoordinate(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(@NotNull CoordinateFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        for (int i = 0; i < n; ++i) {
            CoordinateSequence coordinateSequence2 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            filter.filter(coordinateSequence2.getCoordinate(i));
        }
    }

    @Override
    public void apply(@NotNull CoordinateSequenceFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        if (coordinateSequence.size() == 0) {
            return;
        }
        CoordinateSequence coordinateSequence2 = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence2);
        int n = coordinateSequence2.size();
        for (int i = 0; i < n; ++i) {
            filter.filter(this.getCoordinateSequence(), i);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(@NotNull GeometryFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        filter.filter(this);
    }

    @Override
    public void apply(@NotNull GeometryComponentFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        filter.filter(this);
    }

    @Override
    @Deprecated(message="")
    @NotNull
    public Object clone() {
        return this.copy();
    }

    @Override
    @NotNull
    protected LineString copyInternal() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return new LineString(coordinateSequence.copy(), this.getFactory());
    }

    @Override
    public void normalize() {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size() / 2;
        for (int i = 0; i < n; ++i) {
            CoordinateSequence coordinateSequence2 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            int j = coordinateSequence2.size() - 1 - i;
            CoordinateSequence coordinateSequence3 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence3);
            Coordinate coordinate = coordinateSequence3.getCoordinate(i);
            CoordinateSequence coordinateSequence4 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence4);
            if (Intrinsics.areEqual((Object)coordinate, (Object)coordinateSequence4.getCoordinate(j))) continue;
            CoordinateSequence coordinateSequence5 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence5);
            Coordinate coordinate2 = coordinateSequence5.getCoordinate(i);
            CoordinateSequence coordinateSequence6 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence6);
            if (coordinate2.compareTo(coordinateSequence6.getCoordinate(j)) > 0) {
                CoordinateSequence coordinateSequence7 = this.getCoordinateSequence();
                Intrinsics.checkNotNull((Object)coordinateSequence7);
                CoordinateSequence copy = coordinateSequence7.copy();
                CoordinateSequences.reverse(copy);
                this.setCoordinateSequence(copy);
            }
            return;
        }
    }

    @Override
    protected boolean isEquivalentClass(@NotNull Geometry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof LineString;
    }

    @Override
    public int compareToSameClass(@Nullable Object o) {
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString line = (LineString)o;
        int i = 0;
        int j = 0;
        while (true) {
            CoordinateSequence coordinateSequence = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence);
            if (i >= coordinateSequence.size()) break;
            CoordinateSequence coordinateSequence2 = line.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            if (j >= coordinateSequence2.size()) break;
            CoordinateSequence coordinateSequence3 = this.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence3);
            Coordinate coordinate = coordinateSequence3.getCoordinate(i);
            CoordinateSequence coordinateSequence4 = line.getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence4);
            int comparison = coordinate.compareTo(coordinateSequence4.getCoordinate(j));
            if (comparison != 0) {
                return comparison;
            }
            ++i;
            ++j;
        }
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        if (i < coordinateSequence.size()) {
            return 1;
        }
        CoordinateSequence coordinateSequence5 = line.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence5);
        return j < coordinateSequence5.size() ? -1 : 0;
    }

    @Override
    public int compareToSameClass(@Nullable Object o, @NotNull CoordinateSequenceComparator comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString line = (LineString)o;
        return comp.compare(this.getCoordinateSequence(), line.getCoordinateSequence());
    }

    @Override
    protected int getTypeCode() {
        return 2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/geom/LineString$Companion;", "", "<init>", "()V", "serialVersionUID", "", "MINIMUM_VALID_SIZE", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

