/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 [2\u00020\u00012\u00020\u0002:\u0001[B)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB#\b\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\t\u0010\u000fB3\b\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\t\u0010\u0010J\u0006\u0010.\u001a\u00020\u000eJ\u000e\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u000eJ\b\u0010>\u001a\u00020\u0001H\u0002J\b\u0010?\u001a\u00020@H\u0014J\u001a\u0010A\u001a\u00020)2\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u000206H\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020HH\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020IH\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020LH\u0017J\b\u0010M\u001a\u00020\u0000H\u0014J\b\u0010N\u001a\u00020\u0001H\u0016J\b\u0010O\u001a\u00020EH\u0016J\u0012\u0010P\u001a\u00020\u000e2\b\u0010Q\u001a\u0004\u0018\u00010LH\u0014J\u001a\u0010P\u001a\u00020\u000e2\b\u0010Q\u001a\u0004\u0018\u00010L2\u0006\u0010R\u001a\u00020SH\u0016J\u0018\u0010V\u001a\u00020\u00042\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020)H\u0002J\u0018\u0010O\u001a\u00020E2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020)H\u0002J\b\u0010Y\u001a\u00020\u0000H\u0016J\b\u0010Z\u001a\u00020\u0000H\u0014R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010*R\u0014\u0010+\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010*R\u0013\u0010,\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0012R\u0016\u00101\u001a\u0004\u0018\u0001028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00108R\u0016\u0010;\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010T\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010#\u00a8\u0006\\"}, d2={"Lorg/locationtech/jts/geom/Polygon;", "Lorg/locationtech/jts/geom/Geometry;", "Lorg/locationtech/jts/geom/Polygonal;", "shell", "Lorg/locationtech/jts/geom/LinearRing;", "holes", "", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/LinearRing;[Lorg/locationtech/jts/geom/LinearRing;Lorg/locationtech/jts/geom/GeometryFactory;)V", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "SRID", "", "(Lorg/locationtech/jts/geom/LinearRing;Lorg/locationtech/jts/geom/PrecisionModel;I)V", "(Lorg/locationtech/jts/geom/LinearRing;[Lorg/locationtech/jts/geom/LinearRing;Lorg/locationtech/jts/geom/PrecisionModel;I)V", "getShell", "()Lorg/locationtech/jts/geom/LinearRing;", "setShell", "(Lorg/locationtech/jts/geom/LinearRing;)V", "getHoles", "()[Lorg/locationtech/jts/geom/LinearRing;", "setHoles", "([Lorg/locationtech/jts/geom/LinearRing;)V", "[Lorg/locationtech/jts/geom/LinearRing;", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "numPoints", "getNumPoints", "()I", "dimension", "getDimension", "boundaryDimension", "getBoundaryDimension", "isEmpty", "", "()Z", "isRectangle", "exteriorRing", "getExteriorRing", "getNumInteriorRing", "getInteriorRingN", "n", "geometryType", "", "getGeometryType", "()Ljava/lang/String;", "area", "", "getArea", "()D", "length", "getLength", "boundary", "getBoundary", "()Lorg/locationtech/jts/geom/Geometry;", "getBoundaryFn", "computeEnvelopeInternal", "Lorg/locationtech/jts/geom/Envelope;", "equalsExact", "other", "tolerance", "apply", "", "filter", "Lorg/locationtech/jts/geom/CoordinateFilter;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "Lorg/locationtech/jts/geom/GeometryFilter;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "clone", "", "copyInternal", "convexHull", "normalize", "compareToSameClass", "o", "comp", "Lorg/locationtech/jts/geom/CoordinateSequenceComparator;", "typeCode", "getTypeCode", "normalized", "ring", "clockwise", "reverse", "reverseInternal", "Companion", "kts-core"})
public class Polygon
extends Geometry
implements Polygonal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private LinearRing shell;
    @NotNull
    private LinearRing[] holes;
    private static final long serialVersionUID = -3494792200821764533L;

    public Polygon(@Nullable LinearRing shell, @Nullable LinearRing[] holes, @NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(factory);
        LinearRing shell2 = shell;
        LinearRing[] holes2 = holes;
        if (shell2 == null) {
            shell2 = GeometryFactory.createLinearRing$default(factory, null, 1, null);
        }
        if (holes2 == null) {
            holes2 = new LinearRing[]{};
        }
        if (shell2.isEmpty()) {
            if (Geometry.hasNonEmptyElements(holes2)) {
                throw new IllegalArgumentException("shell is empty but holes are not");
            }
        }
        this.shell = shell2;
        this.holes = holes2;
    }

    @Nullable
    protected final LinearRing getShell() {
        return this.shell;
    }

    protected final void setShell(@Nullable LinearRing linearRing) {
        this.shell = linearRing;
    }

    @NotNull
    protected final LinearRing[] getHoles() {
        return this.holes;
    }

    protected final void setHoles(@NotNull LinearRing[] linearRingArray) {
        Intrinsics.checkNotNullParameter((Object)linearRingArray, (String)"<set-?>");
        this.holes = linearRingArray;
    }

    @Deprecated(message="Use GeometryFactory instead")
    public Polygon(@Nullable LinearRing shell, @NotNull PrecisionModel precisionModel, int SRID) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        this(shell, new LinearRing[0], new GeometryFactory(precisionModel, SRID));
    }

    @Deprecated(message="Use GeometryFactory instead")
    public Polygon(@Nullable LinearRing shell, @Nullable LinearRing[] holes, @NotNull PrecisionModel precisionModel, int SRID) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        this(shell, holes, new GeometryFactory(precisionModel, SRID));
    }

    @Override
    @NotNull
    public Coordinate getCoordinate() {
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate coordinate = linearRing.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        return coordinate;
    }

    @Override
    @NotNull
    public Coordinate[] getCoordinates() {
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Object[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        for (Coordinate coordinates[++k] : linearRing.getCoordinates()) {
        }
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            for (Object coordinates[++k] : this.holes[i].getCoordinates()) {
            }
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])coordinates);
    }

    @Override
    public int getNumPoints() {
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        int numPoints = linearRing.getNumPoints();
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            numPoints += this.holes[i].getNumPoints();
        }
        return numPoints;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        return linearRing.isEmpty();
    }

    @Override
    public boolean isRectangle() {
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        if (this.shell == null) {
            return false;
        }
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        if (linearRing.getNumPoints() != 5) {
            return false;
        }
        LinearRing linearRing2 = this.shell;
        Intrinsics.checkNotNull((Object)linearRing2);
        CoordinateSequence coordinateSequence = linearRing2.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        CoordinateSequence seq = coordinateSequence;
        Envelope env = this.getEnvelopeInternal();
        for (int i = 0; i < 5; ++i) {
            double x = seq.getX(i);
            if (!(x == env.getMinX()) && !(x == env.getMaxX())) {
                return false;
            }
            double y = seq.getY(i);
            if (y == env.getMinY() || y == env.getMaxY()) continue;
            return false;
        }
        double prevX = seq.getX(0);
        double prevY = seq.getY(0);
        for (int i = 1; i < 5; ++i) {
            boolean yChanged;
            double x = seq.getX(i);
            double y = seq.getY(i);
            boolean xChanged = !(x == prevX);
            boolean bl = yChanged = !(y == prevY);
            if (xChanged == yChanged) {
                return false;
            }
            prevX = x;
            prevY = y;
        }
        return true;
    }

    @Nullable
    public final LinearRing getExteriorRing() {
        return this.shell;
    }

    public final int getNumInteriorRing() {
        return this.holes.length;
    }

    @NotNull
    public final LinearRing getInteriorRingN(int n) {
        return this.holes[n];
    }

    @Override
    @Nullable
    public String getGeometryType() {
        return "Polygon";
    }

    @Override
    public double getArea() {
        double area = 0.0;
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        CoordinateSequence coordinateSequence = linearRing.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        area += Area.ofRing(coordinateSequence);
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            CoordinateSequence coordinateSequence2 = this.holes[i].getCoordinateSequence();
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            area -= Area.ofRing(coordinateSequence2);
        }
        return area;
    }

    @Override
    public double getLength() {
        double len = 0.0;
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        len += linearRing.getLength();
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            len += this.holes[i].getLength();
        }
        return len;
    }

    @Override
    @Nullable
    public Geometry getBoundary() {
        return this.getBoundaryFn();
    }

    private final Geometry getBoundaryFn() {
        Geometry geometry;
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString();
        }
        Object[] rings = new LinearRing[this.holes.length + 1];
        rings[0] = this.shell;
        for (Object rings[i + 1] : this.holes) {
        }
        if (rings.length <= 1) {
            GeometryFactory geometryFactory = this.getFactory();
            Object object = rings[0];
            Intrinsics.checkNotNull((Object)object);
            geometry = geometryFactory.createLinearRing(((LineString)object).getCoordinateSequence());
        } else {
            geometry = this.getFactory().createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])rings));
        }
        return geometry;
    }

    @Override
    @NotNull
    protected Envelope computeEnvelopeInternal() {
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        return linearRing.getEnvelopeInternal();
    }

    @Override
    public boolean equalsExact(@Nullable Geometry other, double tolerance) {
        Geometry geometry = other;
        Intrinsics.checkNotNull((Object)geometry);
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        Polygon otherPolygon = (Polygon)other;
        Geometry thisShell = this.shell;
        Geometry otherPolygonShell = otherPolygon.shell;
        Geometry geometry2 = thisShell;
        Intrinsics.checkNotNull((Object)geometry2);
        if (!geometry2.equalsExact(otherPolygonShell, tolerance)) {
            return false;
        }
        if (this.holes.length != otherPolygon.holes.length) {
            return false;
        }
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            LinearRing linearRing = this.holes[i];
            Intrinsics.checkNotNull((Object)linearRing, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            if (((Geometry)linearRing).equalsExact(otherPolygon.holes[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(@NotNull CoordinateFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        linearRing.apply(filter);
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            this.holes[i].apply(filter);
        }
    }

    @Override
    public void apply(@NotNull CoordinateSequenceFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        linearRing.apply(filter);
        if (!filter.isDone()) {
            int n = this.holes.length;
            for (int i = 0; i < n; ++i) {
                this.holes[i].apply(filter);
                if (filter.isDone()) break;
            }
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(@NotNull GeometryFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        filter.filter(this);
    }

    @Override
    public void apply(@NotNull GeometryComponentFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        filter.filter(this);
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        linearRing.apply(filter);
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            this.holes[i].apply(filter);
        }
    }

    @Override
    @Deprecated(message="")
    @NotNull
    public Object clone() {
        return this.copy();
    }

    @Override
    @NotNull
    protected Polygon copyInternal() {
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        Geometry geometry = linearRing.copy();
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
        LinearRing shellCopy = (LinearRing)geometry;
        Object[] holeCopies = new LinearRing[this.holes.length];
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.holes[i].copy(), (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
        }
        return new Polygon(shellCopy, (LinearRing[])ArraysKt.requireNoNulls((Object[])holeCopies), this.getFactory());
    }

    @Override
    @NotNull
    public Geometry convexHull() {
        LinearRing linearRing = this.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        Geometry geometry = linearRing.convexHull();
        Intrinsics.checkNotNull((Object)geometry);
        return geometry;
    }

    @Override
    public void normalize() {
        LinearRing linearRing = this.shell;
        Intrinsics.checkNotNull((Object)linearRing);
        this.shell = this.normalized(linearRing, true);
        int n = this.holes.length;
        for (int i = 0; i < n; ++i) {
            this.holes[i] = this.normalized(this.holes[i], false);
        }
        ArraysKt.sort((Object[])this.holes);
    }

    @Override
    protected int compareToSameClass(@Nullable Object o) {
        int i;
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell;
        LinearRing otherShell = poly.shell;
        LinearRing linearRing = thisShell;
        Intrinsics.checkNotNull((Object)linearRing);
        int shellComp = linearRing.compareToSameClass(otherShell);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = ((Polygon)o).getNumInteriorRing();
        for (i = 0; i < nHole1 && i < nHole2; ++i) {
            int holeComp = this.getInteriorRingN(i).compareToSameClass(poly.getInteriorRingN(i));
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < nHole1) {
            return 1;
        }
        return i < nHole2 ? -1 : 0;
    }

    @Override
    public int compareToSameClass(@Nullable Object o, @NotNull CoordinateSequenceComparator comp) {
        int i;
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell;
        LinearRing otherShell = poly.shell;
        LinearRing linearRing = thisShell;
        Intrinsics.checkNotNull((Object)linearRing);
        int shellComp = linearRing.compareToSameClass(otherShell, comp);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = poly.getNumInteriorRing();
        for (i = 0; i < nHole1 && i < nHole2; ++i) {
            int holeComp = this.getInteriorRingN(i).compareToSameClass(poly.getInteriorRingN(i), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < nHole1) {
            return 1;
        }
        return i < nHole2 ? -1 : 0;
    }

    @Override
    protected int getTypeCode() {
        return 5;
    }

    private final LinearRing normalized(LinearRing ring, boolean clockwise) {
        Geometry geometry = ring.copy();
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
        LinearRing res = (LinearRing)geometry;
        this.normalize(res, clockwise);
        return res;
    }

    private final void normalize(LinearRing ring, boolean clockwise) {
        if (ring.isEmpty()) {
            return;
        }
        CoordinateSequence coordinateSequence = ring.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        CoordinateSequence seq = coordinateSequence;
        int minCoordinateIndex = CoordinateSequences.minCoordinateIndex(seq, 0, seq.size() - 2);
        CoordinateSequences.scroll(seq, minCoordinateIndex, true);
        if (Orientation.isCCW(seq) == clockwise) {
            CoordinateSequences.reverse(seq);
        }
    }

    @Override
    @NotNull
    public Polygon reverse() {
        Geometry geometry = super.reverse();
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        return (Polygon)geometry;
    }

    @Override
    @NotNull
    protected Polygon reverseInternal() {
        Object[] holes = new LinearRing[this.getNumInteriorRing()];
        int n = holes.length;
        for (int i = 0; i < n; ++i) {
            holes[i] = this.getInteriorRingN(i).reverse();
        }
        GeometryFactory geometryFactory = this.getFactory();
        LinearRing linearRing = this.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        return geometryFactory.createPolygon(linearRing.reverse(), (LinearRing[])ArraysKt.requireNoNulls((Object[])holes));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/geom/Polygon$Companion;", "", "<init>", "()V", "serialVersionUID", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

