/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.NoninvertibleTransformationException;
import org.locationtech.jts.legacy.Cloneable;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 X2\u00020\u00012\u00020\u0002:\u0001XB\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007B9\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u0003\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0011BE\b\u0016\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0003\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u0000J6\u0010\u001b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J&\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tJ&\u0010*\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tJ\u0016\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\tJ\u0016\u0010-\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tJ\u001e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ&\u0010-\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\tJ\u0016\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ\u0016\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tJ&\u0010:\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tJ\u0016\u0010:\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\tJ\u0016\u0010;\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tJ\u001e\u0010;\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ&\u0010;\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ\u0016\u0010<\u001a\u00020\u00002\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\tJ\u0016\u0010=\u001a\u00020\u00002\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ\u0016\u0010>\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ\u000e\u0010?\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u0016\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\u0013J\u000e\u0010A\u001a\u00020D2\u0006\u0010E\u001a\u00020DJ\u0018\u0010A\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020JJ\u001a\u0010K\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020JH\u0016J\u0014\u0010Q\u001a\u00020M2\b\u0010R\u001a\u0004\u0018\u00010SH\u0096\u0082\u0004J\n\u0010T\u001a\u00020JH\u0096\u0080\u0004J\n\u0010U\u001a\u00020VH\u0096\u0080\u0004J\b\u0010W\u001a\u00020SH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010L\u001a\u00020M8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010NR\u0014\u0010O\u001a\u00020M8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010NR\u0011\u0010P\u001a\u00020M8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010N\u00a8\u0006Y"}, d2={"Lorg/locationtech/jts/geom/util/AffineTransformation;", "Lorg/locationtech/jts/legacy/Cloneable;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "<init>", "()V", "matrix", "", "([D)V", "m00", "", "m01", "m02", "m10", "m11", "m12", "(DDDDDD)V", "trans", "(Lorg/locationtech/jts/geom/util/AffineTransformation;)V", "src0", "Lorg/locationtech/jts/geom/Coordinate;", "src1", "src2", "dest0", "dest1", "dest2", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "setToIdentity", "setTransformation", "matrixEntries", "getMatrixEntries", "()[D", "determinant", "getDeterminant", "()D", "inverse", "getInverse", "()Lorg/locationtech/jts/geom/util/AffineTransformation;", "setToReflectionBasic", "x0", "y0", "x1", "y1", "setToReflection", "x", "y", "setToRotation", "theta", "sinTheta", "cosTheta", "setToScale", "xScale", "yScale", "setToShear", "xShear", "yShear", "setToTranslation", "dx", "dy", "reflect", "rotate", "scale", "shear", "translate", "compose", "composeBefore", "transform", "src", "dest", "Lorg/locationtech/jts/geom/Geometry;", "g", "", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "i", "", "filter", "isGeometryChanged", "", "()Z", "isDone", "isIdentity", "equals", "obj", "", "hashCode", "toString", "", "clone", "Companion", "kts-core"})
public final class AffineTransformation
implements Cloneable,
CoordinateSequenceFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;

    public AffineTransformation() {
        this.setToIdentity();
    }

    public AffineTransformation(@NotNull double[] matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        this.m00 = matrix[0];
        this.m01 = matrix[1];
        this.m02 = matrix[2];
        this.m10 = matrix[3];
        this.m11 = matrix[4];
        this.m12 = matrix[5];
    }

    public AffineTransformation(double m00, double m01, double m02, double m10, double m11, double m12) {
        this.setTransformation(m00, m01, m02, m10, m11, m12);
    }

    public AffineTransformation(@NotNull AffineTransformation trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        this.setTransformation(trans);
    }

    public AffineTransformation(@Nullable Coordinate src0, @Nullable Coordinate src1, @Nullable Coordinate src2, @Nullable Coordinate dest0, @Nullable Coordinate dest1, @Nullable Coordinate dest2) {
    }

    @NotNull
    public final AffineTransformation setToIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        return this;
    }

    @NotNull
    public final AffineTransformation setTransformation(double m00, double m01, double m02, double m10, double m11, double m12) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        return this;
    }

    @NotNull
    public final AffineTransformation setTransformation(@NotNull AffineTransformation trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        this.m00 = trans.m00;
        this.m01 = trans.m01;
        this.m02 = trans.m02;
        this.m10 = trans.m10;
        this.m11 = trans.m11;
        this.m12 = trans.m12;
        return this;
    }

    @NotNull
    public final double[] getMatrixEntries() {
        double[] dArray = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12};
        return dArray;
    }

    public final double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    @NotNull
    public final AffineTransformation getInverse() {
        double det = this.getDeterminant();
        if (det == 0.0) {
            throw new NoninvertibleTransformationException("Transformation is non-invertible");
        }
        double im00 = this.m11 / det;
        double im10 = -this.m10 / det;
        double im01 = -this.m01 / det;
        double im11 = this.m00 / det;
        double im02 = (this.m01 * this.m12 - this.m02 * this.m11) / det;
        double im12 = (-this.m00 * this.m12 + this.m10 * this.m02) / det;
        return new AffineTransformation(im00, im01, im02, im10, im11, im12);
    }

    @NotNull
    public final AffineTransformation setToReflectionBasic(double x0, double y0, double x1, double y1) {
        double c2s2;
        if (x0 == x1 && y0 == y1) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d = Math.INSTANCE.sqrt(dx * dx + dy * dy);
        double sin = dy / d;
        double cos = dx / d;
        double cs2 = (double)2 * sin * cos;
        this.m00 = c2s2 = cos * cos - sin * sin;
        this.m01 = cs2;
        this.m02 = 0.0;
        this.m10 = cs2;
        this.m11 = -c2s2;
        this.m12 = 0.0;
        return this;
    }

    @NotNull
    public final AffineTransformation setToReflection(double x0, double y0, double x1, double y1) {
        if (x0 == x1 && y0 == y1) {
            throw new IllegalArgumentException("Reflection line points must be distinct");
        }
        this.setToTranslation(-x0, -y0);
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d = Math.INSTANCE.sqrt(dx * dx + dy * dy);
        double sin = dy / d;
        double cos = dx / d;
        this.rotate(-sin, cos);
        this.scale(1.0, -1.0);
        this.rotate(sin, cos);
        this.translate(x0, y0);
        return this;
    }

    @NotNull
    public final AffineTransformation setToReflection(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            throw new IllegalArgumentException("Reflection vector must be non-zero");
        }
        if (x == y) {
            this.m00 = 0.0;
            this.m01 = 1.0;
            this.m02 = 0.0;
            this.m10 = 1.0;
            this.m11 = 0.0;
            this.m12 = 0.0;
            return this;
        }
        double d = Math.INSTANCE.sqrt(x * x + y * y);
        double sin = y / d;
        double cos = x / d;
        this.rotate(-sin, cos);
        this.scale(1.0, -1.0);
        this.rotate(sin, cos);
        return this;
    }

    @NotNull
    public final AffineTransformation setToRotation(double theta) {
        this.setToRotation(Math.INSTANCE.sin(theta), Math.INSTANCE.cos(theta));
        return this;
    }

    @NotNull
    public final AffineTransformation setToRotation(double sinTheta, double cosTheta) {
        this.m00 = cosTheta;
        this.m01 = -sinTheta;
        this.m02 = 0.0;
        this.m10 = sinTheta;
        this.m11 = cosTheta;
        this.m12 = 0.0;
        return this;
    }

    @NotNull
    public final AffineTransformation setToRotation(double theta, double x, double y) {
        this.setToRotation(Math.INSTANCE.sin(theta), Math.INSTANCE.cos(theta), x, y);
        return this;
    }

    @NotNull
    public final AffineTransformation setToRotation(double sinTheta, double cosTheta, double x, double y) {
        this.m00 = cosTheta;
        this.m01 = -sinTheta;
        this.m02 = x - x * cosTheta + y * sinTheta;
        this.m10 = sinTheta;
        this.m11 = cosTheta;
        this.m12 = y - x * sinTheta - y * cosTheta;
        return this;
    }

    @NotNull
    public final AffineTransformation setToScale(double xScale, double yScale) {
        this.m00 = xScale;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = yScale;
        this.m12 = 0.0;
        return this;
    }

    @NotNull
    public final AffineTransformation setToShear(double xShear, double yShear) {
        this.m00 = 1.0;
        this.m01 = xShear;
        this.m02 = 0.0;
        this.m10 = yShear;
        this.m11 = 1.0;
        this.m12 = 0.0;
        return this;
    }

    @NotNull
    public final AffineTransformation setToTranslation(double dx, double dy) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = dx;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = dy;
        return this;
    }

    @NotNull
    public final AffineTransformation reflect(double x0, double y0, double x1, double y1) {
        this.compose(Companion.reflectionInstance(x0, y0, x1, y1));
        return this;
    }

    @NotNull
    public final AffineTransformation reflect(double x, double y) {
        this.compose(Companion.reflectionInstance(x, y));
        return this;
    }

    @NotNull
    public final AffineTransformation rotate(double theta) {
        this.compose(Companion.rotationInstance(theta));
        return this;
    }

    @NotNull
    public final AffineTransformation rotate(double sinTheta, double cosTheta) {
        this.compose(Companion.rotationInstance(sinTheta, cosTheta));
        return this;
    }

    @NotNull
    public final AffineTransformation rotate(double theta, double x, double y) {
        this.compose(Companion.rotationInstance(theta, x, y));
        return this;
    }

    @NotNull
    public final AffineTransformation rotate(double sinTheta, double cosTheta, double x, double y) {
        this.compose(Companion.rotationInstance(sinTheta, cosTheta, x, y));
        return this;
    }

    @NotNull
    public final AffineTransformation scale(double xScale, double yScale) {
        this.compose(Companion.scaleInstance(xScale, yScale));
        return this;
    }

    @NotNull
    public final AffineTransformation shear(double xShear, double yShear) {
        this.compose(Companion.shearInstance(xShear, yShear));
        return this;
    }

    @NotNull
    public final AffineTransformation translate(double x, double y) {
        this.compose(Companion.translationInstance(x, y));
        return this;
    }

    @NotNull
    public final AffineTransformation compose(@NotNull AffineTransformation trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        double mp00 = trans.m00 * this.m00 + trans.m01 * this.m10;
        double mp01 = trans.m00 * this.m01 + trans.m01 * this.m11;
        double mp02 = trans.m00 * this.m02 + trans.m01 * this.m12 + trans.m02;
        double mp10 = trans.m10 * this.m00 + trans.m11 * this.m10;
        double mp11 = trans.m10 * this.m01 + trans.m11 * this.m11;
        double mp12 = trans.m10 * this.m02 + trans.m11 * this.m12 + trans.m12;
        this.m00 = mp00;
        this.m01 = mp01;
        this.m02 = mp02;
        this.m10 = mp10;
        this.m11 = mp11;
        this.m12 = mp12;
        return this;
    }

    @NotNull
    public final AffineTransformation composeBefore(@NotNull AffineTransformation trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        double mp00 = this.m00 * trans.m00 + this.m01 * trans.m10;
        double mp01 = this.m00 * trans.m01 + this.m01 * trans.m11;
        double mp02 = this.m00 * trans.m02 + this.m01 * trans.m12 + this.m02;
        double mp10 = this.m10 * trans.m00 + this.m11 * trans.m10;
        double mp11 = this.m10 * trans.m01 + this.m11 * trans.m11;
        double mp12 = this.m10 * trans.m02 + this.m11 * trans.m12 + this.m12;
        this.m00 = mp00;
        this.m01 = mp01;
        this.m02 = mp02;
        this.m10 = mp10;
        this.m11 = mp11;
        this.m12 = mp12;
        return this;
    }

    @NotNull
    public final Coordinate transform(@NotNull Coordinate src, @NotNull Coordinate dest) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        double xp = this.m00 * src.x + this.m01 * src.y + this.m02;
        double yp = this.m10 * src.x + this.m11 * src.y + this.m12;
        dest.x = xp;
        dest.y = yp;
        return dest;
    }

    @NotNull
    public final Geometry transform(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Geometry g2 = g.copy();
        g2.apply(this);
        return g2;
    }

    public final void transform(@Nullable CoordinateSequence seq, int i) {
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        double xp = this.m00 * coordinateSequence.getOrdinate(i, 0) + this.m01 * seq.getOrdinate(i, 1) + this.m02;
        double yp = this.m10 * seq.getOrdinate(i, 0) + this.m11 * seq.getOrdinate(i, 1) + this.m12;
        seq.setOrdinate(i, 0, xp);
        seq.setOrdinate(i, 1, yp);
    }

    @Override
    public void filter(@Nullable CoordinateSequence seq, int i) {
        this.transform(seq, i);
    }

    @Override
    public boolean isGeometryChanged() {
        return true;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    public final boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AffineTransformation)) {
            return false;
        }
        Object trans = obj;
        return this.m00 == ((AffineTransformation)trans).m00 && this.m01 == ((AffineTransformation)trans).m01 && this.m02 == ((AffineTransformation)trans).m02 && this.m10 == ((AffineTransformation)trans).m10 && this.m11 == ((AffineTransformation)trans).m11 && this.m12 == ((AffineTransformation)trans).m12;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Math.INSTANCE.doubleToLongBits(this.m00);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        temp = Math.INSTANCE.doubleToLongBits(this.m01);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        temp = Math.INSTANCE.doubleToLongBits(this.m02);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        temp = Math.INSTANCE.doubleToLongBits(this.m10);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        temp = Math.INSTANCE.doubleToLongBits(this.m11);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        temp = Math.INSTANCE.doubleToLongBits(this.m12);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    @NotNull
    public String toString() {
        return "AffineTransformation[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + "], [" + this.m10 + ", " + this.m11 + ", " + this.m12 + "]]";
    }

    @Override
    @NotNull
    public Object clone() {
        return new AffineTransformation(this);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation reflectionInstance(double x0, double y0, double x1, double y1) {
        return Companion.reflectionInstance(x0, y0, x1, y1);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation reflectionInstance(double x, double y) {
        return Companion.reflectionInstance(x, y);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation rotationInstance(double theta) {
        return Companion.rotationInstance(theta);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation rotationInstance(double sinTheta, double cosTheta) {
        return Companion.rotationInstance(sinTheta, cosTheta);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation rotationInstance(double theta, double x, double y) {
        return Companion.rotationInstance(theta, x, y);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation rotationInstance(double sinTheta, double cosTheta, double x, double y) {
        return Companion.rotationInstance(sinTheta, cosTheta, x, y);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation scaleInstance(double xScale, double yScale) {
        return Companion.scaleInstance(xScale, yScale);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation scaleInstance(double xScale, double yScale, double x, double y) {
        return Companion.scaleInstance(xScale, yScale, x, y);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation shearInstance(double xShear, double yShear) {
        return Companion.shearInstance(xShear, yShear);
    }

    @JvmStatic
    @NotNull
    public static final AffineTransformation translationInstance(double x, double y) {
        return Companion.translationInstance(x, y);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007J(\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J(\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/geom/util/AffineTransformation$Companion;", "", "<init>", "()V", "reflectionInstance", "Lorg/locationtech/jts/geom/util/AffineTransformation;", "x0", "", "y0", "x1", "y1", "x", "y", "rotationInstance", "theta", "sinTheta", "cosTheta", "scaleInstance", "xScale", "yScale", "shearInstance", "xShear", "yShear", "translationInstance", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation reflectionInstance(double x0, double y0, double x1, double y1) {
            AffineTransformation trans = new AffineTransformation();
            trans.setToReflection(x0, y0, x1, y1);
            return trans;
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation reflectionInstance(double x, double y) {
            AffineTransformation trans = new AffineTransformation();
            trans.setToReflection(x, y);
            return trans;
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation rotationInstance(double theta) {
            return this.rotationInstance(Math.INSTANCE.sin(theta), Math.INSTANCE.cos(theta));
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation rotationInstance(double sinTheta, double cosTheta) {
            AffineTransformation trans = new AffineTransformation();
            trans.setToRotation(sinTheta, cosTheta);
            return trans;
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation rotationInstance(double theta, double x, double y) {
            return this.rotationInstance(Math.INSTANCE.sin(theta), Math.INSTANCE.cos(theta), x, y);
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation rotationInstance(double sinTheta, double cosTheta, double x, double y) {
            AffineTransformation trans = new AffineTransformation();
            trans.setToRotation(sinTheta, cosTheta, x, y);
            return trans;
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation scaleInstance(double xScale, double yScale) {
            AffineTransformation trans = new AffineTransformation();
            trans.setToScale(xScale, yScale);
            return trans;
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation scaleInstance(double xScale, double yScale, double x, double y) {
            AffineTransformation trans = new AffineTransformation();
            trans.translate(-x, -y);
            trans.scale(xScale, yScale);
            trans.translate(x, y);
            return trans;
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation shearInstance(double xShear, double yShear) {
            AffineTransformation trans = new AffineTransformation();
            trans.setToShear(xShear, yShear);
            return trans;
        }

        @JvmStatic
        @NotNull
        public final AffineTransformation translationInstance(double x, double y) {
            AffineTransformation trans = new AffineTransformation();
            trans.setToTranslation(x, y);
            return trans;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

