/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0007\u001a\u00020\bJ \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0007J&\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/geom/util/GeometryMapper;", "", "<init>", "()V", "map", "Lorg/locationtech/jts/geom/Geometry;", "geom", "op", "Lorg/locationtech/jts/geom/util/GeometryMapper$MapOp;", "", "geoms", "flatMap", "emptyDim", "", "", "mapped", "", "addFlat", "geomList", "MapOp", "kts-core"})
public final class GeometryMapper {
    @NotNull
    public static final GeometryMapper INSTANCE = new GeometryMapper();

    private GeometryMapper() {
    }

    @NotNull
    public final Geometry map(@NotNull Geometry geom, @NotNull MapOp op) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        List mapped = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = op.map(geom.getGeometryN(i));
            if (g == null) continue;
            mapped.add(g);
        }
        return geom.getFactory().buildGeometry(mapped);
    }

    @NotNull
    public final Collection<?> map(@NotNull Collection<?> geoms, @NotNull MapOp op) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        List mapped = new ArrayList();
        for (Object obj : geoms) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry g = (Geometry)obj;
            Geometry gr = op.map(g);
            if (gr == null) continue;
            mapped.add(gr);
        }
        return mapped;
    }

    @JvmStatic
    @NotNull
    public static final Geometry flatMap(@NotNull Geometry geom, int emptyDim, @NotNull MapOp op) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        List mapped = new ArrayList();
        INSTANCE.flatMap(geom, op, mapped);
        if (mapped.size() == 0) {
            return geom.getFactory().createEmpty(emptyDim);
        }
        return mapped.size() == 1 ? (Geometry)mapped.get(0) : geom.getFactory().buildGeometry(mapped);
    }

    private final void flatMap(Geometry geom, MapOp op, List<Geometry> mapped) {
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = geom.getGeometryN(i);
            if (g instanceof GeometryCollection) {
                this.flatMap(g, op, mapped);
                continue;
            }
            Geometry res = op.map(g);
            if (res == null || res.isEmpty()) continue;
            this.addFlat(res, mapped);
        }
    }

    private final void addFlat(Geometry geom, List<Geometry> geomList) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof GeometryCollection) {
            int n = ((GeometryCollection)geom).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.addFlat(((GeometryCollection)geom).getGeometryN(i), geomList);
            }
        } else {
            geomList.add(geom);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lorg/locationtech/jts/geom/util/GeometryMapper$MapOp;", "", "map", "Lorg/locationtech/jts/geom/Geometry;", "geom", "kts-core"})
    public static interface MapOp {
        @Nullable
        public Geometry map(@NotNull Geometry var1);
    }
}

