/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0014\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\u0000J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u0000J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0013\u0010\u0017\u001a\u00020\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u0000H\u0086\u0002J\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0011\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005H\u0086\u0002J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/index/bintree/Interval;", "", "<init>", "()V", "min", "", "max", "(DD)V", "interval", "(Lorg/locationtech/jts/index/bintree/Interval;)V", "getMin", "()D", "setMin", "(D)V", "getMax", "setMax", "init", "", "width", "getWidth", "expandToInclude", "overlaps", "", "contains", "p", "toString", "", "kts-core"})
public final class Interval {
    private double min;
    private double max;

    public final double getMin() {
        return this.min;
    }

    public final void setMin(double d) {
        this.min = d;
    }

    public final double getMax() {
        return this.max;
    }

    public final void setMax(double d) {
        this.max = d;
    }

    public Interval() {
        this.min = 0.0;
        this.max = 0.0;
    }

    public Interval(double min, double max) {
        this.init(min, max);
    }

    public Interval(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        this.init(interval.min, interval.max);
    }

    public final void init(double min, double max) {
        this.min = min;
        this.max = max;
        if (min > max) {
            this.min = max;
            this.max = min;
        }
    }

    public final double getWidth() {
        return this.max - this.min;
    }

    public final void expandToInclude(@Nullable Interval interval) {
        Interval interval2 = interval;
        Intrinsics.checkNotNull((Object)interval2);
        if (interval2.max > this.max) {
            this.max = interval.max;
        }
        if (interval.min < this.min) {
            this.min = interval.min;
        }
    }

    public final boolean overlaps(@Nullable Interval interval) {
        Interval interval2 = interval;
        Intrinsics.checkNotNull((Object)interval2);
        return this.overlaps(interval2.min, interval.max);
    }

    public final boolean overlaps(double min, double max) {
        return !(this.min > max) && !(this.max < min);
    }

    public final boolean contains(@Nullable Interval interval) {
        Interval interval2 = interval;
        Intrinsics.checkNotNull((Object)interval2);
        return this.contains(interval2.min, interval.max);
    }

    public final boolean contains(double min, double max) {
        return min >= this.min && max <= this.max;
    }

    public final boolean contains(double p) {
        double d = this.min;
        return p <= this.max ? d <= p : false;
    }

    @NotNull
    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }
}

