/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.chain;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.index.chain.MonotoneChain;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\fJ#\u0010\r\u001a\u00020\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/index/chain/MonotoneChainBuilder;", "", "<init>", "()V", "getChains", "", "Lorg/locationtech/jts/index/chain/MonotoneChain;", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Ljava/util/List;", "context", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/lang/Object;)Ljava/util/List;", "findChainEnd", "", "start", "([Lorg/locationtech/jts/geom/Coordinate;I)I", "kts-core"})
public final class MonotoneChainBuilder {
    @NotNull
    public static final MonotoneChainBuilder INSTANCE = new MonotoneChainBuilder();

    private MonotoneChainBuilder() {
    }

    @NotNull
    public final List<MonotoneChain> getChains(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        return MonotoneChainBuilder.getChains(pts, null);
    }

    @JvmStatic
    @NotNull
    public static final List<MonotoneChain> getChains(@NotNull Coordinate[] pts, @Nullable Object context) {
        int chainEnd;
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        List mcList = new ArrayList();
        int chainStart = 0;
        do {
            chainEnd = INSTANCE.findChainEnd(pts, chainStart);
            MonotoneChain mc = new MonotoneChain(pts, chainStart, chainEnd, context);
            mcList.add(mc);
        } while ((chainStart = chainEnd) < pts.length - 1);
        return mcList;
    }

    private final int findChainEnd(Coordinate[] pts, int start) {
        int quad;
        int last;
        int safeStart;
        for (safeStart = start; safeStart < pts.length - 1 && pts[safeStart].equals2D(pts[safeStart + 1]); ++safeStart) {
        }
        if (safeStart >= pts.length - 1) {
            return pts.length - 1;
        }
        int chainQuad = Quadrant.INSTANCE.quadrant(pts[safeStart], pts[safeStart + 1]);
        for (last = start + 1; last < pts.length && (pts[last - 1].equals2D(pts[last]) || (quad = Quadrant.INSTANCE.quadrant(pts[last - 1], pts[last])) == chainQuad); ++last) {
        }
        return last - 1;
    }
}

