/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.DoubleBits;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/index/quadtree/Key;", "", "itemEnv", "Lorg/locationtech/jts/geom/Envelope;", "<init>", "(Lorg/locationtech/jts/geom/Envelope;)V", "point", "Lorg/locationtech/jts/geom/Coordinate;", "getPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "value", "", "level", "getLevel", "()I", "envelope", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "centre", "getCentre", "computeKey", "", "Companion", "kts-core"})
public final class Key {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate point;
    private int level;
    @Nullable
    private Envelope envelope;

    public Key(@NotNull Envelope itemEnv) {
        Intrinsics.checkNotNullParameter((Object)itemEnv, (String)"itemEnv");
        this.point = new Coordinate();
        this.computeKey(itemEnv);
    }

    @NotNull
    public final Coordinate getPoint() {
        return this.point;
    }

    public final int getLevel() {
        return this.level;
    }

    @Nullable
    public final Envelope getEnvelope() {
        return this.envelope;
    }

    @NotNull
    public final Coordinate getCentre() {
        Envelope envelope = this.envelope;
        Intrinsics.checkNotNull((Object)envelope);
        double d = envelope.getMinX();
        Envelope envelope2 = this.envelope;
        Intrinsics.checkNotNull((Object)envelope2);
        double d2 = (d + envelope2.getMaxX()) / (double)2;
        Envelope envelope3 = this.envelope;
        Intrinsics.checkNotNull((Object)envelope3);
        double d3 = envelope3.getMinY();
        Envelope envelope4 = this.envelope;
        Intrinsics.checkNotNull((Object)envelope4);
        return new Coordinate(d2, (d3 + envelope4.getMaxY()) / (double)2);
    }

    public final void computeKey(@NotNull Envelope itemEnv) {
        Intrinsics.checkNotNullParameter((Object)itemEnv, (String)"itemEnv");
        this.level = Companion.computeQuadLevel(itemEnv);
        this.envelope = new Envelope();
        this.computeKey(this.level, itemEnv);
        while (true) {
            Envelope envelope = this.envelope;
            Intrinsics.checkNotNull((Object)envelope);
            if (envelope.contains(itemEnv)) break;
            ++this.level;
            this.computeKey(this.level, itemEnv);
        }
    }

    private final void computeKey(int level, Envelope itemEnv) {
        double quadSize = DoubleBits.Companion.powerOf2(level);
        this.point.x = Math.INSTANCE.floor(itemEnv.getMinX() / quadSize) * quadSize;
        this.point.y = Math.INSTANCE.floor(itemEnv.getMinY() / quadSize) * quadSize;
        Envelope envelope = this.envelope;
        Intrinsics.checkNotNull((Object)envelope);
        envelope.init(this.point.x, this.point.x + quadSize, this.point.y, this.point.y + quadSize);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/index/quadtree/Key$Companion;", "", "<init>", "()V", "computeQuadLevel", "", "env", "Lorg/locationtech/jts/geom/Envelope;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int computeQuadLevel(@NotNull Envelope env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            double dx = env.getWidth();
            double dy = env.getHeight();
            double dMax = dx > dy ? dx : dy;
            return DoubleBits.Companion.exponent(dMax) + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

