/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.EnvelopeDistance;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.legacy.queue.PriorityQueue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\u001c\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u000bJ6\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/locationtech/jts/index/strtree/BoundablePair;", "", "", "boundable1", "Lorg/locationtech/jts/index/strtree/Boundable;", "boundable2", "itemDistance", "Lorg/locationtech/jts/index/strtree/ItemDistance;", "<init>", "(Lorg/locationtech/jts/index/strtree/Boundable;Lorg/locationtech/jts/index/strtree/Boundable;Lorg/locationtech/jts/index/strtree/ItemDistance;)V", "distance", "", "getDistance", "()D", "getBoundable", "i", "", "maximumDistance", "compareTo", "o", "isLeaves", "", "()Z", "expandToQueue", "", "priQ", "Lorg/locationtech/jts/legacy/queue/PriorityQueue;", "minDistance", "expand", "bndComposite", "bndOther", "isFlipped", "Companion", "kts-core"})
public final class BoundablePair
implements Comparable<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Boundable boundable1;
    @NotNull
    private final Boundable boundable2;
    @NotNull
    private final ItemDistance itemDistance;
    private final double distance;

    public BoundablePair(@NotNull Boundable boundable1, @NotNull Boundable boundable2, @NotNull ItemDistance itemDistance) {
        Intrinsics.checkNotNullParameter((Object)boundable1, (String)"boundable1");
        Intrinsics.checkNotNullParameter((Object)boundable2, (String)"boundable2");
        Intrinsics.checkNotNullParameter((Object)itemDistance, (String)"itemDistance");
        this.boundable1 = boundable1;
        this.boundable2 = boundable2;
        this.itemDistance = itemDistance;
        this.distance = this.distance();
    }

    public final double getDistance() {
        return this.distance;
    }

    @NotNull
    public final Boundable getBoundable(int i) {
        return i == 0 ? this.boundable1 : this.boundable2;
    }

    public final double maximumDistance() {
        Envelope envelope = (Envelope)this.boundable1.getBounds();
        Intrinsics.checkNotNull((Object)envelope);
        Envelope envelope2 = (Envelope)this.boundable2.getBounds();
        Intrinsics.checkNotNull((Object)envelope2);
        return EnvelopeDistance.maximumDistance(envelope, envelope2);
    }

    private final double distance() {
        double d;
        if (this.isLeaves()) {
            Boundable boundable = this.boundable1;
            Intrinsics.checkNotNull((Object)boundable, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.ItemBoundable");
            ItemBoundable itemBoundable = (ItemBoundable)boundable;
            Boundable boundable2 = this.boundable2;
            Intrinsics.checkNotNull((Object)boundable2, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.ItemBoundable");
            d = this.itemDistance.distance(itemBoundable, (ItemBoundable)boundable2);
        } else {
            Envelope envelope = (Envelope)this.boundable1.getBounds();
            Intrinsics.checkNotNull((Object)envelope);
            Envelope envelope2 = (Envelope)this.boundable2.getBounds();
            Intrinsics.checkNotNull((Object)envelope2);
            d = envelope.distance(envelope2);
        }
        return d;
    }

    @Override
    public int compareTo(@Nullable Object o) {
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.BoundablePair");
        BoundablePair nd = (BoundablePair)o;
        if (this.distance < nd.distance) {
            return -1;
        }
        return this.distance > nd.distance ? 1 : 0;
    }

    public final boolean isLeaves() {
        return !Companion.isComposite(this.boundable1) && !Companion.isComposite(this.boundable2);
    }

    public final void expandToQueue(@NotNull PriorityQueue<BoundablePair> priQ, double minDistance) {
        Intrinsics.checkNotNullParameter(priQ, (String)"priQ");
        boolean isComp1 = Companion.isComposite(this.boundable1);
        boolean isComp2 = Companion.isComposite(this.boundable2);
        if (isComp1 && isComp2) {
            if (BoundablePair.Companion.area(this.boundable1) > BoundablePair.Companion.area(this.boundable2)) {
                this.expand(this.boundable1, this.boundable2, false, priQ, minDistance);
                return;
            }
            this.expand(this.boundable2, this.boundable1, true, priQ, minDistance);
            return;
        }
        if (isComp1) {
            this.expand(this.boundable1, this.boundable2, false, priQ, minDistance);
            return;
        }
        if (isComp2) {
            this.expand(this.boundable2, this.boundable1, true, priQ, minDistance);
            return;
        }
        throw new IllegalArgumentException("neither boundable is composite");
    }

    private final void expand(Boundable bndComposite, Boundable bndOther, boolean isFlipped, PriorityQueue<BoundablePair> priQ, double minDistance) {
        Intrinsics.checkNotNull((Object)bndComposite, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.AbstractNode");
        List<Boundable> children = ((AbstractNode)bndComposite).getChildBoundables();
        Iterator<Boundable> i = children.iterator();
        while (i.hasNext()) {
            Boundable child;
            BoundablePair bp;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            BoundablePair boundablePair = bp = isFlipped ? new BoundablePair(bndOther, child, this.itemDistance) : new BoundablePair(child, bndOther, this.itemDistance);
            if (!(bp.distance < minDistance)) continue;
            priQ.add(bp);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/index/strtree/BoundablePair$Companion;", "", "<init>", "()V", "isComposite", "", "item", "area", "", "b", "Lorg/locationtech/jts/index/strtree/Boundable;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isComposite(@Nullable Object item) {
            return item instanceof AbstractNode;
        }

        private final double area(Boundable b) {
            Envelope envelope = (Envelope)b.getBounds();
            Intrinsics.checkNotNull((Object)envelope);
            return envelope.getArea();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

