/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 82\u00020\u0001:\u00018B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00142\b\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000bH\u0002J\u0010\u00104\u001a\u0002022\u0006\u00103\u001a\u00020\u000bH\u0002J\u0010\u00105\u001a\u0002022\u0006\u00103\u001a\u00020\u000bH\u0002J\b\u00106\u001a\u000207H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/locationtech/jts/io/WKBReader;", "", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "csFactory", "Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "inputDimension", "", "isStrict", "", "dis", "Lorg/locationtech/jts/io/ByteOrderDataInStream;", "ordValues", "", "maxNumFieldValue", "read", "Lorg/locationtech/jts/geom/Geometry;", "bytes", "", "is", "Lorg/locationtech/jts/io/InStream;", "maxCoordNum", "readNumField", "fieldName", "", "readGeometry", "SRID", "setSRID", "g", "readPoint", "Lorg/locationtech/jts/geom/Point;", "readLineString", "Lorg/locationtech/jts/geom/LineString;", "readLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "readPolygon", "Lorg/locationtech/jts/geom/Polygon;", "readMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "readMultiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "readMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "readGeometryCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "readCoordinateSequence", "Lorg/locationtech/jts/geom/CoordinateSequence;", "size", "readCoordinateSequenceLineString", "readCoordinateSequenceRing", "readCoordinate", "", "Companion", "kts-core"})
public final class WKBReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory factory;
    @NotNull
    private final CoordinateSequenceFactory csFactory;
    @NotNull
    private final PrecisionModel precisionModel;
    private int inputDimension;
    private final boolean isStrict;
    @NotNull
    private final ByteOrderDataInStream dis;
    @Nullable
    private double[] ordValues;
    private int maxNumFieldValue;
    @NotNull
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    @NotNull
    private static final String FIELD_NUMCOORDS = "numCoords";
    @Nullable
    private static final Void FIELD_NUMRINGS;
    @Nullable
    private static final Void FIELD_NUMELEMS;

    @JvmOverloads
    public WKBReader(@NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
        this.precisionModel = this.factory.getPrecisionModel();
        this.inputDimension = 2;
        this.dis = new ByteOrderDataInStream();
        this.csFactory = this.factory.getCoordinateSequenceFactory();
    }

    public /* synthetic */ WKBReader(GeometryFactory geometryFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            geometryFactory = new GeometryFactory();
        }
        this(geometryFactory);
    }

    @Nullable
    public final Geometry read(@NotNull byte[] bytes) throws ParseException {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            geometry = this.read(new ByteArrayInStream(bytes), bytes.length / 16);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
        return geometry;
    }

    @NotNull
    public final Geometry read(@NotNull InStream is) throws IOException, ParseException {
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        return this.read(is, Integer.MAX_VALUE);
    }

    private final Geometry read(InStream is, int maxCoordNum) throws IOException, ParseException {
        this.maxNumFieldValue = maxCoordNum;
        this.dis.setInStream(is);
        return this.readGeometry(0);
    }

    private final int readNumField(String fieldName) throws IOException, ParseException {
        int num = this.dis.readInt();
        if (num < 0 || num > this.maxNumFieldValue) {
            throw new ParseException(fieldName + " value is too large");
        }
        return num;
    }

    private final Geometry readGeometry(int SRID) throws IOException, ParseException {
        int geometryType;
        int SRID2;
        block19: {
            block18: {
                boolean hasSRID;
                SRID2 = SRID;
                byte byteOrderWKB = this.dis.readByte();
                if (byteOrderWKB == 1) {
                    this.dis.setOrder(2);
                } else if (byteOrderWKB == 0) {
                    this.dis.setOrder(1);
                } else if (this.isStrict) {
                    throw new ParseException("Unknown geometry byte order (not NDR or XDR): " + byteOrderWKB);
                }
                int typeInt = this.dis.readInt();
                geometryType = (typeInt & 0xFFFF) % 1000;
                boolean hasZ = (typeInt & Integer.MIN_VALUE) != 0 || (typeInt & 0xFFFF) / 1000 == 1 || (typeInt & 0xFFFF) / 1000 == 3;
                boolean hasM = (typeInt & 0x40000000) != 0 || (typeInt & 0xFFFF) / 1000 == 2 || (typeInt & 0xFFFF) / 1000 == 3;
                this.inputDimension = 2 + (hasZ ? 1 : 0) + (hasM ? 1 : 0);
                boolean bl = hasSRID = (typeInt & 0x20000000) != 0;
                if (hasSRID) {
                    SRID2 = this.dis.readInt();
                }
                if (this.ordValues == null) break block18;
                Intrinsics.checkNotNull((Object)this.ordValues);
                if (this.ordValues.length >= this.inputDimension) break block19;
            }
            this.ordValues = new double[this.inputDimension];
        }
        Geometry geom = null;
        geom = switch (geometryType) {
            case 1 -> this.readPoint();
            case 2 -> this.readLineString();
            case 3 -> this.readPolygon();
            case 4 -> this.readMultiPoint(SRID2);
            case 5 -> this.readMultiLineString(SRID2);
            case 6 -> this.readMultiPolygon(SRID2);
            case 7 -> this.readGeometryCollection(SRID2);
            default -> throw new ParseException("Unknown WKB type " + geometryType);
        };
        this.setSRID(geom, SRID2);
        return geom;
    }

    private final Geometry setSRID(Geometry g, int SRID) {
        if (SRID != 0) {
            Geometry geometry = g;
            Intrinsics.checkNotNull((Object)geometry);
            geometry.setSRID(SRID);
        }
        return g;
    }

    private final Point readPoint() throws IOException, ParseException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        return Math.INSTANCE.isNaN(pts.getX(0)) || Math.INSTANCE.isNaN(pts.getY(0)) ? GeometryFactory.createPoint$default(this.factory, null, 1, null) : this.factory.createPoint(pts);
    }

    private final LineString readLineString() throws IOException, ParseException {
        int size = this.readNumField(FIELD_NUMCOORDS);
        CoordinateSequence pts = this.readCoordinateSequenceLineString(size);
        return this.factory.createLineString(pts);
    }

    private final LinearRing readLinearRing() throws IOException, ParseException {
        int size = this.readNumField(FIELD_NUMCOORDS);
        CoordinateSequence pts = this.readCoordinateSequenceRing(size);
        return this.factory.createLinearRing(pts);
    }

    private final Polygon readPolygon() throws IOException, ParseException {
        int numRings = this.readNumField((String)((Object)FIELD_NUMRINGS));
        Object[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        if (numRings <= 0) {
            return GeometryFactory.createPolygon$default(this.factory, null, null, 3, null);
        }
        LinearRing shell = this.readLinearRing();
        int n = numRings - 1;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)holes);
            holes[i] = this.readLinearRing();
        }
        return this.factory.createPolygon(shell, (LinearRing[])(holes != null ? (LinearRing[])ArraysKt.requireNoNulls((Object[])holes) : null));
    }

    private final MultiPoint readMultiPoint(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField((String)((Object)FIELD_NUMELEMS));
        Object[] geoms = new Point[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Point g;
            Geometry geometry = this.readGeometry(SRID);
            if ((geometry instanceof Point ? (Point)geometry : null) == null) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            g = g;
            geoms[i] = g;
        }
        return this.factory.createMultiPoint((Point[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final MultiLineString readMultiLineString(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField((String)((Object)FIELD_NUMELEMS));
        Object[] geoms = new LineString[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            LineString g;
            Geometry geometry = this.readGeometry(SRID);
            if ((geometry instanceof LineString ? (LineString)geometry : null) == null) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            g = g;
            geoms[i] = g;
        }
        return this.factory.createMultiLineString((LineString[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final MultiPolygon readMultiPolygon(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField((String)((Object)FIELD_NUMELEMS));
        Object[] geoms = new Polygon[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            Polygon g;
            Geometry geometry = this.readGeometry(SRID);
            if ((geometry instanceof Polygon ? (Polygon)geometry : null) == null) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            g = g;
            geoms[i] = g;
        }
        return this.factory.createMultiPolygon((Polygon[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final GeometryCollection readGeometryCollection(int SRID) throws IOException, ParseException {
        int numGeom = this.readNumField((String)((Object)FIELD_NUMELEMS));
        Object[] geoms = new Geometry[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            geoms[i] = this.readGeometry(SRID);
        }
        return this.factory.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])geoms));
    }

    private final CoordinateSequence readCoordinateSequence(int size) throws IOException, ParseException {
        CoordinateSequence seq = this.csFactory.create(size, this.inputDimension);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        for (int i = 0; i < size; ++i) {
            this.readCoordinate();
            int n = targetDim;
            for (int j = 0; j < n; ++j) {
                Intrinsics.checkNotNull((Object)this.ordValues);
                seq.setOrdinate(i, j, this.ordValues[j]);
            }
        }
        return seq;
    }

    private final CoordinateSequence readCoordinateSequenceLineString(int size) throws IOException, ParseException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        return seq.size() == 0 || seq.size() >= 2 ? seq : CoordinateSequences.INSTANCE.extend(this.csFactory, seq, 2);
    }

    private final CoordinateSequence readCoordinateSequenceRing(int size) throws IOException, ParseException {
        CoordinateSequence seq = this.readCoordinateSequence(size);
        if (this.isStrict) {
            return seq;
        }
        return CoordinateSequences.isRing(seq) ? seq : CoordinateSequences.ensureValidRing(this.csFactory, seq);
    }

    private final void readCoordinate() throws IOException, ParseException {
        int n = this.inputDimension;
        for (int i = 0; i < n; ++i) {
            if (i <= 1) {
                Intrinsics.checkNotNull((Object)this.ordValues);
                this.ordValues[i] = this.precisionModel.makePrecise(this.dis.readDouble());
                continue;
            }
            Intrinsics.checkNotNull((Object)this.ordValues);
            this.ordValues[i] = this.dis.readDouble();
        }
    }

    @JvmOverloads
    public WKBReader() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hexToBytes(@NotNull String hex) {
        return Companion.hexToBytes(hex);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\nH\u0002R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/io/WKBReader$Companion;", "", "<init>", "()V", "hexToBytes", "", "hex", "", "hexToInt", "", "", "INVALID_GEOM_TYPE_MSG", "FIELD_NUMCOORDS", "FIELD_NUMRINGS", "", "FIELD_NUMELEMS", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final byte[] hexToBytes(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            int byteLen = hex.length() / 2;
            byte[] bytes = new byte[byteLen];
            int n = hex.length() / 2;
            for (int i = 0; i < n; ++i) {
                byte b;
                int i2 = 2 * i;
                if (i2 + 1 > hex.length()) {
                    throw new IllegalArgumentException("Hex string has odd length");
                }
                int nib1 = this.hexToInt(hex.charAt(i2));
                int nib0 = this.hexToInt(hex.charAt(i2 + 1));
                bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
            }
            return bytes;
        }

        private final int hexToInt(char hex) {
            int nib;
            Integer n = CharsKt.digitToIntOrNull((char)hex, (int)16);
            int n2 = nib = n != null ? n : -1;
            if (nib < 0) {
                throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
            }
            return nib;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

