/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.StreamTokenizer;
import org.locationtech.jts.legacy.EnumSetKt;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 S2\u00020\u0001:\u0001SB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0017\u0010\u0013\u001a\u00020\u00142\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019\u00a2\u0006\u0002\u0010\u001aJ5\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"2\u0006\u0010#\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010$J%\u0010%\u001a\u00020\u001c2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010&J=\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010,J%\u0010-\u001a\u00020(2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010.J-\u0010/\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u00100J%\u00101\u001a\u00020*2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u0002042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u00105\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u00106\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J5\u00106\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00107\u001a\u00020\u00162\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u00108J \u00109\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00107\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\u0016H\u0002J-\u0010;\u001a\u00020<2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010=J-\u0010>\u001a\u00020?2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010@J-\u0010A\u001a\u00020B2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010CJ-\u0010D\u001a\u00020E2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010FJ-\u0010G\u001a\u00020H2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010IJ-\u0010J\u001a\u00020K2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010LJ-\u0010M\u001a\u00020N2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010OJ-\u0010P\u001a\u00020Q2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"H\u0002\u00a2\u0006\u0002\u0010RR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/locationtech/jts/io/WKTReader;", "", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "csFactory", "Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "isAllowOldJtsCoordinateSyntax", "", "isAllowOldJtsMultipointSyntax", "isFixStructure", "setIsOldJtsCoordinateSyntaxAllowed", "", "value", "setIsOldJtsMultiPointSyntaxAllowed", "setFixStructure", "read", "Lorg/locationtech/jts/geom/Geometry;", "wellKnownText", "", "reader", "Ljava/io/Reader;", "Lorg/locationtech/jts/io/Reader;", "(Ljava/io/Reader;)Lorg/locationtech/jts/geom/Geometry;", "getCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "tokenizer", "Lorg/locationtech/jts/io/StreamTokenizer;", "ordinateFlags", "Ljava/util/EnumSet;", "Lorg/locationtech/jts/io/Ordinate;", "Lorg/locationtech/jts/legacy/EnumSet;", "tryParen", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;Z)Lorg/locationtech/jts/geom/Coordinate;", "createCoordinate", "(Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/Coordinate;", "getCoordinateSequence", "Lorg/locationtech/jts/geom/CoordinateSequence;", "minSize", "", "isRing", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;IZ)Lorg/locationtech/jts/geom/CoordinateSequence;", "createCoordinateSequenceEmpty", "(Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/CoordinateSequence;", "getCoordinateSequenceOldMultiPoint", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/CoordinateSequence;", "toDimension", "(Ljava/util/EnumSet;)I", "getNextNumber", "", "getNextCloser", "readGeometryTaggedText", "type", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/lang/String;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/Geometry;", "isTypeName", "typeName", "readPointText", "Lorg/locationtech/jts/geom/Point;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/Point;", "readLineStringText", "Lorg/locationtech/jts/geom/LineString;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/LineString;", "readLinearRingText", "Lorg/locationtech/jts/geom/LinearRing;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/LinearRing;", "readMultiPointText", "Lorg/locationtech/jts/geom/MultiPoint;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/MultiPoint;", "readPolygonText", "Lorg/locationtech/jts/geom/Polygon;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/Polygon;", "readMultiLineStringText", "Lorg/locationtech/jts/geom/MultiLineString;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/MultiLineString;", "readMultiPolygonText", "Lorg/locationtech/jts/geom/MultiPolygon;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/MultiPolygon;", "readGeometryCollectionText", "Lorg/locationtech/jts/geom/GeometryCollection;", "(Lorg/locationtech/jts/io/StreamTokenizer;Ljava/util/EnumSet;)Lorg/locationtech/jts/geom/GeometryCollection;", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nWKTReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WKTReader.kt\norg/locationtech/jts/io/WKTReader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 EnumSet.kt\norg/locationtech/jts/legacy/EnumSetKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,961:1\n37#2,2:962\n37#2,2:964\n37#2,2:968\n37#2,2:970\n37#2,2:972\n37#2,2:974\n37#2,2:976\n15#3:966\n1#4:967\n*S KotlinDebug\n*F\n+ 1 WKTReader.kt\norg/locationtech/jts/io/WKTReader\n*L\n294#1:962,2\n329#1:964,2\n588#1:968,2\n621#1:970,2\n650#1:972,2\n680#1:974,2\n712#1:976,2\n409#1:966\n409#1:967\n*E\n"})
public final class WKTReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private GeometryFactory geometryFactory;
    @NotNull
    private final CoordinateSequenceFactory csFactory;
    @NotNull
    private final PrecisionModel precisionModel;
    private boolean isAllowOldJtsCoordinateSyntax;
    private boolean isAllowOldJtsMultipointSyntax;
    private boolean isFixStructure;
    @NotNull
    private static final String COMMA = ",";
    @NotNull
    private static final String L_PAREN = "(";
    @NotNull
    private static final String R_PAREN = ")";
    @NotNull
    private static final String NAN_SYMBOL = "NaN";
    @NotNull
    private static final CoordinateSequenceFactory csFactoryXYZM = CoordinateArraySequenceFactory.Companion.instance();
    private static final boolean ALLOW_OLD_JTS_COORDINATE_SYNTAX = true;
    private static final boolean ALLOW_OLD_JTS_MULTIPOINT_SYNTAX = true;

    @JvmOverloads
    public WKTReader(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this.geometryFactory = geometryFactory;
        this.csFactory = this.geometryFactory.getCoordinateSequenceFactory();
        this.isAllowOldJtsCoordinateSyntax = true;
        this.isAllowOldJtsMultipointSyntax = true;
        this.precisionModel = this.geometryFactory.getPrecisionModel();
    }

    public /* synthetic */ WKTReader(GeometryFactory geometryFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            geometryFactory = new GeometryFactory();
        }
        this(geometryFactory);
    }

    public final void setIsOldJtsCoordinateSyntaxAllowed(boolean value) {
        this.isAllowOldJtsCoordinateSyntax = value;
    }

    public final void setIsOldJtsMultiPointSyntaxAllowed(boolean value) {
        this.isAllowOldJtsMultipointSyntax = value;
    }

    public final void setFixStructure(boolean isFixStructure) {
        this.isFixStructure = isFixStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Geometry read(@NotNull String wellKnownText) throws ParseException {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)wellKnownText, (String)"wellKnownText");
        try (StringReader reader = new StringReader(wellKnownText);){
            geometry = this.read(reader);
        }
        return geometry;
    }

    @NotNull
    public final Geometry read(@NotNull Reader reader) throws ParseException {
        Geometry geometry;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        StreamTokenizer tokenizer = WKTReader.Companion.createTokenizer(reader);
        try {
            geometry = this.readGeometryTaggedText(tokenizer);
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        return geometry;
    }

    private final Coordinate getCoordinate(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags, boolean tryParen) throws IOException, ParseException {
        boolean opened = false;
        if (tryParen && WKTReader.Companion.isOpenerNext(tokenizer)) {
            tokenizer.nextToken();
            opened = true;
        }
        int offsetM = EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.Z) ? 1 : 0;
        Coordinate coord = this.createCoordinate(ordinateFlags);
        coord.setOrdinate(0, this.precisionModel.makePrecise(this.getNextNumber(tokenizer)));
        coord.setOrdinate(1, this.precisionModel.makePrecise(this.getNextNumber(tokenizer)));
        if (EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.Z)) {
            coord.setOrdinate(2, this.getNextNumber(tokenizer));
        }
        if (EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.M)) {
            coord.setOrdinate(2 + offsetM, this.getNextNumber(tokenizer));
        }
        if (EnumSetKt.getSize(ordinateFlags) == 2 && this.isAllowOldJtsCoordinateSyntax && WKTReader.Companion.isNumberNext(tokenizer)) {
            coord.setOrdinate(2, this.getNextNumber(tokenizer));
        }
        if (opened) {
            this.getNextCloser(tokenizer);
        }
        return coord;
    }

    private final Coordinate createCoordinate(EnumSet<Ordinate> ordinateFlags) {
        boolean hasZ = EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.Z);
        boolean hasM = EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.M);
        if (hasZ && hasM) {
            return new CoordinateXYZM();
        }
        if (hasM) {
            return new CoordinateXYM();
        }
        return hasZ || this.isAllowOldJtsCoordinateSyntax ? new Coordinate() : (Coordinate)new CoordinateXY();
    }

    private final CoordinateSequence getCoordinateSequence(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags, int minSize, boolean isRing) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)WKTReader.Companion.getNextEmptyOrOpener(tokenizer), (Object)"EMPTY")) {
            return this.createCoordinateSequenceEmpty(ordinateFlags);
        }
        List coordinates = new ArrayList();
        do {
            coordinates.add(this.getCoordinate(tokenizer, ordinateFlags, false));
        } while (Intrinsics.areEqual((Object)WKTReader.Companion.getNextCloserOrComma(tokenizer), (Object)COMMA));
        if (this.isFixStructure) {
            WKTReader.Companion.fixStructure(coordinates, minSize, isRing);
        }
        Collection $this$toTypedArray$iv = coordinates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Coordinate[] coordArray = thisCollection$iv.toArray(new Coordinate[0]);
        return this.csFactory.create(coordArray);
    }

    private final CoordinateSequence createCoordinateSequenceEmpty(EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.csFactory.create(0, this.toDimension(ordinateFlags), EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.M) ? 1 : 0);
    }

    private final CoordinateSequence getCoordinateSequenceOldMultiPoint(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        List coordinates = new ArrayList();
        do {
            coordinates.add(this.getCoordinate(tokenizer, ordinateFlags, true));
        } while (Intrinsics.areEqual((Object)WKTReader.Companion.getNextCloserOrComma(tokenizer), (Object)COMMA));
        Collection $this$toTypedArray$iv = coordinates;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Coordinate[] coordArray = thisCollection$iv.toArray(new Coordinate[0]);
        return this.csFactory.create(coordArray);
    }

    private final int toDimension(EnumSet<Ordinate> ordinateFlags) {
        int dimension = 2;
        if (EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.Z)) {
            ++dimension;
        }
        if (EnumSetKt.contains(ordinateFlags, (Enum)Ordinate.M)) {
            ++dimension;
        }
        if (dimension == 2 && this.isAllowOldJtsCoordinateSyntax) {
            ++dimension;
        }
        return dimension;
    }

    private final double getNextNumber(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        if (type == -3) {
            double d;
            if (StringsKt.equals((String)tokenizer.getSval(), (String)NAN_SYMBOL, (boolean)true)) {
                d = Double.NaN;
            } else {
                double d2;
                try {
                    String string = tokenizer.getSval();
                    Intrinsics.checkNotNull((Object)string);
                    d2 = Double.parseDouble(string);
                }
                catch (NumberFormatException ex) {
                    throw WKTReader.Companion.parseErrorWithLine(tokenizer, "Invalid number: " + tokenizer.getSval());
                }
                d = d2;
            }
            return d;
        }
        throw WKTReader.Companion.parseErrorExpected(tokenizer, "number");
    }

    private final String getNextCloser(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = WKTReader.Companion.getNextWord(tokenizer);
        if (Intrinsics.areEqual((Object)nextWord, (Object)R_PAREN)) {
            return nextWord;
        }
        throw WKTReader.Companion.parseErrorExpected(tokenizer, R_PAREN);
    }

    private final Geometry readGeometryTaggedText(StreamTokenizer tokenizer) throws IOException, ParseException {
        EnumSet<Ordinate> enumSet;
        Ordinate[] ordinateArray = new Ordinate[]{Ordinate.X, Ordinate.Y};
        Object[] values$iv = ordinateArray;
        boolean $i$f$enumSetOf = false;
        EnumSet<Ordinate> $this$enumSetOf_u24lambda_u240$iv = enumSet = EnumSet.noneOf(Ordinate.class);
        boolean bl = false;
        Intrinsics.checkNotNull($this$enumSetOf_u24lambda_u240$iv);
        CollectionsKt.addAll((Collection)$this$enumSetOf_u24lambda_u240$iv, (Object[])values$iv);
        EnumSet<Ordinate> enumSet2 = enumSet;
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"apply(...)");
        EnumSet<Ordinate> ordinateFlags = enumSet2;
        String string = WKTReader.Companion.getNextWord(tokenizer).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String type = string;
        if (StringsKt.endsWith$default((String)type, (String)"ZM", (boolean)false, (int)2, null)) {
            EnumSetKt.add(ordinateFlags, (Enum)Ordinate.Z);
            EnumSetKt.add(ordinateFlags, (Enum)Ordinate.M);
        } else if (StringsKt.endsWith$default((String)type, (String)"Z", (boolean)false, (int)2, null)) {
            EnumSetKt.add(ordinateFlags, (Enum)Ordinate.Z);
        } else if (StringsKt.endsWith$default((String)type, (String)"M", (boolean)false, (int)2, null)) {
            EnumSetKt.add(ordinateFlags, (Enum)Ordinate.M);
        }
        return this.readGeometryTaggedText(tokenizer, type, ordinateFlags);
    }

    private final Geometry readGeometryTaggedText(StreamTokenizer tokenizer, String type, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        EnumSet ordinateFlags2 = ordinateFlags;
        if (EnumSetKt.getSize(ordinateFlags2) == 2) {
            ordinateFlags2 = WKTReader.Companion.getNextOrdinateFlags(tokenizer);
        }
        try {
            this.csFactory.create(0, this.toDimension(ordinateFlags2), EnumSetKt.contains(ordinateFlags2, (Enum)Ordinate.M) ? 1 : 0);
        }
        catch (Exception e) {
            this.geometryFactory = new GeometryFactory(this.geometryFactory.getPrecisionModel(), this.geometryFactory.getSRID(), csFactoryXYZM);
        }
        if (this.isTypeName(tokenizer, type, "POINT")) {
            return this.readPointText(tokenizer, ordinateFlags2);
        }
        if (this.isTypeName(tokenizer, type, "LINESTRING")) {
            return this.readLineStringText(tokenizer, ordinateFlags2);
        }
        if (this.isTypeName(tokenizer, type, "LINEARRING")) {
            return this.readLinearRingText(tokenizer, ordinateFlags2);
        }
        if (this.isTypeName(tokenizer, type, "POLYGON")) {
            return this.readPolygonText(tokenizer, ordinateFlags2);
        }
        if (this.isTypeName(tokenizer, type, "MULTIPOINT")) {
            return this.readMultiPointText(tokenizer, ordinateFlags2);
        }
        if (this.isTypeName(tokenizer, type, "MULTILINESTRING")) {
            return this.readMultiLineStringText(tokenizer, ordinateFlags2);
        }
        if (this.isTypeName(tokenizer, type, "MULTIPOLYGON")) {
            return this.readMultiPolygonText(tokenizer, ordinateFlags2);
        }
        if (this.isTypeName(tokenizer, type, "GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText(tokenizer, ordinateFlags2);
        }
        throw WKTReader.Companion.parseErrorWithLine(tokenizer, "Unknown geometry type: " + type);
    }

    private final boolean isTypeName(StreamTokenizer tokenizer, String type, String typeName) throws ParseException {
        boolean isValidMod;
        if (!StringsKt.startsWith$default((String)type, (String)typeName, (boolean)false, (int)2, null)) {
            return false;
        }
        String string = type.substring(typeName.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String modifiers = string;
        boolean bl = modifiers.length() <= 2 && (((CharSequence)modifiers).length() == 0 || Intrinsics.areEqual((Object)modifiers, (Object)"Z") || Intrinsics.areEqual((Object)modifiers, (Object)"M") || Intrinsics.areEqual((Object)modifiers, (Object)"ZM")) ? true : (isValidMod = false);
        if (!isValidMod) {
            throw WKTReader.Companion.parseErrorWithLine(tokenizer, "Invalid dimension modifiers: " + type);
        }
        return true;
    }

    private final Point readPointText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.geometryFactory.createPoint(this.getCoordinateSequence(tokenizer, ordinateFlags, 1, false));
    }

    private final LineString readLineStringText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.geometryFactory.createLineString(this.getCoordinateSequence(tokenizer, ordinateFlags, 2, false));
    }

    private final LinearRing readLinearRingText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        return this.geometryFactory.createLinearRing(this.getCoordinateSequence(tokenizer, ordinateFlags, 3, true));
    }

    private final MultiPoint readMultiPointText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextWord;
        String nextToken = WKTReader.Companion.getNextEmptyOrOpener(tokenizer);
        if (Intrinsics.areEqual((Object)nextToken, (Object)"EMPTY")) {
            return this.geometryFactory.createMultiPoint(new Point[0]);
        }
        if (this.isAllowOldJtsMultipointSyntax && !Intrinsics.areEqual((Object)(nextWord = WKTReader.Companion.lookAheadWord(tokenizer)), (Object)L_PAREN) && !Intrinsics.areEqual((Object)nextWord, (Object)"EMPTY")) {
            return this.geometryFactory.createMultiPoint(this.getCoordinateSequenceOldMultiPoint(tokenizer, ordinateFlags));
        }
        List points = new ArrayList();
        Point point = this.readPointText(tokenizer, ordinateFlags);
        points.add(point);
        nextToken = WKTReader.Companion.getNextCloserOrComma(tokenizer);
        while (Intrinsics.areEqual((Object)nextToken, (Object)COMMA)) {
            point = this.readPointText(tokenizer, ordinateFlags);
            points.add(point);
            nextToken = WKTReader.Companion.getNextCloserOrComma(tokenizer);
        }
        Point[] array = new Point[points.size()];
        Collection $this$toTypedArray$iv = points;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.geometryFactory.createMultiPoint(thisCollection$iv.toArray(new Point[0]));
    }

    private final Polygon readPolygonText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.Companion.getNextEmptyOrOpener(tokenizer);
        if (Intrinsics.areEqual((Object)nextToken, (Object)"EMPTY")) {
            return this.geometryFactory.createPolygon(this.createCoordinateSequenceEmpty(ordinateFlags));
        }
        List holes = new ArrayList();
        LinearRing shell = this.readLinearRingText(tokenizer, ordinateFlags);
        nextToken = WKTReader.Companion.getNextCloserOrComma(tokenizer);
        while (Intrinsics.areEqual((Object)nextToken, (Object)COMMA)) {
            LinearRing hole = this.readLinearRingText(tokenizer, ordinateFlags);
            holes.add(hole);
            nextToken = WKTReader.Companion.getNextCloserOrComma(tokenizer);
        }
        LinearRing[] array = new LinearRing[holes.size()];
        Collection $this$toTypedArray$iv = holes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.geometryFactory.createPolygon(shell, thisCollection$iv.toArray(new LinearRing[0]));
    }

    private final MultiLineString readMultiLineStringText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.Companion.getNextEmptyOrOpener(tokenizer);
        if (Intrinsics.areEqual((Object)nextToken, (Object)"EMPTY")) {
            return this.geometryFactory.createMultiLineString();
        }
        List lineStrings = new ArrayList();
        do {
            LineString lineString = this.readLineStringText(tokenizer, ordinateFlags);
            lineStrings.add(lineString);
        } while (Intrinsics.areEqual((Object)(nextToken = WKTReader.Companion.getNextCloserOrComma(tokenizer)), (Object)COMMA));
        LineString[] array = new LineString[lineStrings.size()];
        Collection $this$toTypedArray$iv = lineStrings;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.geometryFactory.createMultiLineString(thisCollection$iv.toArray(new LineString[0]));
    }

    private final MultiPolygon readMultiPolygonText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.Companion.getNextEmptyOrOpener(tokenizer);
        if (Intrinsics.areEqual((Object)nextToken, (Object)"EMPTY")) {
            return this.geometryFactory.createMultiPolygon();
        }
        List polygons = new ArrayList();
        do {
            Polygon polygon = this.readPolygonText(tokenizer, ordinateFlags);
            polygons.add(polygon);
        } while (Intrinsics.areEqual((Object)(nextToken = WKTReader.Companion.getNextCloserOrComma(tokenizer)), (Object)COMMA));
        Polygon[] array = new Polygon[polygons.size()];
        Collection $this$toTypedArray$iv = polygons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.geometryFactory.createMultiPolygon(thisCollection$iv.toArray(new Polygon[0]));
    }

    private final GeometryCollection readGeometryCollectionText(StreamTokenizer tokenizer, EnumSet<Ordinate> ordinateFlags) throws IOException, ParseException {
        String nextToken = WKTReader.Companion.getNextEmptyOrOpener(tokenizer);
        if (Intrinsics.areEqual((Object)nextToken, (Object)"EMPTY")) {
            return this.geometryFactory.createGeometryCollection();
        }
        List geometries = new ArrayList();
        do {
            Geometry geometry = this.readGeometryTaggedText(tokenizer);
            geometries.add(geometry);
        } while (Intrinsics.areEqual((Object)(nextToken = WKTReader.Companion.getNextCloserOrComma(tokenizer)), (Object)COMMA));
        Geometry[] array = new Geometry[geometries.size()];
        Collection $this$toTypedArray$iv = geometries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return this.geometryFactory.createGeometryCollection(thisCollection$iv.toArray(new Geometry[0]));
    }

    @JvmOverloads
    public WKTReader() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J&\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0016\u0010\u001c\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J%\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u0005H\u0002J\u0018\u0010-\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/locationtech/jts/io/WKTReader$Companion;", "", "<init>", "()V", "COMMA", "", "L_PAREN", "R_PAREN", "NAN_SYMBOL", "csFactoryXYZM", "Lorg/locationtech/jts/geom/CoordinateSequenceFactory;", "ALLOW_OLD_JTS_COORDINATE_SYNTAX", "", "ALLOW_OLD_JTS_MULTIPOINT_SYNTAX", "createTokenizer", "Lorg/locationtech/jts/io/StreamTokenizer;", "reader", "Ljava/io/Reader;", "Lorg/locationtech/jts/io/Reader;", "(Ljava/io/Reader;)Lorg/locationtech/jts/io/StreamTokenizer;", "fixStructure", "", "coords", "", "Lorg/locationtech/jts/geom/Coordinate;", "minSize", "", "isRing", "isClosed", "", "isNumberNext", "tokenizer", "isOpenerNext", "getNextEmptyOrOpener", "getNextOrdinateFlags", "Ljava/util/EnumSet;", "Lorg/locationtech/jts/io/Ordinate;", "Lorg/locationtech/jts/legacy/EnumSet;", "(Lorg/locationtech/jts/io/StreamTokenizer;)Ljava/util/EnumSet;", "lookAheadWord", "getNextCloserOrComma", "getNextWord", "parseErrorExpected", "Lorg/locationtech/jts/io/ParseException;", "expected", "parseErrorWithLine", "msg", "tokenString", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nWKTReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WKTReader.kt\norg/locationtech/jts/io/WKTReader$Companion\n+ 2 EnumSet.kt\norg/locationtech/jts/legacy/EnumSetKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,961:1\n15#2:962\n1#3:963\n*S KotlinDebug\n*F\n+ 1 WKTReader.kt\norg/locationtech/jts/io/WKTReader$Companion\n*L\n841#1:962\n841#1:963\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final StreamTokenizer createTokenizer(Reader reader) {
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(160, 255);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.commentChar(35);
            return tokenizer;
        }

        private final void fixStructure(List<Coordinate> coords, int minSize, boolean isRing) {
            if (coords.size() == 0) {
                return;
            }
            if (isRing && !this.isClosed(coords)) {
                coords.add(coords.get(0).copy());
            }
            while (coords.size() < minSize) {
                coords.add(coords.get(coords.size() - 1).copy());
            }
        }

        private final boolean isClosed(List<? extends Coordinate> coords) {
            if (coords.isEmpty()) {
                return true;
            }
            return coords.size() != 1 && coords.get(0).equals2D(coords.get(coords.size() - 1));
        }

        private final boolean isNumberNext(StreamTokenizer tokenizer) {
            int type = tokenizer.nextToken();
            tokenizer.pushBack();
            return type == -3;
        }

        private final boolean isOpenerNext(StreamTokenizer tokenizer) throws IOException {
            int type = tokenizer.nextToken();
            tokenizer.pushBack();
            return type == 40;
        }

        private final String getNextEmptyOrOpener(StreamTokenizer tokenizer) throws IOException, ParseException {
            String nextWord = this.getNextWord(tokenizer);
            if (StringsKt.equals((String)nextWord, (String)"Z", (boolean)true)) {
                nextWord = this.getNextWord(tokenizer);
            } else if (StringsKt.equals((String)nextWord, (String)"M", (boolean)true)) {
                nextWord = this.getNextWord(tokenizer);
            } else if (StringsKt.equals((String)nextWord, (String)"ZM", (boolean)true)) {
                nextWord = this.getNextWord(tokenizer);
            }
            if (Intrinsics.areEqual((Object)nextWord, (Object)"EMPTY") || Intrinsics.areEqual((Object)nextWord, (Object)WKTReader.L_PAREN)) {
                return nextWord;
            }
            throw this.parseErrorExpected(tokenizer, "EMPTY or (");
        }

        private final EnumSet<Ordinate> getNextOrdinateFlags(StreamTokenizer tokenizer) throws IOException, ParseException {
            EnumSet<Ordinate> enumSet;
            Ordinate[] ordinateArray = new Ordinate[]{Ordinate.X, Ordinate.Y};
            Object[] values$iv = ordinateArray;
            boolean $i$f$enumSetOf = false;
            EnumSet<Ordinate> $this$enumSetOf_u24lambda_u240$iv = enumSet = EnumSet.noneOf(Ordinate.class);
            boolean bl = false;
            Intrinsics.checkNotNull($this$enumSetOf_u24lambda_u240$iv);
            CollectionsKt.addAll((Collection)$this$enumSetOf_u24lambda_u240$iv, (Object[])values$iv);
            EnumSet<Ordinate> enumSet2 = enumSet;
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"apply(...)");
            EnumSet<Ordinate> result2 = enumSet2;
            String string = this.lookAheadWord(tokenizer).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String nextWord = string;
            if (StringsKt.equals((String)nextWord, (String)"Z", (boolean)true)) {
                tokenizer.nextToken();
                EnumSetKt.add(result2, (Enum)Ordinate.Z);
            } else if (StringsKt.equals((String)nextWord, (String)"M", (boolean)true)) {
                tokenizer.nextToken();
                EnumSetKt.add(result2, (Enum)Ordinate.M);
            } else if (StringsKt.equals((String)nextWord, (String)"ZM", (boolean)true)) {
                tokenizer.nextToken();
                EnumSetKt.add(result2, (Enum)Ordinate.Z);
                EnumSetKt.add(result2, (Enum)Ordinate.M);
            }
            return result2;
        }

        private final String lookAheadWord(StreamTokenizer tokenizer) throws IOException, ParseException {
            String nextWord = this.getNextWord(tokenizer);
            tokenizer.pushBack();
            return nextWord;
        }

        private final String getNextCloserOrComma(StreamTokenizer tokenizer) throws IOException, ParseException {
            String nextWord = this.getNextWord(tokenizer);
            if (Intrinsics.areEqual((Object)nextWord, (Object)WKTReader.COMMA) || Intrinsics.areEqual((Object)nextWord, (Object)WKTReader.R_PAREN)) {
                return nextWord;
            }
            throw this.parseErrorExpected(tokenizer, ", or )");
        }

        private final String getNextWord(StreamTokenizer tokenizer) throws IOException, ParseException {
            int type = tokenizer.nextToken();
            switch (type) {
                case -3: {
                    String string = tokenizer.getSval();
                    Intrinsics.checkNotNull((Object)string);
                    String word = string;
                    return StringsKt.equals((String)word, (String)"EMPTY", (boolean)true) ? "EMPTY" : word;
                }
                case 40: {
                    return WKTReader.L_PAREN;
                }
                case 41: {
                    return WKTReader.R_PAREN;
                }
                case 44: {
                    return WKTReader.COMMA;
                }
            }
            throw this.parseErrorExpected(tokenizer, "word");
        }

        private final ParseException parseErrorExpected(StreamTokenizer tokenizer, String expected) {
            if (tokenizer.getTtype() == -2) {
                Assert.shouldNeverReachHere("Unexpected NUMBER token");
            }
            if (tokenizer.getTtype() == 10) {
                Assert.shouldNeverReachHere("Unexpected EOL token");
            }
            String tokenStr = this.tokenString(tokenizer);
            return this.parseErrorWithLine(tokenizer, "Expected " + expected + " but found " + tokenStr);
        }

        private final ParseException parseErrorWithLine(StreamTokenizer tokenizer, String msg) {
            return new ParseException(msg + " (line " + tokenizer.lineno() + WKTReader.R_PAREN);
        }

        private final String tokenString(StreamTokenizer tokenizer) {
            switch (tokenizer.getTtype()) {
                case -2: {
                    return "<NUMBER>";
                }
                case 10: {
                    return "End-of-Line";
                }
                case -1: {
                    return "End-of-Stream";
                }
                case -3: {
                    return "'" + tokenizer.getSval() + "'";
                }
            }
            return "'" + (char)tokenizer.getTtype() + "'";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

