/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.legacy.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.AbstractMutableCollection;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.legacy.map.AbstractNavigableMap;
import org.locationtech.jts.legacy.map.NavigableMap;
import org.locationtech.jts.legacy.map.SortedMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010)\n\u0002\u0010'\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\b\u000e\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0016\u0018\u0000 t*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00060\u0005j\u0002`\u0006:\bmnopqrstB/\b\u0007\u0012$\b\u0002\u0010\u0007\u001a\u001e\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u0000\u0018\u00010\bj\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0016\u0010\f\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\r\u00a2\u0006\u0004\b\n\u0010\u000eB!\b\u0016\u0012\u0016\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000f\u00a2\u0006\u0004\b\n\u0010\u0010J\n\u0010\u001e\u001a\u00020\u001fH\u0096\u0080\u0004J\u001c\u0010 \u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\bj\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\tH\u0016J)\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'2\u0006\u0010(\u001a\u00028\u00002\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010+J!\u0010,\u001a\u0004\u0018\u00018\u00012\u0006\u0010-\u001a\u00028\u00002\u0006\u0010.\u001a\u00028\u0001H\u0096\u0080\b\u00a2\u0006\u0002\u0010/J\u0019\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u00101\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u00102J9\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'2\u0006\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u00020*2\u0006\u0010(\u001a\u00028\u00002\u0006\u00106\u001a\u00020*H\u0016\u00a2\u0006\u0002\u00107J)\u00108\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'2\u0006\u00104\u001a\u00028\u00002\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010+J+\u00109\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00172\u0006\u0010-\u001a\u00028\u00002\u0006\u0010)\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010:J+\u0010;\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00172\u0006\u0010-\u001a\u00028\u00002\u0006\u0010)\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010:J\u0006\u0010<\u001a\u00020\u001fJ\u001a\u0010=\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010?0>H\u0016J\u001a\u0010@\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010?0>H\u0016J&\u0010<\u001a\u00020\u00192\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00172\u0006\u0010B\u001a\u00020*H\u0002J#\u0010C\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010D2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010EJ#\u0010K\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010D2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010EJ#\u0010L\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010D2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010EJ#\u0010M\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010D2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010EJ#\u0010N\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010D2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010EJ\u001c\u0010O\u001a\u00020*2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010DH\u0016Ji\u0010Q\u001a\u00020\u001f2\u0018\u0010R\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010?0S2\u0006\u0010T\u001a\u00020U2\u0014\u0010V\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00172\b\u00104\u001a\u0004\u0018\u00018\u00002\u0006\u00105\u001a\u00020*2\b\u0010(\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010WJA\u0010X\u001a\u00020*2\u0006\u0010T\u001a\u00020U2\u0006\u0010-\u001a\u00028\u00002\b\u00104\u001a\u0004\u0018\u00018\u00002\u0006\u00105\u001a\u00020*2\b\u0010(\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010YJL\u0010Z\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00172\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00172\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00172\f\u0010\\\u001a\b\u0012\u0004\u0012\u00028\u00010]H\u0002J\u001e\u0010B\u001a\u00020*2\u0014\u0010^\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0017H\u0002J'\u0010_\u001a\u00020*2\u0006\u0010`\u001a\u00028\u00002\b\u0010a\u001a\u0004\u0018\u00018\u00002\u0006\u0010b\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010cJ'\u0010d\u001a\u00020*2\u0006\u0010`\u001a\u00028\u00002\b\u0010a\u001a\u0004\u0018\u00018\u00002\u0006\u0010b\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010cJ#\u0010e\u001a\u00020*2\u0006\u0010-\u001a\u00028\u00002\f\u0010\\\u001a\b\u0012\u0004\u0012\u00028\u00010]H\u0002\u00a2\u0006\u0002\u0010fJD\u0010g\u001a\u00020\u001f2\u0012\u0010h\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00172\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00172\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0017H\u0002J\u0010\u0010i\u001a\u00020\u001f2\u0006\u0010a\u001a\u00020*H\u0002J2\u0010j\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00172\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00172\u0006\u0010k\u001a\u00020\u0019H\u0002J2\u0010l\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00172\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00172\u0006\u0010k\u001a\u00020\u0019H\u0002R*\u0010\u0011\u001a\u001e\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u0000\u0018\u00010\bj\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00018\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u0019X\u0096\u008e\b\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\"8VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\"\u0010F\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010D8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\"\u0010I\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010D8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010H\u00a8\u0006u"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap;", "K", "", "V", "Lorg/locationtech/jts/legacy/map/AbstractNavigableMap;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "c", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Ljava/util/Comparator;)V", "map", "", "(Ljava/util/Map;)V", "Lorg/locationtech/jts/legacy/map/SortedMap;", "(Lorg/locationtech/jts/legacy/map/SortedMap;)V", "cmp", "exposeKeyType", "Ljava/lang/Comparable;", "exposeValueType", "Ljava/lang/Object;", "root", "Lorg/locationtech/jts/legacy/map/TreeMap$Node;", "size", "", "getSize", "()I", "setSize", "(I)V", "clear", "", "comparator", "__values", "", "values", "getValues", "()Ljava/util/Collection;", "headMap", "Lorg/locationtech/jts/legacy/map/NavigableMap;", "toKey", "inclusive", "", "(Ljava/lang/Comparable;Z)Lorg/locationtech/jts/legacy/map/NavigableMap;", "put", "key", "value", "(Ljava/lang/Comparable;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "k", "(Ljava/lang/Comparable;)Ljava/lang/Object;", "subMap", "fromKey", "fromInclusive", "toInclusive", "(Ljava/lang/Comparable;ZLjava/lang/Comparable;Z)Lorg/locationtech/jts/legacy/map/NavigableMap;", "tailMap", "getNodeAfter", "(Ljava/lang/Comparable;Z)Lorg/locationtech/jts/legacy/map/TreeMap$Node;", "getNodeBefore", "assertCorrectness", "descendingEntryIterator", "", "", "entryIterator", "tree", "isRed", "getEntry", "", "(Ljava/lang/Comparable;)Ljava/util/Map$Entry;", "firstEntryField", "getFirstEntryField", "()Ljava/util/Map$Entry;", "lastEntryField", "getLastEntryField", "getCeilingEntry", "getFloorEntry", "getHigherEntry", "getLowerEntry", "removeEntry", "entry", "inOrderAdd", "list", "", "type", "Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "current", "(Ljava/util/List;Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;Lorg/locationtech/jts/legacy/map/TreeMap$Node;Ljava/lang/Comparable;ZLjava/lang/Comparable;Z)V", "inRange", "(Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;Ljava/lang/Comparable;Ljava/lang/Comparable;ZLjava/lang/Comparable;Z)Z", "insert", "newNode", "state", "Lorg/locationtech/jts/legacy/map/TreeMap$State;", "node", "larger", "a", "b", "orEqual", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Z)Z", "smaller", "removeWithState", "(Ljava/lang/Comparable;Lorg/locationtech/jts/legacy/map/TreeMap$State;)Z", "replaceNode", "head", "assert", "rotateDouble", "rotateDirection", "rotateSingle", "DescendingEntryIterator", "EntryIterator", "TEntrySet", "Node", "State", "SubMap", "SubMapType", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nTreeMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeMap.kt\norg/locationtech/jts/legacy/map/TreeMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,995:1\n1#2:996\n*E\n"})
public class TreeMap<K extends Comparable<? super K>, V>
extends AbstractNavigableMap<K, V>
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Comparator<? super K> cmp;
    @Nullable
    private final K exposeKeyType;
    @Nullable
    private final V exposeValueType;
    @Nullable
    private transient Node<K, V> root;
    private int size;
    @Nullable
    private Collection<V> __values;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;

    @JvmOverloads
    public TreeMap(@Nullable Comparator<? super K> c) {
        this.root = null;
        this.cmp = c;
    }

    public /* synthetic */ TreeMap(Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            comparator = ComparisonsKt.naturalOrder();
        }
        this(comparator);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public TreeMap(@Nullable Map<? extends K, ? extends V> map) {
        this(null, 1, null);
        Map<? extends K, ? extends V> map2 = map;
        Intrinsics.checkNotNull(map2);
        this.putAll(map2);
    }

    public TreeMap(@Nullable SortedMap<K, V> map) {
        SortedMap<K, V> sortedMap = map;
        if (sortedMap == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this(sortedMap.comparator());
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void clear() {
        this.root = null;
        this.setSize(0);
    }

    @Override
    @NotNull
    public Comparator<? super K> comparator() {
        Comparator<? super K> comparator = this.cmp;
        Intrinsics.checkNotNull(comparator);
        return ComparisonsKt.nullsLast(comparator);
    }

    @Override
    @NotNull
    public Collection<V> getValues() {
        if (this.__values == null) {
            this.__values = (Collection)new AbstractMutableCollection<V>(this){
                final /* synthetic */ TreeMap<K, V> this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean contains(Object element) {
                    return this.this$0.containsValue(element);
                }

                public boolean add(V element) {
                    String string = "Not yet implemented";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }

                public Iterator<V> iterator() {
                    Iterator<E> entryIterator = this.this$0.entrySet().iterator();
                    return new Iterator<V>(entryIterator){
                        final /* synthetic */ Iterator<Map.Entry<K, V>> $entryIterator;
                        {
                            this.$entryIterator = $entryIterator;
                        }

                        public boolean hasNext() {
                            return this.$entryIterator.hasNext();
                        }

                        public V next() {
                            return this.$entryIterator.next().getValue();
                        }

                        public void remove() {
                            String string = "Not yet implemented";
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }
                    };
                }

                public int getSize() {
                    return this.this$0.size();
                }
            };
        }
        Collection<V> collection = this.__values;
        Intrinsics.checkNotNull(collection);
        return collection;
    }

    @Override
    @NotNull
    public NavigableMap<K, V> headMap(@NotNull K toKey, boolean inclusive) {
        Intrinsics.checkNotNullParameter(toKey, (String)"toKey");
        return new SubMap(this, SubMapType.Head, null, false, toKey, inclusive);
    }

    @Override
    @Nullable
    public V put(@NotNull K key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Node node = new Node(key, value, false, 4, null);
        State state = new State();
        this.root = this.insert(this.root, node, state);
        if (!state.getFound()) {
            this.setSize(this.size() + 1);
            this.size();
        }
        Node<K, V> node2 = this.root;
        Intrinsics.checkNotNull(node2);
        node2.setRed(false);
        return state.getValue();
    }

    @Override
    @Nullable
    public V remove(@NotNull K k) {
        Intrinsics.checkNotNullParameter(k, (String)"k");
        State state = new State();
        this.removeWithState(k, state);
        return state.getValue();
    }

    @Override
    @NotNull
    public NavigableMap<K, V> subMap(@NotNull K fromKey, boolean fromInclusive, @NotNull K toKey, boolean toInclusive) {
        Intrinsics.checkNotNullParameter(fromKey, (String)"fromKey");
        Intrinsics.checkNotNullParameter(toKey, (String)"toKey");
        return new SubMap(this, SubMapType.Range, fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    @NotNull
    public NavigableMap<K, V> tailMap(@NotNull K fromKey, boolean inclusive) {
        Intrinsics.checkNotNullParameter(fromKey, (String)"fromKey");
        return new SubMap(this, SubMapType.Tail, fromKey, inclusive, null, false);
    }

    private final Node<K, V> getNodeAfter(K key, boolean inclusive) {
        Node<K, V> foundNode = null;
        Node<K, V> node = this.root;
        while (node != null) {
            Comparator<K> comparator = this.cmp;
            Intrinsics.checkNotNull(comparator);
            int c = comparator.compare(key, node.getKey());
            if (inclusive && c == 0) {
                return node;
            }
            if (c >= 0) {
                node = node.getChild()[1];
                continue;
            }
            foundNode = node;
            node = node.getChild()[0];
        }
        return foundNode;
    }

    private final Node<K, V> getNodeBefore(K key, boolean inclusive) {
        Node<K, V> foundNode = null;
        Node<K, V> node = this.root;
        while (node != null) {
            Comparator<K> comparator = this.cmp;
            Intrinsics.checkNotNull(comparator);
            int c = comparator.compare(key, node.getKey());
            if (inclusive && c == 0) {
                return node;
            }
            if (c <= 0) {
                node = node.getChild()[0];
                continue;
            }
            foundNode = node;
            node = node.getChild()[1];
        }
        return foundNode;
    }

    public final void assertCorrectness() {
        this.assertCorrectness(this.root, true);
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> descendingEntryIterator() {
        return new DescendingEntryIterator(this, null, null, false, null, false, 31, null);
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return new EntryIterator(this, null, null, false, null, false, 31, null);
    }

    private final int assertCorrectness(Node<K, V> tree, boolean isRed) {
        Node<K, V> rightNode;
        if (tree == null) {
            return 0;
        }
        if (isRed && tree.isRed()) {
            throw new RuntimeException("Two red nodes adjacent");
        }
        Node<K, V> leftNode = tree.getChild()[0];
        if (leftNode != null) {
            Comparator<K> comparator = this.cmp;
            Intrinsics.checkNotNull(comparator);
            if (comparator.compare(leftNode.getKey(), tree.getKey()) > 0) {
                throw new RuntimeException("Left child " + leftNode + " larger than " + tree);
            }
        }
        if ((rightNode = tree.getChild()[1]) != null) {
            Comparator<K> comparator = this.cmp;
            Intrinsics.checkNotNull(comparator);
            if (comparator.compare(rightNode.getKey(), tree.getKey()) < 0) {
                throw new RuntimeException("Right child " + rightNode + " smaller than " + tree);
            }
        }
        int leftHeight = this.assertCorrectness(leftNode, tree.isRed());
        int rightHeight = this.assertCorrectness(rightNode, tree.isRed());
        if (leftHeight != 0 && rightHeight != 0 && leftHeight != rightHeight) {
            throw new RuntimeException("Black heights don't match");
        }
        return tree.isRed() ? leftHeight : leftHeight + 1;
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getEntry(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Node<K, V> tree = this.root;
        while (tree != null) {
            Comparator<K> comparator = this.cmp;
            Intrinsics.checkNotNull(comparator);
            int c = comparator.compare(key, tree.getKey());
            if (c == 0) {
                return tree;
            }
            int childNum = c < 0 ? 0 : 1;
            tree = tree.getChild()[childNum];
        }
        return null;
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getFirstEntryField() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> node = this.root;
        Node<K, V> nextNode = null;
        while (true) {
            Node<K, V> node2;
            Node<K, V> node3 = node;
            Intrinsics.checkNotNull(node3);
            Node<K, V> it = node2 = node3.getChild()[0];
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (node2 == null) break;
            node = nextNode;
        }
        return node;
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getLastEntryField() {
        if (this.root == null) {
            return null;
        }
        Node<K, V> node = this.root;
        Intrinsics.checkNotNull(node);
        Node<K, V> node2 = node;
        Node<K, V> nextNode = null;
        while (true) {
            Node<K, V> node3;
            Node<K, V> it = node3 = node2.getChild()[1];
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (node3 == null) break;
            node2 = nextNode;
        }
        Node<K, V> node4 = node2;
        Intrinsics.checkNotNull(node4, (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<K of org.locationtech.jts.legacy.map.TreeMap, V of org.locationtech.jts.legacy.map.TreeMap>");
        return node4;
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getCeilingEntry(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Node<K, V> node = this.getNodeAfter(key, true);
        Intrinsics.checkNotNull(node, (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<K of org.locationtech.jts.legacy.map.TreeMap, V of org.locationtech.jts.legacy.map.TreeMap>");
        return node;
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getFloorEntry(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Node<K, V> node = this.getNodeBefore(key, true);
        Intrinsics.checkNotNull(node, (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<K of org.locationtech.jts.legacy.map.TreeMap, V of org.locationtech.jts.legacy.map.TreeMap>");
        return node;
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getHigherEntry(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Node<K, V> node = this.getNodeAfter(key, false);
        Intrinsics.checkNotNull(node, (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<K of org.locationtech.jts.legacy.map.TreeMap, V of org.locationtech.jts.legacy.map.TreeMap>");
        return node;
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getLowerEntry(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Node<K, V> node = this.getNodeBefore(key, false);
        Intrinsics.checkNotNull(node, (String)"null cannot be cast to non-null type kotlin.collections.Map.Entry<K of org.locationtech.jts.legacy.map.TreeMap, V of org.locationtech.jts.legacy.map.TreeMap>");
        return node;
    }

    @Override
    public boolean removeEntry(@NotNull Map.Entry<? extends K, ? extends V> entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        State<V> state = new State<V>();
        state.setMatchValue(true);
        state.setValue(entry.getValue());
        return this.removeWithState((Comparable)entry.getKey(), state);
    }

    private final void inOrderAdd(List<Map.Entry<K, V>> list, SubMapType type, Node<K, V> current, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        block3: {
            Node<K, V> rightNode;
            Node<K, V> leftNode;
            if (current == null) {
                return;
            }
            Node<K, V> node = leftNode = current.getChild()[0];
            if (node != null) {
                Node<K, V> it = node;
                boolean bl = false;
                this.inOrderAdd(list, type, it, fromKey, fromInclusive, toKey, toInclusive);
            }
            Object k = current.getKey();
            Intrinsics.checkNotNull(k);
            if (this.inRange(type, (Comparable)k, fromKey, fromInclusive, toKey, toInclusive)) {
                list.add(TypeIntrinsics.asMutableMapEntry(current));
            }
            Node<K, V> node2 = rightNode = current.getChild()[1];
            if (node2 == null) break block3;
            Node<K, V> it = node2;
            boolean bl = false;
            this.inOrderAdd(list, type, it, fromKey, fromInclusive, toKey, toInclusive);
        }
    }

    private final boolean inRange(SubMapType type, K key, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        if (type.fromKeyValid() && this.smaller(key, fromKey, !fromInclusive)) {
            return false;
        }
        return !type.toKeyValid() || !this.larger(key, toKey, !toInclusive);
    }

    private final Node<K, V> insert(Node<K, V> tree, Node<K, V> newNode, State<V> state) {
        Node tree2 = tree;
        if (tree2 == null) {
            return newNode;
        }
        Comparator<K> comparator = this.cmp;
        Intrinsics.checkNotNull(comparator);
        int c = comparator.compare(newNode.getKey(), tree2.getKey());
        if (c == 0) {
            state.setValue(tree2.setValue(newNode.getValue()));
            state.setFound(true);
            return tree2;
        }
        int childNum = c < 0 ? 0 : 1;
        tree2.getChild()[childNum] = this.insert(tree2.getChild()[childNum], newNode, state);
        if (this.isRed(tree2.getChild()[childNum])) {
            if (this.isRed(tree2.getChild()[TreeMap.Companion.otherChild(childNum)])) {
                tree2.setRed(true);
                Node<K, V> node = tree2.getChild()[0];
                Intrinsics.checkNotNull(node);
                node.setRed(false);
                Node<K, V> node2 = tree2.getChild()[1];
                Intrinsics.checkNotNull(node2);
                node2.setRed(false);
            } else {
                Node<K, V> node = tree2.getChild()[childNum];
                Intrinsics.checkNotNull(node);
                if (this.isRed(node.getChild()[childNum])) {
                    tree2 = this.rotateSingle(tree2, TreeMap.Companion.otherChild(childNum));
                } else {
                    Node<K, V> node3 = tree2.getChild()[childNum];
                    Intrinsics.checkNotNull(node3);
                    if (this.isRed(node3.getChild()[TreeMap.Companion.otherChild(childNum)])) {
                        tree2 = this.rotateDouble(tree2, TreeMap.Companion.otherChild(childNum));
                    }
                }
            }
        }
        return tree2;
    }

    private final boolean isRed(Node<K, V> node) {
        return node != null && node.isRed();
    }

    private final boolean larger(K a, K b, boolean orEqual) {
        Comparator<K> comparator = this.cmp;
        Intrinsics.checkNotNull(comparator);
        int compare = comparator.compare(a, b);
        return compare > 0 || orEqual && compare == 0;
    }

    private final boolean smaller(K a, K b, boolean orEqual) {
        Comparator<K> comparator = this.cmp;
        Intrinsics.checkNotNull(comparator);
        int compare = comparator.compare(a, b);
        return compare < 0 || orEqual && compare == 0;
    }

    private final boolean removeWithState(K key, State<V> state) {
        if (this.root == null) {
            return false;
        }
        Node found = null;
        Node parent = null;
        Node head = new Node(null, null, false, 4, null);
        int dir = 1;
        head.getChild()[1] = this.root;
        Node node = head;
        while (node.getChild()[dir] != null) {
            int dir2;
            Node sibling;
            int last = dir;
            Node grandparent = parent;
            parent = node;
            node = node.getChild()[dir];
            Comparator<K> comparator = this.cmp;
            Intrinsics.checkNotNull(comparator);
            Node node2 = node;
            Intrinsics.checkNotNull(node2);
            int c = comparator.compare(key, node2.getKey());
            int n = dir = c < 0 ? 0 : 1;
            if (c == 0 && (!state.getMatchValue() || Intrinsics.areEqual(node.getValue(), state.getValue()))) {
                found = node;
            }
            if (this.isRed(node) || this.isRed(node.getChild()[dir])) continue;
            if (this.isRed(node.getChild()[TreeMap.Companion.otherChild(dir)])) {
                parent.getChild()[last] = this.rotateSingle(node, dir);
                parent = parent.getChild()[last];
                continue;
            }
            if (this.isRed(node.getChild()[TreeMap.Companion.otherChild(dir)]) || (sibling = parent.getChild()[TreeMap.Companion.otherChild(last)]) == null) continue;
            if (!this.isRed(sibling.getChild()[TreeMap.Companion.otherChild(last)]) && !this.isRed(sibling.getChild()[last])) {
                parent.setRed(false);
                sibling.setRed(true);
                node.setRed(true);
                continue;
            }
            this.assert(grandparent != null);
            Node node3 = grandparent;
            Intrinsics.checkNotNull(node3);
            int n2 = dir2 = node3.getChild()[1] == parent ? 1 : 0;
            if (this.isRed(sibling.getChild()[last])) {
                grandparent.getChild()[dir2] = this.rotateDouble(parent, last);
            } else if (this.isRed(sibling.getChild()[TreeMap.Companion.otherChild(last)])) {
                grandparent.getChild()[dir2] = this.rotateSingle(parent, last);
            }
            Node node4 = grandparent.getChild()[dir2];
            Intrinsics.checkNotNull(node4);
            node4.setRed(true);
            Node node5 = grandparent.getChild()[dir2];
            Intrinsics.checkNotNull(node5);
            node.setRed(node5.isRed());
            Node node6 = grandparent.getChild()[dir2];
            Intrinsics.checkNotNull(node6);
            Node node7 = node6.getChild()[0];
            Intrinsics.checkNotNull(node7);
            node7.setRed(false);
            Node node8 = grandparent.getChild()[dir2];
            Intrinsics.checkNotNull(node8);
            Node node9 = node8.getChild()[1];
            Intrinsics.checkNotNull(node9);
            node9.setRed(false);
        }
        if (found != null) {
            state.setFound(true);
            state.setValue(found.getValue());
            if (node != found) {
                Node newNode = new Node(node.getKey(), node.getValue(), false, 4, null);
                this.replaceNode(head, found, newNode);
                if (parent == found) {
                    parent = newNode;
                }
            }
            Node node10 = parent;
            Intrinsics.checkNotNull(node10);
            node10.getChild()[parent.getChild()[1] == node ? 1 : 0] = node.getChild()[node.getChild()[0] == null ? 1 : 0];
            int n = this.size();
            this.setSize(n + -1);
        }
        this.root = head.getChild()[1];
        if (this.root != null) {
            Node<K, V> node11 = this.root;
            Intrinsics.checkNotNull(node11);
            node11.setRed(false);
        }
        return state.getFound();
    }

    /*
     * Unable to fully structure code
     */
    private final void replaceNode(Node<K, V> head, Node<K, V> node, Node<K, V> newNode) {
        parent = head;
        if (parent.getKey() == null) ** GOTO lbl-1000
        v0 = this.cmp;
        Intrinsics.checkNotNull(v0);
        if (v0.compare(node.getKey(), parent.getKey()) > 0) lbl-1000:
        // 2 sources

        {
            v1 = 1;
        } else {
            v1 = direction = 0;
        }
        while (parent.getChild()[direction] != node) {
            Intrinsics.checkNotNull(parent.getChild()[direction]);
            this.assert(parent != null);
            v2 = this.cmp;
            Intrinsics.checkNotNull(v2);
            direction = v2.compare(node.getKey(), parent.getKey()) > 0 ? 1 : 0;
        }
        parent.getChild()[direction] = newNode;
        newNode.setRed(node.isRed());
        newNode.getChild()[0] = node.getChild()[0];
        newNode.getChild()[1] = node.getChild()[1];
        node.getChild()[0] = null;
        node.getChild()[1] = null;
    }

    private final void assert(boolean b) {
        if (!b) {
            String string = "Something went wrong";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
    }

    private final Node<K, V> rotateDouble(Node<K, V> tree, int rotateDirection) {
        int otherChildDir = TreeMap.Companion.otherChild(rotateDirection);
        Node<K, V> node = tree;
        Intrinsics.checkNotNull(node);
        node.getChild()[otherChildDir] = this.rotateSingle(tree.getChild()[otherChildDir], otherChildDir);
        return this.rotateSingle(tree, rotateDirection);
    }

    private final Node<K, V> rotateSingle(Node<K, V> tree, int rotateDirection) {
        int otherChildDir = TreeMap.Companion.otherChild(rotateDirection);
        Node<K, V> node = tree;
        Intrinsics.checkNotNull(node);
        Node<K, V> save = node.getChild()[otherChildDir];
        Node<K, V>[] nodeArray = tree.getChild();
        Node<K, V> node2 = save;
        Intrinsics.checkNotNull(node2);
        nodeArray[otherChildDir] = node2.getChild()[rotateDirection];
        save.getChild()[rotateDirection] = tree;
        tree.setRed(true);
        save.setRed(false);
        return save;
    }

    @JvmOverloads
    public TreeMap() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$Companion;", "", "<init>", "()V", "LEFT", "", "RIGHT", "otherChild", "child", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int otherChild(int child) {
            return 1 - child;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010'\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010+\n\u0000\n\u0002\u0010&\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00020\u0001B?\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0010\u001a\u00020\u0007H\u0096\u0082\u0004J\u0016\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u0096\u0080\u0004R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$DescendingEntryIterator;", "", "", "type", "Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "fromKey", "fromInclusive", "", "toKey", "toInclusive", "<init>", "(Lorg/locationtech/jts/legacy/map/TreeMap;Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;Ljava/lang/Comparable;ZLjava/lang/Comparable;Z)V", "iter", "", "last", "", "hasNext", "next", "remove", "", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nTreeMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeMap.kt\norg/locationtech/jts/legacy/map/TreeMap$DescendingEntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,995:1\n1#2:996\n*E\n"})
    private final class DescendingEntryIterator
    implements Iterator<Map.Entry<K, V>>,
    KMutableIterator {
        @NotNull
        private final ListIterator<Map.Entry<K, V>> iter;
        @Nullable
        private Map.Entry<? extends K, ? extends V> last;
        final /* synthetic */ TreeMap<K, V> this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        @JvmOverloads
        public DescendingEntryIterator(@Nullable SubMapType type, K fromKey, @Nullable boolean fromInclusive, K toKey, boolean toInclusive) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.this$0 = (TreeMap)this$0;
            List list = new ArrayList();
            this.this$0.inOrderAdd(list, type, this.this$0.root, fromKey, fromInclusive, toKey, toInclusive);
            this.iter = list.listIterator(list.size());
        }

        public /* synthetic */ DescendingEntryIterator(TreeMap treeMap, SubMapType subMapType, Comparable comparable, boolean bl, Comparable comparable2, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                subMapType = SubMapType.All;
            }
            if ((n & 2) != 0) {
                comparable = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                comparable2 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            this(treeMap, subMapType, comparable, bl, comparable2, bl2);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasPrevious();
        }

        @Override
        @NotNull
        public Map.Entry<K, V> next() {
            Map.Entry entry;
            Map.Entry it = entry = this.iter.previous();
            boolean bl = false;
            this.last = it;
            return entry;
        }

        @Override
        public void remove() {
            this.iter.remove();
            Map.Entry entry = this.last;
            Intrinsics.checkNotNull(entry);
            this.this$0.removeEntry(entry);
            this.last = null;
        }

        @JvmOverloads
        public DescendingEntryIterator(@Nullable SubMapType type, K fromKey, @Nullable boolean fromInclusive, K toKey) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this(this$0, type, (Comparable)fromKey, fromInclusive, (Comparable)toKey, false, 16, null);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        @JvmOverloads
        public DescendingEntryIterator(@Nullable SubMapType type, K fromKey, boolean fromInclusive) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this((TreeMap)this$0, type, (Comparable)fromKey, fromInclusive, null, false, 24, null);
        }

        @JvmOverloads
        public DescendingEntryIterator(@Nullable SubMapType type, K fromKey) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this(this$0, type, (Comparable)fromKey, false, null, false, 28, null);
        }

        @JvmOverloads
        public DescendingEntryIterator(@NotNull TreeMap this$0, SubMapType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this(this$0, type, null, false, null, false, 30, null);
        }

        @JvmOverloads
        public DescendingEntryIterator(TreeMap this$0) {
            this(this$0, null, null, false, null, false, 31, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010'\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010+\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00020\u0001B?\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u000f\u001a\u00020\u0007H\u0096\u0082\u0004J\u0016\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$EntryIterator;", "", "", "type", "Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "fromKey", "fromInclusive", "", "toKey", "toInclusive", "<init>", "(Lorg/locationtech/jts/legacy/map/TreeMap;Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;Ljava/lang/Comparable;ZLjava/lang/Comparable;Z)V", "iter", "", "last", "hasNext", "next", "remove", "", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nTreeMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeMap.kt\norg/locationtech/jts/legacy/map/TreeMap$EntryIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,995:1\n1#2:996\n*E\n"})
    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>>,
    KMutableIterator {
        @NotNull
        private final ListIterator<Map.Entry<K, V>> iter;
        @Nullable
        private Map.Entry<K, V> last;
        final /* synthetic */ TreeMap<K, V> this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        @JvmOverloads
        public EntryIterator(@Nullable SubMapType type, K fromKey, @Nullable boolean fromInclusive, K toKey, boolean toInclusive) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.this$0 = (TreeMap)this$0;
            List list = new ArrayList();
            this.this$0.inOrderAdd(list, type, this.this$0.root, fromKey, fromInclusive, toKey, toInclusive);
            this.iter = list.listIterator();
        }

        public /* synthetic */ EntryIterator(TreeMap treeMap, SubMapType subMapType, Comparable comparable, boolean bl, Comparable comparable2, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                subMapType = SubMapType.All;
            }
            if ((n & 2) != 0) {
                comparable = null;
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                comparable2 = null;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            this(treeMap, subMapType, comparable, bl, comparable2, bl2);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        @NotNull
        public Map.Entry<K, V> next() {
            Map.Entry entry;
            Map.Entry it = entry = this.iter.next();
            boolean bl = false;
            this.last = it;
            return entry;
        }

        @Override
        public void remove() {
            this.iter.remove();
            Map.Entry entry = this.last;
            Intrinsics.checkNotNull(entry);
            this.this$0.removeEntry(entry);
            this.last = null;
        }

        @JvmOverloads
        public EntryIterator(@Nullable SubMapType type, K fromKey, @Nullable boolean fromInclusive, K toKey) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this(this$0, type, (Comparable)fromKey, fromInclusive, (Comparable)toKey, false, 16, null);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        @JvmOverloads
        public EntryIterator(@Nullable SubMapType type, K fromKey, boolean fromInclusive) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this((TreeMap)this$0, type, (Comparable)fromKey, fromInclusive, null, false, 24, null);
        }

        @JvmOverloads
        public EntryIterator(@Nullable SubMapType type, K fromKey) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this(this$0, type, (Comparable)fromKey, false, null, false, 28, null);
        }

        @JvmOverloads
        public EntryIterator(@NotNull TreeMap this$0, SubMapType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this(this$0, type, null, false, null, false, 30, null);
        }

        @JvmOverloads
        public EntryIterator(TreeMap this$0) {
            this(this$0, null, null, false, null, false, 31, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u0012\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u0003B'\b\u0007\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\n\"\u0004\b\u000b\u0010\fR'\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u00000\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$Node;", "K", "V", "Lorg/locationtech/jts/legacy/map/AbstractNavigableMap$SimpleEntry;", "key", "value", "isRed", "", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Z)V", "()Z", "setRed", "(Z)V", "child", "", "getChild", "()[Lorg/locationtech/jts/legacy/map/TreeMap$Node;", "[Lorg/locationtech/jts/legacy/map/TreeMap$Node;", "kts-core"})
    private static final class Node<K, V>
    extends AbstractNavigableMap.SimpleEntry<K, V> {
        private boolean isRed;
        @NotNull
        private final Node<K, V>[] child;

        @JvmOverloads
        public Node(@Nullable K key, @Nullable V value, boolean isRed) {
            super(key, value);
            this.isRed = isRed;
            this.child = new Node[2];
        }

        public /* synthetic */ Node(Object object, Object object2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(object, object2, bl);
        }

        public final boolean isRed() {
            return this.isRed;
        }

        public final void setRed(boolean bl) {
            this.isRed = bl;
        }

        @NotNull
        public final Node<K, V>[] getChild() {
            return this.child;
        }

        @JvmOverloads
        public Node(@Nullable K key, @Nullable V value) {
            this(key, value, false, 4, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u0096\u0080\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001e\u0010\u0011\u001a\u0004\u0018\u00018\u0002X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$State;", "V", "", "<init>", "()V", "done", "", "getDone", "()Z", "setDone", "(Z)V", "found", "getFound", "setFound", "matchValue", "getMatchValue", "setMatchValue", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "toString", "", "kts-core"})
    private static final class State<V> {
        private boolean done;
        private boolean found;
        private boolean matchValue;
        @Nullable
        private V value;

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = bl;
        }

        public final boolean getFound() {
            return this.found;
        }

        public final void setFound(boolean bl) {
            this.found = bl;
        }

        public final boolean getMatchValue() {
            return this.matchValue;
        }

        public final void setMatchValue(boolean bl) {
            this.matchValue = bl;
        }

        @Nullable
        public final V getValue() {
            return this.value;
        }

        public final void setValue(@Nullable V v) {
            this.value = v;
        }

        @NotNull
        public String toString() {
            return "State: mv=" + this.matchValue + " value=" + this.value + " done=" + this.done + " found=" + this.found;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\b\f\n\u0002\u0010)\n\u0002\u0010'\n\u0002\b\u000f\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\f\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\rj\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\u000eH\u0016J)\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0001H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u0018J9\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010$\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010(J)\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010,0+H\u0016J\u001a\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010,0+H\u0016J#\u0010.\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001eJ\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001eJ#\u00102\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J#\u00103\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J#\u00104\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J#\u00105\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001e2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010/J\u001c\u00106\u001a\u00020\u00062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eH\u0016J,\u00108\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001e2\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001eH\u0002J\u0015\u00109\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R \u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006;"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$SubMap;", "Lorg/locationtech/jts/legacy/map/AbstractNavigableMap;", "type", "Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "fromKey", "fromInclusive", "", "toKey", "toInclusive", "<init>", "(Lorg/locationtech/jts/legacy/map/TreeMap;Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;Ljava/lang/Comparable;ZLjava/lang/Comparable;Z)V", "Ljava/lang/Comparable;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "headMap", "Lorg/locationtech/jts/legacy/map/NavigableMap;", "(Ljava/lang/Comparable;Z)Lorg/locationtech/jts/legacy/map/NavigableMap;", "put", "key", "value", "(Ljava/lang/Comparable;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "k", "(Ljava/lang/Comparable;)Ljava/lang/Object;", "size", "", "getSize", "()I", "firstEntryField", "", "getFirstEntryField", "()Ljava/util/Map$Entry;", "lastEntryField", "getLastEntryField", "subMap", "newFromKey", "newFromInclusive", "newToKey", "newToInclusive", "(Ljava/lang/Comparable;ZLjava/lang/Comparable;Z)Lorg/locationtech/jts/legacy/map/NavigableMap;", "tailMap", "descendingEntryIterator", "", "", "entryIterator", "getEntry", "(Ljava/lang/Comparable;)Ljava/util/Map$Entry;", "getFirstEntry", "getLastEntry", "getCeilingEntry", "getFloorEntry", "getHigherEntry", "getLowerEntry", "removeEntry", "entry", "guardInRange", "inRange", "(Ljava/lang/Comparable;)Z", "kts-core"})
    private final class SubMap
    extends AbstractNavigableMap<K, V> {
        private final boolean fromInclusive;
        @Nullable
        private final K fromKey;
        private final boolean toInclusive;
        @Nullable
        private final K toKey;
        @NotNull
        private final SubMapType type;
        final /* synthetic */ TreeMap<K, V> this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public SubMap(@Nullable SubMapType type, K fromKey, @Nullable boolean fromInclusive, K toKey, boolean toInclusive) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.this$0 = (TreeMap)this$0;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Comparator comparator = this.this$0.cmp;
                    Intrinsics.checkNotNull((Object)comparator);
                    if (comparator.compare(toKey, fromKey) >= 0) break;
                    throw new IllegalArgumentException("subMap: " + toKey + " less than " + fromKey);
                }
                case 2: {
                    Comparator comparator = this.this$0.cmp;
                    Intrinsics.checkNotNull((Object)comparator);
                    comparator.compare(toKey, toKey);
                    break;
                }
                case 3: {
                    Comparator comparator = this.this$0.cmp;
                    Intrinsics.checkNotNull((Object)comparator);
                    comparator.compare(fromKey, fromKey);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.type = type;
            this.fromKey = fromKey;
            this.fromInclusive = fromInclusive;
            this.toKey = toKey;
            this.toInclusive = toInclusive;
        }

        @Override
        @NotNull
        public Comparator<? super K> comparator() {
            return this.this$0.comparator();
        }

        @Override
        @NotNull
        public NavigableMap<K, V> headMap(@NotNull K toKey, boolean toInclusive) {
            NavigableMap navigableMap;
            Intrinsics.checkNotNullParameter(toKey, (String)"toKey");
            if (this.type.toKeyValid()) {
                Comparator comparator = this.this$0.cmp;
                Intrinsics.checkNotNull((Object)comparator);
                if (comparator.compare(toKey, this.toKey) > 0) {
                    throw new IllegalArgumentException("subMap: " + toKey + " greater than " + this.toKey);
                }
            }
            if (this.type.fromKeyValid()) {
                Object k = this.fromKey;
                Intrinsics.checkNotNull(k);
                navigableMap = this.this$0.subMap(k, this.fromInclusive, toKey, toInclusive);
            } else {
                navigableMap = this.this$0.headMap(toKey, toInclusive);
            }
            return navigableMap;
        }

        @Override
        @Nullable
        public V put(@NotNull K key, V value) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            if (!this.inRange(key)) {
                throw new IllegalArgumentException(key + " outside the range " + this.fromKey + " to " + this.toKey);
            }
            return this.this$0.put(key, value);
        }

        @Override
        @Nullable
        public V remove(@NotNull K k) {
            Intrinsics.checkNotNullParameter(k, (String)"k");
            return !this.inRange(k) ? null : (Object)this.this$0.remove(k);
        }

        public int getSize() {
            if (this.getFirstEntry() == null) {
                return 0;
            }
            int count = 0;
            Iterator it = this.entryIterator();
            while (it.hasNext()) {
                ++count;
                it.next();
            }
            return count;
        }

        @Override
        @NotNull
        public Map.Entry<K, V> getFirstEntryField() {
            Map.Entry entry = this.firstEntry();
            Intrinsics.checkNotNull(entry);
            return entry;
        }

        @Override
        @NotNull
        public Map.Entry<K, V> getLastEntryField() {
            Map.Entry entry = this.lastEntry();
            Intrinsics.checkNotNull(entry);
            return entry;
        }

        @Override
        @NotNull
        public NavigableMap<K, V> subMap(@NotNull K newFromKey, boolean newFromInclusive, @NotNull K newToKey, boolean newToInclusive) {
            Intrinsics.checkNotNullParameter(newFromKey, (String)"newFromKey");
            Intrinsics.checkNotNullParameter(newToKey, (String)"newToKey");
            if (this.type.fromKeyValid()) {
                Comparator comparator = this.this$0.cmp;
                Intrinsics.checkNotNull((Object)comparator);
                if (comparator.compare(newFromKey, this.fromKey) < 0) {
                    throw new IllegalArgumentException("subMap: " + newFromKey + " less than " + this.fromKey);
                }
            }
            if (this.type.toKeyValid()) {
                Comparator comparator = this.this$0.cmp;
                Intrinsics.checkNotNull((Object)comparator);
                if (comparator.compare(newToKey, this.toKey) > 0) {
                    throw new IllegalArgumentException("subMap: " + newToKey + " greater than " + this.toKey);
                }
            }
            return this.this$0.subMap(newFromKey, newFromInclusive, newToKey, newToInclusive);
        }

        @Override
        @NotNull
        public NavigableMap<K, V> tailMap(@NotNull K fromKey, boolean fromInclusive) {
            NavigableMap navigableMap;
            Intrinsics.checkNotNullParameter(fromKey, (String)"fromKey");
            if (this.type.fromKeyValid()) {
                Comparator comparator = this.this$0.cmp;
                Intrinsics.checkNotNull((Object)comparator);
                if (comparator.compare(fromKey, this.fromKey) < 0) {
                    throw new IllegalArgumentException("subMap: " + fromKey + " less than " + this.fromKey);
                }
            }
            if (this.type.toKeyValid()) {
                Object k = this.toKey;
                Intrinsics.checkNotNull(k);
                navigableMap = this.this$0.subMap(fromKey, fromInclusive, k, this.toInclusive);
            } else {
                navigableMap = this.this$0.tailMap(fromKey, fromInclusive);
            }
            return navigableMap;
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> descendingEntryIterator() {
            return new DescendingEntryIterator(this.this$0, this.type, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> entryIterator() {
            return new EntryIterator(this.this$0, this.type, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Override
        @Nullable
        public Map.Entry<K, V> getEntry(@NotNull K key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return this.guardInRange(this.this$0.getEntry(key));
        }

        @Nullable
        public final Map.Entry<K, V> getFirstEntry() {
            Map.Entry entry;
            if (this.type.fromKeyValid()) {
                if (this.fromInclusive) {
                    Object k = this.fromKey;
                    Intrinsics.checkNotNull(k);
                    Map.Entry entry2 = this.this$0.getCeilingEntry(k);
                    entry = entry2;
                    Intrinsics.checkNotNull(entry2);
                } else {
                    Object k = this.fromKey;
                    Intrinsics.checkNotNull(k);
                    Map.Entry entry3 = this.this$0.getHigherEntry(k);
                    entry = entry3;
                    Intrinsics.checkNotNull(entry3);
                }
            } else {
                Map.Entry entry4 = this.this$0.firstEntry();
                entry = entry4;
                Intrinsics.checkNotNull(entry4);
            }
            Map.Entry entry5 = entry;
            return this.guardInRange(entry5);
        }

        @Nullable
        public final Map.Entry<K, V> getLastEntry() {
            Map.Entry entry;
            if (this.type.toKeyValid()) {
                if (this.toInclusive) {
                    Object k = this.toKey;
                    Intrinsics.checkNotNull(k);
                    entry = this.this$0.getFloorEntry(k);
                } else {
                    Object k = this.toKey;
                    Intrinsics.checkNotNull(k);
                    entry = this.this$0.getLowerEntry(k);
                }
            } else {
                entry = this.this$0.lastEntry();
            }
            Map.Entry entry2 = entry;
            return this.guardInRange(entry2);
        }

        @Override
        @Nullable
        public Map.Entry<K, V> getCeilingEntry(@NotNull K key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return this.guardInRange(this.this$0.getCeilingEntry(key));
        }

        @Override
        @Nullable
        public Map.Entry<K, V> getFloorEntry(@NotNull K key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return this.guardInRange(this.this$0.getFloorEntry(key));
        }

        @Override
        @Nullable
        public Map.Entry<K, V> getHigherEntry(@NotNull K key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return this.guardInRange(this.this$0.getHigherEntry(key));
        }

        @Override
        @Nullable
        public Map.Entry<K, V> getLowerEntry(@NotNull K key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return this.guardInRange(this.this$0.getLowerEntry(key));
        }

        @Override
        public boolean removeEntry(@NotNull Map.Entry<? extends K, ? extends V> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            return this.inRange((Comparable)entry.getKey()) && this.this$0.removeEntry(entry);
        }

        private final Map.Entry<K, V> guardInRange(Map.Entry<? extends K, ? extends V> entry) {
            return entry != null && this.inRange((Comparable)entry.getKey()) ? entry : null;
        }

        private final boolean inRange(K key) {
            return this.this$0.inRange(this.type, key, this.fromKey, this.fromInclusive, this.toKey, this.toInclusive);
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SubMapType.values().length];
                try {
                    nArray[SubMapType.Range.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SubMapType.Head.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SubMapType.Tail.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SubMapType.All.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "", "<init>", "(Ljava/lang/String;I)V", "All", "Head", "Range", "Tail", "fromKeyValid", "", "toKeyValid", "kts-core"})
    private static final class SubMapType
    extends Enum<SubMapType> {
        public static final /* enum */ SubMapType All = new SubMapType();
        public static final /* enum */ SubMapType Head = new Head("Head", 1);
        public static final /* enum */ SubMapType Range = new Range("Range", 2);
        public static final /* enum */ SubMapType Tail = new Tail("Tail", 3);
        private static final /* synthetic */ SubMapType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SubMapType() {
        }

        public boolean fromKeyValid() {
            return false;
        }

        public boolean toKeyValid() {
            return false;
        }

        public static SubMapType[] values() {
            return (SubMapType[])$VALUES.clone();
        }

        public static SubMapType valueOf(String value) {
            return Enum.valueOf(SubMapType.class, value);
        }

        @NotNull
        public static EnumEntries<SubMapType> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ SubMapType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = subMapTypeArray = new SubMapType[]{SubMapType.All, SubMapType.Head, SubMapType.Range, SubMapType.Tail};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"org/locationtech/jts/legacy/map/TreeMap.SubMapType.Head", "Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "toKeyValid", "", "kts-core"})
        static final class Head
        extends SubMapType {
            /*
             * WARNING - void declaration
             */
            Head() {
                void var1_1;
            }

            @Override
            public boolean toKeyValid() {
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"org/locationtech/jts/legacy/map/TreeMap.SubMapType.Range", "Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "fromKeyValid", "", "toKeyValid", "kts-core"})
        static final class Range
        extends SubMapType {
            /*
             * WARNING - void declaration
             */
            Range() {
                void var1_1;
            }

            @Override
            public boolean fromKeyValid() {
                return true;
            }

            @Override
            public boolean toKeyValid() {
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"org/locationtech/jts/legacy/map/TreeMap.SubMapType.Tail", "Lorg/locationtech/jts/legacy/map/TreeMap$SubMapType;", "fromKeyValid", "", "kts-core"})
        static final class Tail
        extends SubMapType {
            /*
             * WARNING - void declaration
             */
            Tail() {
                void var1_1;
            }

            @Override
            public boolean fromKeyValid() {
                return true;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00120\u0003R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u00020\bH\u0096\u0080\u0004\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/legacy/map/TreeMap$TEntrySet;", "K", "V", "Lorg/locationtech/jts/legacy/map/AbstractNavigableMap$EntrySet;", "Lorg/locationtech/jts/legacy/map/AbstractNavigableMap;", "<init>", "(Lorg/locationtech/jts/legacy/map/TreeMap;)V", "clear", "", "kts-core"})
    private final class TEntrySet<K, V>
    extends AbstractNavigableMap.EntrySet {
        public void clear() {
            TreeMap.this.clear();
        }
    }
}

