/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\u0014\u001a\u00020\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/noding/IteratedNoder;", "Lorg/locationtech/jts/noding/Noder;", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "value", "", "Lorg/locationtech/jts/noding/SegmentString;", "nodedSubstrings", "getNodedSubstrings", "()Ljava/util/Collection;", "maxIter", "", "setMaximumIterations", "", "computeNodes", "segStrings", "node", "numInteriorIntersections", "", "Companion", "kts-core"})
public final class IteratedNoder
implements Noder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel pm;
    @NotNull
    private final LineIntersector li;
    @Nullable
    private Collection<? extends SegmentString> nodedSubstrings;
    private int maxIter;
    public static final int MAX_ITER = 5;

    public IteratedNoder(@NotNull PrecisionModel pm) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        this.maxIter = 5;
        this.li = new RobustLineIntersector();
        this.pm = pm;
        this.li.setPrecisionModel(pm);
    }

    @Override
    @Nullable
    public Collection<SegmentString> getNodedSubstrings() {
        return this.nodedSubstrings;
    }

    public final void setMaximumIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> segStrings) {
        int nodesCreated;
        Intrinsics.checkNotNullParameter(segStrings, (String)"segStrings");
        int[] numInteriorIntersections = new int[1];
        this.nodedSubstrings = segStrings;
        int nodingIterationCount = 0;
        int lastNodesCreated = -1;
        do {
            this.node(this.getNodedSubstrings(), numInteriorIntersections);
            nodesCreated = numInteriorIntersections[0];
            boolean bl = 1 <= lastNodesCreated ? lastNodesCreated <= nodesCreated : false;
            if (!bl || ++nodingIterationCount <= this.maxIter) continue;
            throw new TopologyException("Iterated noding failed to converge after " + nodingIterationCount + " iterations");
        } while ((lastNodesCreated = nodesCreated) > 0);
    }

    private final void node(Collection<? extends SegmentString> segStrings, int[] numInteriorIntersections) {
        IntersectionAdder si = new IntersectionAdder(this.li);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(si);
        Collection<? extends SegmentString> collection = segStrings;
        Intrinsics.checkNotNull(collection);
        noder.computeNodes(collection);
        this.nodedSubstrings = noder.getNodedSubstrings();
        numInteriorIntersections[0] = si.getNumInteriorIntersections();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/noding/IteratedNoder$Companion;", "", "<init>", "()V", "MAX_ITER", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

