/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.noding.NodableSegmentString;
import org.locationtech.jts.noding.Octant;
import org.locationtech.jts.noding.SegmentNode;
import org.locationtech.jts.noding.SegmentNodeList;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B!\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0011\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aJ\u001c\u0010#\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aJ&\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001aJ\u0018\u0010,\u001a\u00020'2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u001aH\u0016J\u0016\u0010/\u001a\u0002002\u0006\u0010.\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u001aJ\n\u00101\u001a\u000202H\u0096\u0080\u0004R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003@RX\u0096\u000e\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u00064"}, d2={"Lorg/locationtech/jts/noding/NodedSegmentString;", "Lorg/locationtech/jts/noding/NodableSegmentString;", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "data", "", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/lang/Object;)V", "ss", "Lorg/locationtech/jts/noding/SegmentString;", "(Lorg/locationtech/jts/noding/SegmentString;)V", "nodeList", "Lorg/locationtech/jts/noding/SegmentNodeList;", "getNodeList", "()Lorg/locationtech/jts/noding/SegmentNodeList;", "value", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "size", "", "getCoordinate", "i", "getNodedCoordinates", "isClosed", "", "()Z", "getSegmentOctant", "index", "safeOctant", "p0", "p1", "addIntersections", "", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "segmentIndex", "geomIndex", "addIntersection", "intIndex", "intPt", "addIntersectionNode", "Lorg/locationtech/jts/noding/SegmentNode;", "toString", "", "Companion", "kts-core"})
public final class NodedSegmentString
implements NodableSegmentString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SegmentNodeList nodeList;
    @NotNull
    private Coordinate[] coordinates;
    @Nullable
    private Object data;

    @NotNull
    public final SegmentNodeList getNodeList() {
        return this.nodeList;
    }

    @Override
    @NotNull
    public Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    @Nullable
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(@Nullable Object object) {
        this.data = object;
    }

    public NodedSegmentString(@NotNull Coordinate[] pts, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.nodeList = new SegmentNodeList(this);
        this.coordinates = pts;
        this.setData(data);
    }

    public NodedSegmentString(@NotNull SegmentString ss) {
        Intrinsics.checkNotNullParameter((Object)ss, (String)"ss");
        this.nodeList = new SegmentNodeList(this);
        this.coordinates = ss.getCoordinates();
        this.setData(ss.getData());
    }

    @Override
    public int size() {
        return this.getCoordinates().length;
    }

    @Override
    @NotNull
    public Coordinate getCoordinate(int i) {
        return this.getCoordinates()[i];
    }

    @NotNull
    public final Coordinate[] getNodedCoordinates() {
        return this.nodeList.getSplitCoordinates();
    }

    @Override
    public boolean isClosed() {
        return Intrinsics.areEqual((Object)this.getCoordinates()[0], (Object)this.getCoordinates()[this.getCoordinates().length - 1]);
    }

    public final int getSegmentOctant(int index) {
        return index == this.getCoordinates().length - 1 ? -1 : this.safeOctant(this.getCoordinate(index), this.getCoordinate(index + 1));
    }

    private final int safeOctant(Coordinate p0, Coordinate p1) {
        Coordinate coordinate = p0;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p1;
        Intrinsics.checkNotNull((Object)coordinate2);
        return coordinate.equals2D(coordinate2) ? 0 : Octant.octant(p0, p1);
    }

    public final void addIntersections(@NotNull LineIntersector li, int segmentIndex, int geomIndex) {
        Intrinsics.checkNotNullParameter((Object)li, (String)"li");
        int n = li.getIntersectionNum();
        for (int i = 0; i < n; ++i) {
            this.addIntersection(li, segmentIndex, geomIndex, i);
        }
    }

    public final void addIntersection(@NotNull LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Intrinsics.checkNotNullParameter((Object)li, (String)"li");
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        this.addIntersection(intPt, segmentIndex);
    }

    @Override
    public void addIntersection(@NotNull Coordinate intPt, int segmentIndex) {
        Intrinsics.checkNotNullParameter((Object)intPt, (String)"intPt");
        this.addIntersectionNode(intPt, segmentIndex);
    }

    @NotNull
    public final SegmentNode addIntersectionNode(@NotNull Coordinate intPt, int segmentIndex) {
        Coordinate nextPt;
        Intrinsics.checkNotNullParameter((Object)intPt, (String)"intPt");
        int normalizedSegmentIndex = segmentIndex;
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.getCoordinates().length && intPt.equals2D(nextPt = this.getCoordinates()[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
        }
        return this.nodeList.add(intPt, normalizedSegmentIndex);
    }

    @NotNull
    public String toString() {
        return WKTWriter.Companion.toLineString(new CoordinateArraySequence(this.getCoordinates(), 0, 0, 6, null));
    }

    @JvmStatic
    @NotNull
    public static final List<SegmentString> getNodedSubstrings(@Nullable Collection<?> segStrings) {
        return Companion.getNodedSubstrings(segStrings);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0007J\"\u0010\u0004\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/noding/NodedSegmentString$Companion;", "", "<init>", "()V", "getNodedSubstrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "segStrings", "", "", "resultEdgelist", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<SegmentString> getNodedSubstrings(@Nullable Collection<?> segStrings) {
            List resultEdgelist = new ArrayList();
            this.getNodedSubstrings(segStrings, resultEdgelist);
            return resultEdgelist;
        }

        public final void getNodedSubstrings(@Nullable Collection<?> segStrings, @NotNull Collection<SegmentString> resultEdgelist) {
            Intrinsics.checkNotNullParameter(resultEdgelist, (String)"resultEdgelist");
            Collection<?> collection = segStrings;
            Intrinsics.checkNotNull(collection);
            for (Object obj : collection) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.NodedSegmentString");
                NodedSegmentString ss = (NodedSegmentString)obj;
                ss.getNodeList().addSplitEdges(resultEdgelist);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

