/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\tH\u0002J\u001e\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/noding/NodingValidator;", "", "segStrings", "", "<init>", "(Ljava/util/Collection;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "checkValid", "", "checkCollapses", "ss", "Lorg/locationtech/jts/noding/SegmentString;", "checkCollapse", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "checkInteriorIntersections", "ss0", "ss1", "e0", "segIndex0", "", "e1", "segIndex1", "hasInteriorIntersection", "", "checkEndPtVertexIntersections", "testPt", "Companion", "kts-core"})
public final class NodingValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<?> segStrings;
    @NotNull
    private final LineIntersector li;
    @NotNull
    private static final GeometryFactory fact = new GeometryFactory();

    public NodingValidator(@NotNull Collection<?> segStrings) {
        Intrinsics.checkNotNullParameter(segStrings, (String)"segStrings");
        this.segStrings = segStrings;
        this.li = new RobustLineIntersector();
    }

    public final void checkValid() {
        this.checkEndPtVertexIntersections();
        this.checkInteriorIntersections();
        this.checkCollapses();
    }

    private final void checkCollapses() {
        for (Object obj : this.segStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            SegmentString ss = (SegmentString)obj;
            this.checkCollapses(ss);
        }
    }

    private final void checkCollapses(SegmentString ss) {
        Coordinate[] pts = ss.getCoordinates();
        int n = pts.length - 2;
        for (int i = 0; i < n; ++i) {
            this.checkCollapse(pts[i], pts[i + 1], pts[i + 2]);
        }
    }

    private final void checkCollapse(Coordinate p0, Coordinate p1, Coordinate p2) {
        if (Intrinsics.areEqual((Object)p0, (Object)p2)) {
            Coordinate[] coordinateArray = new Coordinate[]{p0, p1, p2};
            throw new RuntimeException("found non-noded collapse at " + fact.createLineString(coordinateArray));
        }
    }

    private final void checkInteriorIntersections() {
        for (Object obj : this.segStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            SegmentString ss0 = (SegmentString)obj;
            for (Object obj2 : this.segStrings) {
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
                SegmentString ss1 = (SegmentString)obj2;
                this.checkInteriorIntersections(ss0, ss1);
            }
        }
    }

    private final void checkInteriorIntersections(SegmentString ss0, SegmentString ss1) {
        Coordinate[] pts0 = ss0.getCoordinates();
        Coordinate[] pts1 = ss1.getCoordinates();
        int n = pts0.length - 1;
        for (int i0 = 0; i0 < n; ++i0) {
            int n2 = pts1.length - 1;
            for (int i1 = 0; i1 < n2; ++i1) {
                this.checkInteriorIntersections(ss0, i0, ss1, i1);
            }
        }
    }

    private final void checkInteriorIntersections(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection() && (this.li.isProper() || this.hasInteriorIntersection(this.li, p00, p01) || this.hasInteriorIntersection(this.li, p10, p11))) {
            throw new RuntimeException("found non-noded intersection at " + p00 + "-" + p01 + " and " + p10 + "-" + p11);
        }
    }

    private final boolean hasInteriorIntersection(LineIntersector li, Coordinate p0, Coordinate p1) {
        int n = li.getIntersectionNum();
        for (int i = 0; i < n; ++i) {
            Coordinate intPt = li.getIntersection(i);
            if (Intrinsics.areEqual((Object)intPt, (Object)p0) || Intrinsics.areEqual((Object)intPt, (Object)p1)) continue;
            return true;
        }
        return false;
    }

    private final void checkEndPtVertexIntersections() {
        for (Object obj : this.segStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            SegmentString ss = (SegmentString)obj;
            Coordinate[] pts = ss.getCoordinates();
            this.checkEndPtVertexIntersections(pts[0], this.segStrings);
            this.checkEndPtVertexIntersections(pts[pts.length - 1], this.segStrings);
        }
    }

    private final void checkEndPtVertexIntersections(Coordinate testPt, Collection<?> segStrings) {
        for (Object obj : segStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            SegmentString ss = (SegmentString)obj;
            Coordinate[] pts = ss.getCoordinates();
            int n = pts.length - 1;
            for (int j = 1; j < n; ++j) {
                if (!Intrinsics.areEqual((Object)pts[j], (Object)testPt)) continue;
                throw new RuntimeException("found endpt/interior pt intersection at index " + j + " :pt " + testPt);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/noding/NodingValidator$Companion;", "", "<init>", "()V", "fact", "Lorg/locationtech/jts/geom/GeometryFactory;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

