/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/noding/SegmentPointComparator;", "", "<init>", "()V", "compare", "", "octant", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "relativeSign", "x0", "", "x1", "compareValue", "compareSign0", "compareSign1", "kts-core"})
public final class SegmentPointComparator {
    @NotNull
    public static final SegmentPointComparator INSTANCE = new SegmentPointComparator();

    private SegmentPointComparator() {
    }

    @JvmStatic
    public static final int compare(int octant, @NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        if (p0.equals2D(p1)) {
            return 0;
        }
        int xSign = INSTANCE.relativeSign(p0.x, p1.x);
        int ySign = INSTANCE.relativeSign(p0.y, p1.y);
        switch (octant) {
            case 0: {
                return INSTANCE.compareValue(xSign, ySign);
            }
            case 1: {
                return INSTANCE.compareValue(ySign, xSign);
            }
            case 2: {
                return INSTANCE.compareValue(ySign, -xSign);
            }
            case 3: {
                return INSTANCE.compareValue(-xSign, ySign);
            }
            case 4: {
                return INSTANCE.compareValue(-xSign, -ySign);
            }
            case 5: {
                return INSTANCE.compareValue(-ySign, -xSign);
            }
            case 6: {
                return INSTANCE.compareValue(-ySign, xSign);
            }
            case 7: {
                return INSTANCE.compareValue(xSign, -ySign);
            }
        }
        Assert.shouldNeverReachHere("invalid octant value");
        return 0;
    }

    public final int relativeSign(double x0, double x1) {
        if (x0 < x1) {
            return -1;
        }
        return x0 > x1 ? 1 : 0;
    }

    private final int compareValue(int compareSign0, int compareSign1) {
        if (compareSign0 < 0) {
            return -1;
        }
        if (compareSign0 > 0) {
            return 1;
        }
        if (compareSign1 < 0) {
            return -1;
        }
        return compareSign1 > 0 ? 1 : 0;
    }
}

