/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentSetMutualIntersector;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/noding/SimpleSegmentSetMutualIntersector;", "Lorg/locationtech/jts/noding/SegmentSetMutualIntersector;", "baseSegStrings", "", "<init>", "(Ljava/util/Collection;)V", "process", "", "segStrings", "segInt", "Lorg/locationtech/jts/noding/SegmentIntersector;", "intersect", "ss0", "Lorg/locationtech/jts/noding/SegmentString;", "ss1", "kts-core"})
public final class SimpleSegmentSetMutualIntersector
implements SegmentSetMutualIntersector {
    @NotNull
    private final Collection<?> baseSegStrings;

    public SimpleSegmentSetMutualIntersector(@NotNull Collection<?> baseSegStrings) {
        Intrinsics.checkNotNullParameter(baseSegStrings, (String)"baseSegStrings");
        this.baseSegStrings = baseSegStrings;
    }

    @Override
    public void process(@Nullable Collection<?> segStrings, @Nullable SegmentIntersector segInt) {
        for (Object obj : this.baseSegStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            SegmentString baseSS = (SegmentString)obj;
            Collection<?> collection = segStrings;
            Intrinsics.checkNotNull(collection);
            for (Object obj2 : collection) {
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
                SegmentString ss = (SegmentString)obj2;
                SegmentIntersector segmentIntersector = segInt;
                Intrinsics.checkNotNull((Object)segmentIntersector);
                this.intersect(baseSS, ss, segmentIntersector);
                if (!segInt.isDone()) continue;
                return;
            }
        }
    }

    private final void intersect(SegmentString ss0, SegmentString ss1, SegmentIntersector segInt) {
        Coordinate[] pts0 = ss0.getCoordinates();
        Coordinate[] pts1 = ss1.getCoordinates();
        int n = pts0.length - 1;
        for (int i0 = 0; i0 < n; ++i0) {
            int n2 = pts1.length - 1;
            for (int i1 = 0; i1 < n2; ++i1) {
                segInt.processIntersections(ss0, i0, ss1, i1);
                if (!segInt.isDone()) continue;
                return;
            }
        }
    }
}

