/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snap;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snap.SnappingPointIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J@\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/noding/snap/SnappingIntersectionAdder;", "Lorg/locationtech/jts/noding/SegmentIntersector;", "snapTolerance", "", "snapPointIndex", "Lorg/locationtech/jts/noding/snap/SnappingPointIndex;", "<init>", "(DLorg/locationtech/jts/noding/snap/SnappingPointIndex;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "processIntersections", "", "seg0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "", "seg1", "segIndex1", "processNearVertex", "srcSS", "srcIndex", "p", "Lorg/locationtech/jts/geom/Coordinate;", "ss", "segIndex", "p0", "p1", "isDone", "", "()Z", "Companion", "kts-core"})
public final class SnappingIntersectionAdder
implements SegmentIntersector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineIntersector li;
    private final double snapTolerance;
    @NotNull
    private final SnappingPointIndex snapPointIndex;

    public SnappingIntersectionAdder(double snapTolerance, @NotNull SnappingPointIndex snapPointIndex) {
        Intrinsics.checkNotNullParameter((Object)snapPointIndex, (String)"snapPointIndex");
        this.li = new RobustLineIntersector();
        this.snapPointIndex = snapPointIndex;
        this.snapTolerance = snapTolerance;
    }

    @Override
    public void processIntersections(@NotNull SegmentString seg0, int segIndex0, @NotNull SegmentString seg1, int segIndex1) {
        Intrinsics.checkNotNullParameter((Object)seg0, (String)"seg0");
        Intrinsics.checkNotNullParameter((Object)seg1, (String)"seg1");
        if (seg0 == seg1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = seg0.getCoordinate(segIndex0);
        Coordinate p01 = seg0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = seg1.getCoordinate(segIndex1);
        Coordinate p11 = seg1.getCoordinate(segIndex1 + 1);
        if (!SnappingIntersectionAdder.Companion.isAdjacent(seg0, segIndex0, seg1, segIndex1)) {
            this.li.computeIntersection(p00, p01, p10, p11);
            if (this.li.hasIntersection() && this.li.getIntersectionNum() == 1) {
                Coordinate intPt = this.li.getIntersection(0);
                Coordinate snapPt = this.snapPointIndex.snap(intPt);
                ((NodedSegmentString)seg0).addIntersection(snapPt, segIndex0);
                ((NodedSegmentString)seg1).addIntersection(snapPt, segIndex1);
            }
        }
        this.processNearVertex(seg0, segIndex0, p00, seg1, segIndex1, p10, p11);
        this.processNearVertex(seg0, segIndex0, p01, seg1, segIndex1, p10, p11);
        this.processNearVertex(seg1, segIndex1, p10, seg0, segIndex0, p00, p01);
        this.processNearVertex(seg1, segIndex1, p11, seg0, segIndex0, p00, p01);
    }

    private final void processNearVertex(SegmentString srcSS, int srcIndex, Coordinate p, SegmentString ss, int segIndex, Coordinate p0, Coordinate p1) {
        if (p.distance(p0) < this.snapTolerance) {
            return;
        }
        if (p.distance(p1) < this.snapTolerance) {
            return;
        }
        double distSeg = Distance.pointToSegment(p, p0, p1);
        if (distSeg < this.snapTolerance) {
            Intrinsics.checkNotNull((Object)ss, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.NodedSegmentString");
            ((NodedSegmentString)ss).addIntersection(p, segIndex);
            Intrinsics.checkNotNull((Object)srcSS, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.NodedSegmentString");
            ((NodedSegmentString)srcSS).addIntersection(p, srcIndex);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/noding/snap/SnappingIntersectionAdder$Companion;", "", "<init>", "()V", "isAdjacent", "", "ss0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "", "ss1", "segIndex1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAdjacent(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
            boolean isAdjacent;
            if (ss0 != ss1) {
                return false;
            }
            boolean bl = isAdjacent = Math.INSTANCE.abs(segIndex0 - segIndex1) == 1;
            if (isAdjacent) {
                return true;
            }
            if (ss0.isClosed()) {
                int maxSegIndex = ss0.size() - 1;
                if ((segIndex0 == 0 && segIndex1 == maxSegIndex || segIndex1 == 0) && segIndex0 == maxSegIndex) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

