/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \"2\u00020\u0001:\u0001\"B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0002\u0010\fJ\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\u001f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010!\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferParameters;", "", "<init>", "()V", "quadrantSegments", "", "(I)V", "endCapStyle", "(II)V", "joinStyle", "mitreLimit", "", "(IIID)V", "isSingleSided", "", "()Z", "setSingleSided", "(Z)V", "simplifyFactor", "getSimplifyFactor", "()D", "setSimplifyFactor", "(D)V", "getQuadrantSegments", "setQuadrantSegments", "", "quadSegs", "getEndCapStyle", "setEndCapStyle", "getJoinStyle", "setJoinStyle", "getMitreLimit", "setMitreLimit", "copy", "Companion", "kts-core"})
public final class BufferParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int quadrantSegments = 8;
    private int endCapStyle = 1;
    private int joinStyle = 1;
    private double mitreLimit = 5.0;
    private boolean isSingleSided;
    private double simplifyFactor = 0.01;
    public static final int CAP_ROUND = 1;
    public static final int CAP_FLAT = 2;
    public static final int CAP_SQUARE = 3;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_MITRE = 2;
    public static final int JOIN_BEVEL = 3;
    public static final int DEFAULT_QUADRANT_SEGMENTS = 8;
    public static final double DEFAULT_MITRE_LIMIT = 5.0;
    public static final double DEFAULT_SIMPLIFY_FACTOR = 0.01;

    public final boolean isSingleSided() {
        return this.isSingleSided;
    }

    public final void setSingleSided(boolean bl) {
        this.isSingleSided = bl;
    }

    public final double getSimplifyFactor() {
        return this.simplifyFactor;
    }

    public final void setSimplifyFactor(double simplifyFactor) {
        this.simplifyFactor = simplifyFactor < 0.0 ? 0.0 : simplifyFactor;
    }

    public BufferParameters() {
    }

    public BufferParameters(int quadrantSegments) {
        this.setQuadrantSegments(quadrantSegments);
    }

    public BufferParameters(int quadrantSegments, int endCapStyle) {
        this.setQuadrantSegments(quadrantSegments);
        this.setEndCapStyle(endCapStyle);
    }

    public BufferParameters(int quadrantSegments, int endCapStyle, int joinStyle, double mitreLimit) {
        this.setQuadrantSegments(quadrantSegments);
        this.setEndCapStyle(endCapStyle);
        this.setJoinStyle(joinStyle);
        this.setMitreLimit(mitreLimit);
    }

    public final int getQuadrantSegments() {
        return this.quadrantSegments;
    }

    public final void setQuadrantSegments(int quadSegs) {
        this.quadrantSegments = quadSegs;
    }

    public final int getEndCapStyle() {
        return this.endCapStyle;
    }

    public final void setEndCapStyle(int endCapStyle) {
        this.endCapStyle = endCapStyle;
    }

    public final int getJoinStyle() {
        return this.joinStyle;
    }

    public final void setJoinStyle(int joinStyle) {
        this.joinStyle = joinStyle;
    }

    public final double getMitreLimit() {
        return this.mitreLimit;
    }

    public final void setMitreLimit(double mitreLimit) {
        this.mitreLimit = mitreLimit;
    }

    @NotNull
    public final BufferParameters copy() {
        BufferParameters bp = new BufferParameters();
        bp.quadrantSegments = this.quadrantSegments;
        bp.endCapStyle = this.endCapStyle;
        bp.joinStyle = this.joinStyle;
        bp.mitreLimit = this.mitreLimit;
        return bp;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferParameters$Companion;", "", "<init>", "()V", "CAP_ROUND", "", "CAP_FLAT", "CAP_SQUARE", "JOIN_ROUND", "JOIN_MITRE", "JOIN_BEVEL", "DEFAULT_QUADRANT_SEGMENTS", "DEFAULT_MITRE_LIMIT", "", "DEFAULT_SIMPLIFY_FACTOR", "bufferDistanceError", "quadSegs", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double bufferDistanceError(int quadSegs) {
            double alpha = 1.5707963267948966 / (double)quadSegs;
            return 1.0 - Math.INSTANCE.cos(alpha / 2.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

