/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance3d;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.CGAlgorithms3D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.distance.GeometryLocation;
import org.locationtech.jts.operation.distance3d.PlanarPolygon3D;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 <2\u00020\u0001:\u0001<B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0006J\u0013\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\f\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0019J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J \u0010$\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\"\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J \u0010 \u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J \u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J \u0010+\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\"\u0010-\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u001c\u00100\u001a\u0004\u0018\u00010\u00162\u0006\u0010%\u001a\u00020&2\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J \u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\"\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020/2\b\u00107\u001a\u0004\u0018\u00010/2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J \u00108\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u00103\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J \u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u0002042\u0006\u0010;\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\u0013H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/locationtech/jts/operation/distance3d/Distance3DOp;", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "terminateDistance", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;D)V", "getTerminateDistance", "()D", "geom", "", "[Lorg/locationtech/jts/geom/Geometry;", "minDistanceLocation", "Lorg/locationtech/jts/operation/distance/GeometryLocation;", "[Lorg/locationtech/jts/operation/distance/GeometryLocation;", "minDistance", "isDone", "", "distance", "nearestPoints", "Lorg/locationtech/jts/geom/Coordinate;", "()[Lorg/locationtech/jts/geom/Coordinate;", "nearestLocations", "()[Lorg/locationtech/jts/operation/distance/GeometryLocation;", "updateDistance", "", "dist", "loc0", "loc1", "flip", "computeMinDistance", "mostPolygonalIndex", "", "computeMinDistanceMultiMulti", "computeMinDistanceOneMulti", "poly", "Lorg/locationtech/jts/operation/distance3d/PlanarPolygon3D;", "computeMinDistancePolygonPolygon", "poly0", "poly1", "Lorg/locationtech/jts/geom/Polygon;", "computeMinDistancePolygonRings", "ringPoly", "computeMinDistancePolygonLine", "line", "Lorg/locationtech/jts/geom/LineString;", "intersection", "computeMinDistancePolygonPoint", "polyPlane", "point", "Lorg/locationtech/jts/geom/Point;", "computeMinDistanceLineLine", "line0", "line1", "computeMinDistanceLinePoint", "computeMinDistancePointPoint", "point0", "point1", "Companion", "kts-core"})
public final class Distance3DOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double terminateDistance;
    @NotNull
    private final Geometry[] geom;
    @Nullable
    private GeometryLocation[] minDistanceLocation;
    private double minDistance;
    private boolean isDone;

    @JvmOverloads
    public Distance3DOp(@NotNull Geometry g0, @NotNull Geometry g1, double terminateDistance) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this.terminateDistance = terminateDistance;
        this.minDistance = Double.MAX_VALUE;
        Geometry[] geometryArray = new Geometry[]{g0, g1};
        this.geom = geometryArray;
    }

    public /* synthetic */ Distance3DOp(Geometry geometry, Geometry geometry2, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 0.0;
        }
        this(geometry, geometry2, d);
    }

    public final double getTerminateDistance() {
        return this.terminateDistance;
    }

    public final double distance() {
        if (this.geom[0] == null || this.geom[1] == null) {
            throw new IllegalArgumentException("null geometries are not supported");
        }
        if (this.geom[0].isEmpty() || this.geom[1].isEmpty()) {
            return 0.0;
        }
        this.computeMinDistance();
        return this.minDistance;
    }

    @NotNull
    public final Coordinate[] nearestPoints() {
        this.computeMinDistance();
        Coordinate[] coordinateArray = new Coordinate[2];
        Intrinsics.checkNotNull((Object)this.minDistanceLocation);
        GeometryLocation geometryLocation = this.minDistanceLocation[0];
        Intrinsics.checkNotNull((Object)geometryLocation);
        coordinateArray[0] = geometryLocation.getCoordinate();
        Intrinsics.checkNotNull((Object)this.minDistanceLocation);
        GeometryLocation geometryLocation2 = this.minDistanceLocation[1];
        Intrinsics.checkNotNull((Object)geometryLocation2);
        coordinateArray[1] = geometryLocation2.getCoordinate();
        return coordinateArray;
    }

    @Nullable
    public final GeometryLocation[] nearestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    private final void updateDistance(double dist, GeometryLocation loc0, GeometryLocation loc1, boolean flip) {
        this.minDistance = dist;
        int index = flip ? 1 : 0;
        Intrinsics.checkNotNull((Object)this.minDistanceLocation);
        this.minDistanceLocation[index] = loc0;
        Intrinsics.checkNotNull((Object)this.minDistanceLocation);
        this.minDistanceLocation[1 - index] = loc1;
        if (this.minDistance < this.terminateDistance) {
            this.isDone = true;
        }
    }

    private final void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        int geomIndex = this.mostPolygonalIndex();
        boolean flip = geomIndex == 1;
        this.computeMinDistanceMultiMulti(this.geom[geomIndex], this.geom[1 - geomIndex], flip);
    }

    private final int mostPolygonalIndex() {
        Geometry geometry = this.geom[0];
        Intrinsics.checkNotNull((Object)geometry);
        int dim0 = geometry.getDimension();
        Geometry geometry2 = this.geom[1];
        Intrinsics.checkNotNull((Object)geometry2);
        int dim1 = geometry2.getDimension();
        if (dim0 >= 2 && dim1 >= 2) {
            Geometry geometry3 = this.geom[0];
            Intrinsics.checkNotNull((Object)geometry3);
            int n = geometry3.getNumPoints();
            Geometry geometry4 = this.geom[1];
            Intrinsics.checkNotNull((Object)geometry4);
            return n > geometry4.getNumPoints() ? 0 : 1;
        }
        if (dim0 >= 2) {
            return 0;
        }
        return dim1 >= 2 ? 1 : 0;
    }

    private final void computeMinDistanceMultiMulti(Geometry g0, Geometry g1, boolean flip) {
        if (g0 instanceof GeometryCollection) {
            int n = ((GeometryCollection)g0).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g = ((GeometryCollection)g0).getGeometryN(i);
                this.computeMinDistanceMultiMulti(g, g1, flip);
                if (!this.isDone) continue;
                return;
            }
        } else {
            if (g0.isEmpty()) {
                return;
            }
            if (g0 instanceof Polygon) {
                this.computeMinDistanceOneMulti(Distance3DOp.Companion.polyPlane(g0), g1, flip);
            } else {
                this.computeMinDistanceOneMulti(g0, g1, flip);
            }
        }
    }

    private final void computeMinDistanceOneMulti(Geometry g0, Geometry g1, boolean flip) {
        if (g1 instanceof GeometryCollection) {
            int n = ((GeometryCollection)g1).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g = ((GeometryCollection)g1).getGeometryN(i);
                this.computeMinDistanceOneMulti(g0, g, flip);
                if (!this.isDone) continue;
                return;
            }
        } else {
            this.computeMinDistance(g0, g1, flip);
        }
    }

    private final void computeMinDistanceOneMulti(PlanarPolygon3D poly, Geometry geom, boolean flip) {
        if (geom instanceof GeometryCollection) {
            int n = ((GeometryCollection)geom).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry g = ((GeometryCollection)geom).getGeometryN(i);
                this.computeMinDistanceOneMulti(poly, g, flip);
                if (!this.isDone) continue;
                return;
            }
        } else {
            if (geom instanceof Point) {
                this.computeMinDistancePolygonPoint(poly, (Point)geom, flip);
                return;
            }
            if (geom instanceof LineString) {
                this.computeMinDistancePolygonLine(poly, (LineString)geom, flip);
                return;
            }
            if (geom instanceof Polygon) {
                this.computeMinDistancePolygonPolygon(poly, (Polygon)geom, flip);
                return;
            }
        }
    }

    private final void computeMinDistance(Geometry g0, Geometry g1, boolean flip) {
        if (g0 instanceof Point) {
            if (g1 instanceof Point) {
                this.computeMinDistancePointPoint((Point)g0, (Point)g1, flip);
                return;
            }
            if (g1 instanceof LineString) {
                this.computeMinDistanceLinePoint((LineString)g1, (Point)g0, !flip);
                return;
            }
            if (g1 instanceof Polygon) {
                this.computeMinDistancePolygonPoint(Distance3DOp.Companion.polyPlane(g1), (Point)g0, !flip);
                return;
            }
        }
        if (g0 instanceof LineString) {
            if (g1 instanceof Point) {
                this.computeMinDistanceLinePoint((LineString)g0, (Point)g1, flip);
                return;
            }
            if (g1 instanceof LineString) {
                this.computeMinDistanceLineLine((LineString)g0, (LineString)g1, flip);
                return;
            }
            if (g1 instanceof Polygon) {
                this.computeMinDistancePolygonLine(Distance3DOp.Companion.polyPlane(g1), (LineString)g0, !flip);
                return;
            }
        }
        if (g0 instanceof Polygon) {
            if (g1 instanceof Point) {
                this.computeMinDistancePolygonPoint(Distance3DOp.Companion.polyPlane(g0), (Point)g1, flip);
                return;
            }
            if (g1 instanceof LineString) {
                this.computeMinDistancePolygonLine(Distance3DOp.Companion.polyPlane(g0), (LineString)g1, flip);
                return;
            }
            if (g1 instanceof Polygon) {
                this.computeMinDistancePolygonPolygon(Distance3DOp.Companion.polyPlane(g0), (Polygon)g1, flip);
                return;
            }
        }
    }

    private final void computeMinDistancePolygonPolygon(PlanarPolygon3D poly0, Polygon poly1, boolean flip) {
        this.computeMinDistancePolygonRings(poly0, poly1, flip);
        if (this.isDone) {
            return;
        }
        PlanarPolygon3D polyPlane1 = new PlanarPolygon3D(poly1);
        this.computeMinDistancePolygonRings(polyPlane1, poly0.polygon, flip);
    }

    private final void computeMinDistancePolygonRings(PlanarPolygon3D poly, Polygon ringPoly, boolean flip) {
        this.computeMinDistancePolygonLine(poly, ringPoly.getExteriorRing(), flip);
        if (this.isDone) {
            return;
        }
        int nHole = ringPoly.getNumInteriorRing();
        for (int i = 0; i < nHole; ++i) {
            this.computeMinDistancePolygonLine(poly, ringPoly.getInteriorRingN(i), flip);
            if (!this.isDone) continue;
            return;
        }
    }

    private final void computeMinDistancePolygonLine(PlanarPolygon3D poly, LineString line, boolean flip) {
        Coordinate intPt = this.intersection(poly, line);
        if (intPt != null) {
            this.updateDistance(0.0, new GeometryLocation(poly.polygon, 0, intPt), new GeometryLocation(line, 0, intPt), flip);
            return;
        }
        LinearRing linearRing = poly.polygon.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        this.computeMinDistanceLineLine(linearRing, line, flip);
        if (this.isDone) {
            return;
        }
        int nHole = poly.polygon.getNumInteriorRing();
        for (int i = 0; i < nHole; ++i) {
            this.computeMinDistanceLineLine(poly.polygon.getInteriorRingN(i), line, flip);
            if (!this.isDone) continue;
            return;
        }
    }

    private final Coordinate intersection(PlanarPolygon3D poly, LineString line) {
        CoordinateSequence seq;
        LineString lineString = line;
        Intrinsics.checkNotNull((Object)lineString);
        CoordinateSequence coordinateSequence = seq = lineString.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        if (coordinateSequence.size() == 0) {
            return null;
        }
        Coordinate p0 = new Coordinate();
        seq.getCoordinate(0, p0);
        double d0 = poly.getPlane().orientedDistance(p0);
        Coordinate p1 = new Coordinate();
        int n = seq.size() - 1;
        for (int i = 0; i < n; ++i) {
            seq.getCoordinate(i, p0);
            seq.getCoordinate(i + 1, p1);
            double d1 = poly.getPlane().orientedDistance(p1);
            if (d0 * d1 > 0.0) continue;
            Coordinate intPt = Distance3DOp.Companion.segmentPoint(p0, p1, d0, d1);
            if (poly.intersects(intPt)) {
                return intPt;
            }
            d0 = d1;
        }
        return null;
    }

    private final void computeMinDistancePolygonPoint(PlanarPolygon3D polyPlane, Point point, boolean flip) {
        Coordinate pt = point.getCoordinate();
        LinearRing linearRing = polyPlane.polygon.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        LineString shell = linearRing;
        if (polyPlane.intersects(pt, shell)) {
            int nHole = polyPlane.polygon.getNumInteriorRing();
            for (int i = 0; i < nHole; ++i) {
                LineString hole = polyPlane.polygon.getInteriorRingN(i);
                if (!polyPlane.intersects(pt, hole)) continue;
                this.computeMinDistanceLinePoint(hole, point, flip);
                return;
            }
            double dist = Math.INSTANCE.abs(polyPlane.getPlane().orientedDistance(pt));
            this.updateDistance(dist, new GeometryLocation(polyPlane.polygon, 0, pt), new GeometryLocation(point, 0, pt), flip);
        }
        this.computeMinDistanceLinePoint(shell, point, flip);
    }

    private final void computeMinDistanceLineLine(LineString line0, LineString line1, boolean flip) {
        Coordinate[] coord0 = line0.getCoordinates();
        LineString lineString = line1;
        Intrinsics.checkNotNull((Object)lineString);
        Coordinate[] coord1 = lineString.getCoordinates();
        int n = coord0.length - 1;
        for (int i = 0; i < n; ++i) {
            int n2 = coord1.length - 1;
            for (int j = 0; j < n2; ++j) {
                double dist = CGAlgorithms3D.INSTANCE.distanceSegmentSegment(coord0[i], coord0[i + 1], coord1[j], coord1[j + 1]);
                if (dist < this.minDistance) {
                    this.minDistance = dist;
                    LineSegment seg0 = new LineSegment(coord0[i], coord0[i + 1]);
                    LineSegment seg1 = new LineSegment(coord1[j], coord1[j + 1]);
                    Coordinate[] closestPt = seg0.closestPoints(seg1);
                    this.updateDistance(dist, new GeometryLocation(line0, i, closestPt[0]), new GeometryLocation(line1, j, closestPt[1]), flip);
                }
                if (!this.isDone) continue;
                return;
            }
        }
    }

    private final void computeMinDistanceLinePoint(LineString line, Point point, boolean flip) {
        Coordinate[] lineCoord = line.getCoordinates();
        Coordinate coord = point.getCoordinate();
        int n = lineCoord.length - 1;
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull((Object)coordinate);
            double dist = CGAlgorithms3D.INSTANCE.distancePointSegment(coordinate, lineCoord[i], lineCoord[i + 1]);
            if (dist < this.minDistance) {
                LineSegment seg = new LineSegment(lineCoord[i], lineCoord[i + 1]);
                Coordinate segClosestPoint = seg.closestPoint(coord);
                this.updateDistance(dist, new GeometryLocation(line, i, segClosestPoint), new GeometryLocation(point, 0, coord), flip);
            }
            if (!this.isDone) continue;
            return;
        }
    }

    private final void computeMinDistancePointPoint(Point point0, Point point1, boolean flip) {
        Coordinate coordinate = point0.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = point1.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate2);
        double dist = CGAlgorithms3D.INSTANCE.distance(coordinate, coordinate2);
        if (dist < this.minDistance) {
            this.updateDistance(dist, new GeometryLocation(point0, 0, point0.getCoordinate()), new GeometryLocation(point1, 0, point1.getCoordinate()), flip);
        }
    }

    @JvmOverloads
    public Distance3DOp(@NotNull Geometry g0, @NotNull Geometry g1) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this(g0, g1, 0.0, 4, null);
    }

    @JvmStatic
    public static final boolean isWithinDistance(@NotNull Geometry g0, @NotNull Geometry g1, double distance) {
        return Companion.isWithinDistance(g0, g1, distance);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J#\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J(\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/distance3d/Distance3DOp$Companion;", "", "<init>", "()V", "distance", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "isWithinDistance", "", "nearestPoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "polyPlane", "Lorg/locationtech/jts/operation/distance3d/PlanarPolygon3D;", "poly", "segmentPoint", "p0", "p1", "d0", "d1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double distance(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            Distance3DOp distOp = new Distance3DOp(g0, g1, 0.0, 4, null);
            return distOp.distance();
        }

        @JvmStatic
        public final boolean isWithinDistance(@NotNull Geometry g0, @NotNull Geometry g1, double distance) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            Distance3DOp distOp = new Distance3DOp(g0, g1, distance);
            return distOp.distance() <= distance;
        }

        @NotNull
        public final Coordinate[] nearestPoints(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            Distance3DOp distOp = new Distance3DOp(g0, g1, 0.0, 4, null);
            return distOp.nearestPoints();
        }

        private final PlanarPolygon3D polyPlane(Geometry poly) {
            Intrinsics.checkNotNull((Object)poly, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            return new PlanarPolygon3D((Polygon)poly);
        }

        private final Coordinate segmentPoint(Coordinate p0, Coordinate p1, double d0, double d1) {
            if (d0 <= 0.0) {
                return new Coordinate(p0);
            }
            if (d1 <= 0.0) {
                return new Coordinate(p1);
            }
            double f = Math.INSTANCE.abs(d0) / (Math.INSTANCE.abs(d0) + Math.INSTANCE.abs(d1));
            double intx = p0.x + f * (p1.x - p0.x);
            double inty = p0.y + f * (p1.y - p0.y);
            double intz = p0.getZ() + f * (p1.getZ() - p0.getZ());
            return new Coordinate(intx, inty, intz);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

