/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance3d;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.RayCrossingCounter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.math.Plane3D;
import org.locationtech.jts.math.Vector3D;
import org.locationtech.jts.operation.distance3d.AxisPlaneCoordinateSequence;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011J\u001a\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0019R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/operation/distance3d/PlanarPolygon3D;", "", "polygon", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "plane", "Lorg/locationtech/jts/math/Plane3D;", "facingPlane", "", "findBestFitPlane", "poly", "averageNormal", "Lorg/locationtech/jts/math/Vector3D;", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "averagePoint", "Lorg/locationtech/jts/geom/Coordinate;", "getPlane", "intersects", "", "intPt", "locate", "pt", "ring", "Lorg/locationtech/jts/geom/LineString;", "Companion", "kts-core"})
public final class PlanarPolygon3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Polygon polygon;
    @NotNull
    private final Plane3D plane;
    private int facingPlane;

    public PlanarPolygon3D(@NotNull Polygon polygon) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        this.polygon = polygon;
        this.facingPlane = -1;
        this.plane = this.findBestFitPlane(this.polygon);
        this.facingPlane = this.plane.closestAxisPlane();
    }

    private final Plane3D findBestFitPlane(Polygon poly) {
        LinearRing linearRing = poly.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        CoordinateSequence seq = linearRing.getCoordinateSequence();
        Coordinate basePt = this.averagePoint(seq);
        Vector3D normal = this.averageNormal(seq);
        return new Plane3D(normal, basePt);
    }

    private final Vector3D averageNormal(CoordinateSequence seq) {
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        Coordinate sum = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p1 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate p2 = new Coordinate(0.0, 0.0, 0.0);
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            seq.getCoordinate(i, p1);
            seq.getCoordinate(i + 1, p2);
            sum.x += (p1.y - p2.y) * (p1.getZ() + p2.getZ());
            sum.y += (p1.getZ() - p2.getZ()) * (p1.x + p2.x);
            sum.setZ(sum.getZ() + (p1.x - p2.x) * (p1.y + p2.y));
        }
        sum.x /= (double)n;
        sum.y /= (double)n;
        sum.setZ(sum.getZ() / (double)n);
        return Vector3D.Companion.create(sum).normalize();
    }

    private final Coordinate averagePoint(CoordinateSequence seq) {
        Coordinate a = new Coordinate(0.0, 0.0, 0.0);
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        for (int i = 0; i < n; ++i) {
            a.x += seq.getOrdinate(i, 0);
            a.y += seq.getOrdinate(i, 1);
            a.setZ(a.getZ() + seq.getOrdinate(i, 2));
        }
        a.x /= (double)n;
        a.y /= (double)n;
        a.setZ(a.getZ() / (double)n);
        return a;
    }

    @NotNull
    public final Plane3D getPlane() {
        return this.plane;
    }

    public final boolean intersects(@NotNull Coordinate intPt) {
        Intrinsics.checkNotNullParameter((Object)intPt, (String)"intPt");
        if (2 == this.locate(intPt, this.polygon.getExteriorRing())) {
            return false;
        }
        int n = this.polygon.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            if (this.locate(intPt, this.polygon.getInteriorRingN(i)) != 0) continue;
            return false;
        }
        return true;
    }

    private final int locate(Coordinate pt, LineString ring) {
        LineString lineString = ring;
        Intrinsics.checkNotNull((Object)lineString);
        CoordinateSequence seq = lineString.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.Companion.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.Companion.project(pt, this.facingPlane);
        return RayCrossingCounter.Companion.locatePointInRing(ptProj, seqProj);
    }

    public final boolean intersects(@Nullable Coordinate pt, @NotNull LineString ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        CoordinateSequence seq = ring.getCoordinateSequence();
        CoordinateSequence seqProj = PlanarPolygon3D.Companion.project(seq, this.facingPlane);
        Coordinate ptProj = PlanarPolygon3D.Companion.project(pt, this.facingPlane);
        return 2 != RayCrossingCounter.Companion.locatePointInRing(ptProj, seqProj);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0004\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/operation/distance3d/PlanarPolygon3D$Companion;", "", "<init>", "()V", "project", "Lorg/locationtech/jts/geom/CoordinateSequence;", "seq", "facingPlane", "", "Lorg/locationtech/jts/geom/Coordinate;", "p", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final CoordinateSequence project(CoordinateSequence seq, int facingPlane) {
            return switch (facingPlane) {
                case 1 -> AxisPlaneCoordinateSequence.Companion.projectToXY(seq);
                case 3 -> AxisPlaneCoordinateSequence.Companion.projectToXZ(seq);
                default -> AxisPlaneCoordinateSequence.Companion.projectToYZ(seq);
            };
        }

        private final Coordinate project(Coordinate p, int facingPlane) {
            return switch (facingPlane) {
                case 1 -> {
                    Coordinate v0 = p;
                    Intrinsics.checkNotNull((Object)v0);
                    yield new Coordinate(v0.x, p.y);
                }
                case 3 -> {
                    Coordinate v2 = p;
                    Intrinsics.checkNotNull((Object)v2);
                    yield new Coordinate(v2.x, p.getZ());
                }
                default -> {
                    Coordinate v3 = p;
                    Intrinsics.checkNotNull((Object)v3);
                    yield new Coordinate(v3.y, p.getZ());
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

