/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0010R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u001b\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/locationtech/jts/operation/overlayng/InputGeometry;", "", "geomA", "Lorg/locationtech/jts/geom/Geometry;", "geomB", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "geom", "", "[Lorg/locationtech/jts/geom/Geometry;", "ptLocatorA", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "ptLocatorB", "isCollapsed", "", "isSingle", "", "()Z", "getDimension", "", "index", "getGeometry", "geomIndex", "getEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "isEmpty", "isArea", "areaIndex", "getAreaIndex", "()I", "isLine", "isAllPoints", "hasPoints", "hasEdges", "locatePointInArea", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "getLocator", "setCollapsed", "", "isGeomCollapsed", "kts-core"})
public final class InputGeometry {
    @NotNull
    private Geometry[] geom = new Geometry[2];
    @Nullable
    private PointOnGeometryLocator ptLocatorA;
    @Nullable
    private PointOnGeometryLocator ptLocatorB;
    @NotNull
    private final boolean[] isCollapsed = new boolean[2];

    public InputGeometry(@Nullable Geometry geomA, @Nullable Geometry geomB) {
        Geometry[] geometryArray = new Geometry[]{geomA, geomB};
        this.geom = geometryArray;
    }

    public final boolean isSingle() {
        return this.geom[1] == null;
    }

    public final int getDimension(int index) {
        int n;
        if (this.geom[index] == null) {
            n = -1;
        } else {
            Geometry geometry = this.geom[index];
            Intrinsics.checkNotNull((Object)geometry);
            n = geometry.getDimension();
        }
        return n;
    }

    @Nullable
    public final Geometry getGeometry(int geomIndex) {
        return this.geom[geomIndex];
    }

    @NotNull
    public final Envelope getEnvelope(int geomIndex) {
        Geometry geometry = this.geom[geomIndex];
        Intrinsics.checkNotNull((Object)geometry);
        return geometry.getEnvelopeInternal();
    }

    public final boolean isEmpty(int geomIndex) {
        Geometry geometry = this.geom[geomIndex];
        Intrinsics.checkNotNull((Object)geometry);
        return geometry.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isArea(int geomIndex) {
        if (this.geom[geomIndex] == null) return false;
        Geometry geometry = this.geom[geomIndex];
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.getDimension() != 2) return false;
        return true;
    }

    public final int getAreaIndex() {
        if (this.getDimension(0) == 2) {
            return 0;
        }
        return this.getDimension(1) == 2 ? 1 : -1;
    }

    public final boolean isLine(int geomIndex) {
        return this.getDimension(geomIndex) == 1;
    }

    public final boolean isAllPoints() {
        return this.getDimension(0) == 0 && this.geom[1] != null && this.getDimension(1) == 0;
    }

    public final boolean hasPoints() {
        return this.getDimension(0) == 0 || this.getDimension(1) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasEdges(int geomIndex) {
        if (this.geom[geomIndex] == null) return false;
        Geometry geometry = this.geom[geomIndex];
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.getDimension() <= 0) return false;
        return true;
    }

    public final int locatePointInArea(int geomIndex, @Nullable Coordinate pt) {
        if (this.isCollapsed[geomIndex]) {
            return 2;
        }
        Geometry geometry = this.getGeometry(geomIndex);
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.isEmpty() || this.isCollapsed[geomIndex]) {
            return 2;
        }
        PointOnGeometryLocator ptLocator = this.getLocator(geomIndex);
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        return ptLocator.locate(coordinate);
    }

    private final PointOnGeometryLocator getLocator(int geomIndex) {
        PointOnGeometryLocator pointOnGeometryLocator;
        if (geomIndex == 0) {
            if (this.ptLocatorA == null) {
                this.ptLocatorA = new IndexedPointInAreaLocator(this.getGeometry(geomIndex));
            }
            PointOnGeometryLocator pointOnGeometryLocator2 = this.ptLocatorA;
            pointOnGeometryLocator = pointOnGeometryLocator2;
            Intrinsics.checkNotNull((Object)pointOnGeometryLocator2);
        } else {
            if (this.ptLocatorB == null) {
                this.ptLocatorB = new IndexedPointInAreaLocator(this.getGeometry(geomIndex));
            }
            PointOnGeometryLocator pointOnGeometryLocator3 = this.ptLocatorB;
            pointOnGeometryLocator = pointOnGeometryLocator3;
            Intrinsics.checkNotNull((Object)pointOnGeometryLocator3);
        }
        return pointOnGeometryLocator;
    }

    public final void setCollapsed(int geomIndex, boolean isGeomCollapsed) {
        this.isCollapsed[geomIndex] = isGeomCollapsed;
    }
}

