/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.overlayng.InputGeometry;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.OverlayLabel;
import org.locationtech.jts.operation.overlayng.OverlayNG;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J\b\u0010#\u001a\u00020\u0016H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020!H\u0002R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/locationtech/jts/operation/overlayng/LineBuilder;", "", "inputGeom", "Lorg/locationtech/jts/operation/overlayng/InputGeometry;", "graph", "Lorg/locationtech/jts/operation/overlayng/OverlayGraph;", "hasResultArea", "", "opCode", "", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/operation/overlayng/InputGeometry;Lorg/locationtech/jts/operation/overlayng/OverlayGraph;ZILorg/locationtech/jts/geom/GeometryFactory;)V", "geometryFactory", "inputAreaIndex", "isAllowMixedResult", "isAllowCollapseLines", "lines", "", "Lorg/locationtech/jts/geom/LineString;", "setStrictMode", "", "isStrictResultMode", "getLines", "", "markResultLines", "isResultLine", "lbl", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "addResultLines", "toLine", "edge", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "addResultLinesMerged", "addResultLinesForNodes", "addResultLinesRings", "buildLine", "node", "Companion", "kts-core"})
public final class LineBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final OverlayGraph graph;
    private final int opCode;
    private final int inputAreaIndex;
    private final boolean hasResultArea;
    private boolean isAllowMixedResult;
    private boolean isAllowCollapseLines;
    @NotNull
    private final List<LineString> lines;

    public LineBuilder(@NotNull InputGeometry inputGeom, @NotNull OverlayGraph graph, boolean hasResultArea, int opCode, @NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        this.isAllowMixedResult = true;
        this.isAllowCollapseLines = true;
        this.lines = new ArrayList();
        this.graph = graph;
        this.opCode = opCode;
        this.geometryFactory = geomFact;
        this.hasResultArea = hasResultArea;
        this.inputAreaIndex = inputGeom.getAreaIndex();
    }

    public final void setStrictMode(boolean isStrictResultMode) {
        this.isAllowCollapseLines = !isStrictResultMode;
        this.isAllowMixedResult = !isStrictResultMode;
    }

    @NotNull
    public final List<LineString> getLines() {
        this.markResultLines();
        this.addResultLines();
        return this.lines;
    }

    private final void markResultLines() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (edge.isInResultEither() || !this.isResultLine(edge.getLabel())) continue;
            edge.markInResultLine();
        }
    }

    private final boolean isResultLine(OverlayLabel lbl) {
        if (lbl.isBoundarySingleton()) {
            return false;
        }
        if (!this.isAllowCollapseLines && lbl.isBoundaryCollapse()) {
            return false;
        }
        if (lbl.isInteriorCollapse()) {
            return false;
        }
        if (this.opCode != 1) {
            if (lbl.isCollapseAndNotPartInterior()) {
                return false;
            }
            if (this.hasResultArea && lbl.isLineInArea(this.inputAreaIndex)) {
                return false;
            }
        }
        if (this.isAllowMixedResult && this.opCode == 1 && lbl.isBoundaryTouch()) {
            return true;
        }
        int aLoc = LineBuilder.Companion.effectiveLocation(lbl, 0);
        int bLoc = LineBuilder.Companion.effectiveLocation(lbl, 1);
        return OverlayNG.Companion.isResultOfOp(this.opCode, aLoc, bLoc);
    }

    private final void addResultLines() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (!edge.isInResultLine() || edge.isVisited()) continue;
            this.lines.add(this.toLine(edge));
            edge.markVisitedBoth();
        }
    }

    private final LineString toLine(OverlayEdge edge) {
        boolean isForward = edge.isForward();
        CoordinateList pts = new CoordinateList();
        pts.add(edge.orig(), false);
        edge.addCoordinates(pts);
        Coordinate[] ptsOut = pts.toCoordinateArray(isForward);
        return this.geometryFactory.createLineString(ptsOut);
    }

    private final void addResultLinesMerged() {
        this.addResultLinesForNodes();
        this.addResultLinesRings();
    }

    private final void addResultLinesForNodes() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (!edge.isInResultLine() || edge.isVisited() || LineBuilder.Companion.degreeOfLines(edge) == 2) continue;
            this.lines.add(this.buildLine(edge));
        }
    }

    private final void addResultLinesRings() {
        Collection<OverlayEdge> edges = this.graph.getEdges();
        for (OverlayEdge edge : edges) {
            if (!edge.isInResultLine() || edge.isVisited()) continue;
            this.lines.add(this.buildLine(edge));
        }
    }

    private final LineString buildLine(OverlayEdge node) {
        CoordinateList pts = new CoordinateList();
        pts.add(node.orig(), false);
        boolean isForward = node.isForward();
        OverlayEdge e = node;
        do {
            OverlayEdge overlayEdge = e;
            Intrinsics.checkNotNull((Object)overlayEdge);
            overlayEdge.markVisitedBoth();
            e.addCoordinates(pts);
        } while (LineBuilder.Companion.degreeOfLines(e.symOE()) == 2 && (e = LineBuilder.Companion.nextLineEdgeUnvisited(e.symOE())) != null);
        Coordinate[] ptsOut = pts.toCoordinateArray(isForward);
        return this.geometryFactory.createLineString(ptsOut);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/operation/overlayng/LineBuilder$Companion;", "", "<init>", "()V", "effectiveLocation", "", "lbl", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "geomIndex", "nextLineEdgeUnvisited", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "node", "degreeOfLines", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int effectiveLocation(OverlayLabel lbl, int geomIndex) {
            if (lbl.isCollapse(geomIndex)) {
                return 0;
            }
            return lbl.isLine(geomIndex) ? 0 : lbl.getLineLocation(geomIndex);
        }

        private final OverlayEdge nextLineEdgeUnvisited(OverlayEdge node) {
            OverlayEdge e = node;
            do {
                if ((e = e.oNextOE()).isVisited() || !e.isInResultLine()) continue;
                return e;
            } while (e != node);
            return null;
        }

        private final int degreeOfLines(OverlayEdge node) {
            int degree = 0;
            OverlayEdge e = node;
            do {
                if (!e.isInResultLine()) continue;
                ++degree;
            } while ((e = e.oNextOE()) != node);
            return degree;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

