/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.ShortCircuitedGeometryVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/operation/predicate/EnvelopeIntersectsVisitor;", "Lorg/locationtech/jts/geom/util/ShortCircuitedGeometryVisitor;", "rectEnv", "Lorg/locationtech/jts/geom/Envelope;", "<init>", "(Lorg/locationtech/jts/geom/Envelope;)V", "intersects", "", "visit", "", "element", "Lorg/locationtech/jts/geom/Geometry;", "isDone", "kts-core"})
public final class EnvelopeIntersectsVisitor
extends ShortCircuitedGeometryVisitor {
    @NotNull
    private final Envelope rectEnv;
    private boolean intersects;

    public EnvelopeIntersectsVisitor(@NotNull Envelope rectEnv) {
        Intrinsics.checkNotNullParameter((Object)rectEnv, (String)"rectEnv");
        this.rectEnv = rectEnv;
    }

    public final boolean intersects() {
        return this.intersects;
    }

    @Override
    protected void visit(@NotNull Geometry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Envelope elementEnv = element.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        if (this.rectEnv.contains(elementEnv)) {
            this.intersects = true;
            return;
        }
        if (elementEnv.getMinX() >= this.rectEnv.getMinX() && elementEnv.getMaxX() <= this.rectEnv.getMaxX()) {
            this.intersects = true;
            return;
        }
        if (elementEnv.getMinY() >= this.rectEnv.getMinY() && elementEnv.getMaxY() <= this.rectEnv.getMaxY()) {
            this.intersects = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.intersects;
    }
}

