/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeMap;
import org.locationtech.jts.operation.relate.EdgeEndBuilder;
import org.locationtech.jts.operation.relate.RelateNode;
import org.locationtech.jts.operation.relate.RelateNodeFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\u000b2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/relate/RelateNodeGraph;", "", "<init>", "()V", "nodes", "Lorg/locationtech/jts/geomgraph/NodeMap;", "nodeIterator", "", "getNodeIterator", "()Ljava/util/Iterator;", "build", "", "geomGraph", "Lorg/locationtech/jts/geomgraph/GeometryGraph;", "computeIntersectionNodes", "argIndex", "", "copyNodesAndLabels", "insertEdgeEnds", "ee", "", "kts-core"})
public final class RelateNodeGraph {
    @NotNull
    private final NodeMap nodes = new NodeMap(new RelateNodeFactory());

    @NotNull
    public final Iterator<?> getNodeIterator() {
        return this.nodes.iterator();
    }

    public final void build(@NotNull GeometryGraph geomGraph) {
        Intrinsics.checkNotNullParameter((Object)geomGraph, (String)"geomGraph");
        this.computeIntersectionNodes(geomGraph, 0);
        this.copyNodesAndLabels(geomGraph, 0);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        List<Object> eeList = eeBuilder.computeEdgeEnds(geomGraph.getEdgeIterator());
        this.insertEdgeEnds(eeList);
    }

    public final void computeIntersectionNodes(@NotNull GeometryGraph geomGraph, int argIndex) {
        Intrinsics.checkNotNullParameter((Object)geomGraph, (String)"geomGraph");
        Iterator<?> edgeIt = geomGraph.getEdgeIterator();
        while (edgeIt.hasNext()) {
            Object obj = edgeIt.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            int eLoc = label.getLocation(argIndex);
            Iterator<?> eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                Object obj2 = eiIt.next();
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
                EdgeIntersection ei = (EdgeIntersection)obj2;
                RelateNode n = (RelateNode)this.nodes.addNode(ei.getCoord());
                if (eLoc == 1) {
                    RelateNode relateNode = n;
                    Intrinsics.checkNotNull((Object)relateNode);
                    relateNode.setLabelBoundary(argIndex);
                    continue;
                }
                RelateNode relateNode = n;
                Intrinsics.checkNotNull((Object)relateNode);
                Label label2 = relateNode.getLabel();
                Intrinsics.checkNotNull((Object)label2);
                if (!label2.isNull(argIndex)) continue;
                n.setLabel(argIndex, 0);
            }
        }
    }

    public final void copyNodesAndLabels(@NotNull GeometryGraph geomGraph, int argIndex) {
        Intrinsics.checkNotNullParameter((Object)geomGraph, (String)"geomGraph");
        Iterator<?> nodeIt = geomGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            Object obj = nodeIt.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node graphNode = (Node)obj;
            Coordinate coordinate = graphNode.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            Node newNode = this.nodes.addNode(coordinate);
            Label label = graphNode.getLabel();
            Intrinsics.checkNotNull((Object)label);
            newNode.setLabel(argIndex, label.getLocation(argIndex));
        }
    }

    public final void insertEdgeEnds(@NotNull List<? extends Object> ee) {
        Intrinsics.checkNotNullParameter(ee, (String)"ee");
        for (Object object : ee) {
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)object;
            this.nodes.add(e);
        }
    }
}

