/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0019\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/operation/valid/RepeatedPointTester;", "", "<init>", "()V", "value", "Lorg/locationtech/jts/geom/Coordinate;", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "hasRepeatedPoint", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "coord", "", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "p", "Lorg/locationtech/jts/geom/Polygon;", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "kts-core"})
public final class RepeatedPointTester {
    @Nullable
    private Coordinate coordinate;

    @Nullable
    public final Coordinate getCoordinate() {
        return this.coordinate;
    }

    public final boolean hasRepeatedPoint(@NotNull Geometry g) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (g.isEmpty()) {
            return false;
        }
        if (g instanceof Point) {
            bl = false;
        } else if (g instanceof MultiPoint) {
            bl = false;
        } else if (g instanceof LineString) {
            bl = this.hasRepeatedPoint(((LineString)g).getCoordinates());
        } else if (g instanceof Polygon) {
            bl = this.hasRepeatedPoint((Polygon)g);
        } else if (g instanceof GeometryCollection) {
            bl = this.hasRepeatedPoint((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(g.getClass()).getSimpleName());
        }
        return bl;
    }

    public final boolean hasRepeatedPoint(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        int n = coord.length;
        for (int i = 1; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)coord[i - 1], (Object)coord[i])) continue;
            this.coordinate = coord[i];
            return true;
        }
        return false;
    }

    private final boolean hasRepeatedPoint(Polygon p) {
        LinearRing linearRing = p.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        if (this.hasRepeatedPoint(linearRing.getCoordinates())) {
            return true;
        }
        int n = p.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            if (!this.hasRepeatedPoint(p.getInteriorRingN(i).getCoordinates())) continue;
            return true;
        }
        return false;
    }

    private final boolean hasRepeatedPoint(GeometryCollection gc) {
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            if (!this.hasRepeatedPoint(g)) continue;
            return true;
        }
        return false;
    }
}

