/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.NodeMap;
import org.locationtech.jts.planargraph.PlanarGraph;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!J\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030!J\n\u0010#\u001a\u0006\u0012\u0002\b\u00030!J\u0013\u0010$\u001a\u00020%2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u0086\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/planargraph/Subgraph;", "", "parent", "Lorg/locationtech/jts/planargraph/PlanarGraph;", "<init>", "(Lorg/locationtech/jts/planargraph/PlanarGraph;)V", "getParent", "()Lorg/locationtech/jts/planargraph/PlanarGraph;", "setParent", "edges", "", "Lorg/locationtech/jts/planargraph/Edge;", "getEdges", "()Ljava/util/Set;", "setEdges", "(Ljava/util/Set;)V", "dirEdges", "", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "getDirEdges", "()Ljava/util/List;", "setDirEdges", "(Ljava/util/List;)V", "nodeMap", "Lorg/locationtech/jts/planargraph/NodeMap;", "getNodeMap", "()Lorg/locationtech/jts/planargraph/NodeMap;", "setNodeMap", "(Lorg/locationtech/jts/planargraph/NodeMap;)V", "add", "", "e", "dirEdgeIterator", "", "edgeIterator", "nodeIterator", "contains", "", "kts-core"})
public final class Subgraph {
    @NotNull
    private PlanarGraph parent;
    @NotNull
    private Set<Edge> edges;
    @NotNull
    private List<DirectedEdge> dirEdges;
    @NotNull
    private NodeMap nodeMap;

    public Subgraph(@NotNull PlanarGraph parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.edges = new HashSet();
        this.dirEdges = new ArrayList();
        this.nodeMap = new NodeMap();
    }

    @NotNull
    public final PlanarGraph getParent() {
        return this.parent;
    }

    public final void setParent(@NotNull PlanarGraph planarGraph) {
        Intrinsics.checkNotNullParameter((Object)planarGraph, (String)"<set-?>");
        this.parent = planarGraph;
    }

    @NotNull
    protected final Set<Edge> getEdges() {
        return this.edges;
    }

    protected final void setEdges(@NotNull Set<Edge> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.edges = set;
    }

    @NotNull
    protected final List<DirectedEdge> getDirEdges() {
        return this.dirEdges;
    }

    protected final void setDirEdges(@NotNull List<DirectedEdge> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dirEdges = list;
    }

    @NotNull
    protected final NodeMap getNodeMap() {
        return this.nodeMap;
    }

    protected final void setNodeMap(@NotNull NodeMap nodeMap) {
        Intrinsics.checkNotNullParameter((Object)nodeMap, (String)"<set-?>");
        this.nodeMap = nodeMap;
    }

    public final void add(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.edges.contains(e)) {
            return;
        }
        this.edges.add(e);
        this.dirEdges.add(e.getDirEdge(0));
        this.dirEdges.add(e.getDirEdge(1));
        this.nodeMap.add(e.getDirEdge(0).getFromNode());
        this.nodeMap.add(e.getDirEdge(1).getFromNode());
    }

    @NotNull
    public final Iterator<?> dirEdgeIterator() {
        return this.dirEdges.iterator();
    }

    @NotNull
    public final Iterator<?> edgeIterator() {
        return this.edges.iterator();
    }

    @NotNull
    public final Iterator<?> nodeIterator() {
        return this.nodeMap.iterator();
    }

    public final boolean contains(@Nullable Edge e) {
        return CollectionsKt.contains((Iterable)this.edges, (Object)e);
    }
}

