/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.precision.CommonBitsRemover;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J%\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00172\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/precision/CommonBitsOp;", "", "returnToOriginalPrecision", "", "<init>", "(Z)V", "getReturnToOriginalPrecision", "()Z", "cbr", "Lorg/locationtech/jts/precision/CommonBitsRemover;", "intersection", "Lorg/locationtech/jts/geom/Geometry;", "geom0", "geom1", "union", "difference", "symDifference", "buffer", "distance", "", "computeResultPrecision", "result", "removeCommonBits", "", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
public final class CommonBitsOp {
    private final boolean returnToOriginalPrecision;
    @Nullable
    private CommonBitsRemover cbr;

    @JvmOverloads
    public CommonBitsOp(boolean returnToOriginalPrecision) {
        this.returnToOriginalPrecision = returnToOriginalPrecision;
    }

    public /* synthetic */ CommonBitsOp(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getReturnToOriginalPrecision() {
        return this.returnToOriginalPrecision;
    }

    @NotNull
    public final Geometry intersection(@NotNull Geometry geom0, @NotNull Geometry geom1) {
        Intrinsics.checkNotNullParameter((Object)geom0, (String)"geom0");
        Intrinsics.checkNotNullParameter((Object)geom1, (String)"geom1");
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        Geometry geometry = geom[0];
        Intrinsics.checkNotNull((Object)geometry);
        return this.computeResultPrecision(geometry.intersection(geom[1]));
    }

    @NotNull
    public final Geometry union(@NotNull Geometry geom0, @NotNull Geometry geom1) {
        Intrinsics.checkNotNullParameter((Object)geom0, (String)"geom0");
        Intrinsics.checkNotNullParameter((Object)geom1, (String)"geom1");
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        Geometry geometry = geom[0];
        Intrinsics.checkNotNull((Object)geometry);
        return this.computeResultPrecision(geometry.union(geom[1]));
    }

    @NotNull
    public final Geometry difference(@NotNull Geometry geom0, @NotNull Geometry geom1) {
        Intrinsics.checkNotNullParameter((Object)geom0, (String)"geom0");
        Intrinsics.checkNotNullParameter((Object)geom1, (String)"geom1");
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        Geometry geometry = geom[0];
        Intrinsics.checkNotNull((Object)geometry);
        return this.computeResultPrecision(geometry.difference(geom[1]));
    }

    @NotNull
    public final Geometry symDifference(@NotNull Geometry geom0, @NotNull Geometry geom1) {
        Intrinsics.checkNotNullParameter((Object)geom0, (String)"geom0");
        Intrinsics.checkNotNullParameter((Object)geom1, (String)"geom1");
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        Geometry geometry = geom[0];
        Intrinsics.checkNotNull((Object)geometry);
        return this.computeResultPrecision(geometry.symDifference(geom[1]));
    }

    @NotNull
    public final Geometry buffer(@NotNull Geometry geom0, double distance) {
        Intrinsics.checkNotNullParameter((Object)geom0, (String)"geom0");
        Geometry geom = this.removeCommonBits(geom0);
        return this.computeResultPrecision(geom.buffer(distance));
    }

    private final Geometry computeResultPrecision(Geometry result2) {
        if (this.returnToOriginalPrecision) {
            CommonBitsRemover commonBitsRemover = this.cbr;
            Intrinsics.checkNotNull((Object)commonBitsRemover);
            commonBitsRemover.addCommonBits(result2);
        }
        return result2;
    }

    private final Geometry removeCommonBits(Geometry geom0) {
        CommonBitsRemover commonBitsRemover = this.cbr = new CommonBitsRemover();
        Intrinsics.checkNotNull((Object)commonBitsRemover);
        commonBitsRemover.add(geom0);
        CommonBitsRemover commonBitsRemover2 = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover2);
        return commonBitsRemover2.removeCommonBits(geom0.copy());
    }

    private final Geometry[] removeCommonBits(Geometry geom0, Geometry geom1) {
        CommonBitsRemover commonBitsRemover = this.cbr = new CommonBitsRemover();
        Intrinsics.checkNotNull((Object)commonBitsRemover);
        commonBitsRemover.add(geom0);
        CommonBitsRemover commonBitsRemover2 = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover2);
        commonBitsRemover2.add(geom1);
        Geometry[] geom = new Geometry[2];
        CommonBitsRemover commonBitsRemover3 = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover3);
        geom[0] = commonBitsRemover3.removeCommonBits(geom0.copy());
        CommonBitsRemover commonBitsRemover4 = this.cbr;
        Intrinsics.checkNotNull((Object)commonBitsRemover4);
        geom[1] = commonBitsRemover4.removeCommonBits(geom1.copy());
        return geom;
    }

    @JvmOverloads
    public CommonBitsOp() {
        this(false, 1, null);
    }
}

