/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.precision.CommonBits;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/precision/CommonBitsRemover;", "", "<init>", "()V", "value", "Lorg/locationtech/jts/geom/Coordinate;", "commonCoordinate", "getCommonCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "ccFilter", "Lorg/locationtech/jts/precision/CommonBitsRemover$CommonCoordinateFilter;", "add", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "removeCommonBits", "addCommonBits", "CommonCoordinateFilter", "Translater", "kts-core"})
public final class CommonBitsRemover {
    @Nullable
    private Coordinate commonCoordinate;
    @NotNull
    private final CommonCoordinateFilter ccFilter = new CommonCoordinateFilter();

    @Nullable
    public final Coordinate getCommonCoordinate() {
        return this.commonCoordinate;
    }

    public final void add(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        geom.apply(this.ccFilter);
        this.commonCoordinate = this.ccFilter.getCommonCoordinate();
    }

    @NotNull
    public final Geometry removeCommonBits(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Coordinate coordinate = this.commonCoordinate;
        Intrinsics.checkNotNull((Object)coordinate);
        if (coordinate.x == 0.0) {
            Coordinate coordinate2 = this.commonCoordinate;
            Intrinsics.checkNotNull((Object)coordinate2);
            if (coordinate2.y == 0.0) {
                return geom;
            }
        }
        Coordinate coordinate3 = this.commonCoordinate;
        Intrinsics.checkNotNull((Object)coordinate3);
        Coordinate invCoord = new Coordinate(coordinate3);
        invCoord.x = -invCoord.x;
        invCoord.y = -invCoord.y;
        Translater trans = new Translater(invCoord);
        geom.apply(trans);
        geom.geometryChanged();
        return geom;
    }

    public final void addCommonBits(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        Translater trans = new Translater(this.commonCoordinate);
        geom.apply(trans);
        geom.geometryChanged();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/precision/CommonBitsRemover$CommonCoordinateFilter;", "Lorg/locationtech/jts/geom/CoordinateFilter;", "<init>", "()V", "commonBitsX", "Lorg/locationtech/jts/precision/CommonBits;", "commonBitsY", "filter", "", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "commonCoordinate", "getCommonCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class CommonCoordinateFilter
    implements CoordinateFilter {
        @NotNull
        private final CommonBits commonBitsX = new CommonBits();
        @NotNull
        private final CommonBits commonBitsY = new CommonBits();

        @Override
        public void filter(@Nullable Coordinate coord) {
            Coordinate coordinate = coord;
            Intrinsics.checkNotNull((Object)coordinate);
            this.commonBitsX.add(coordinate.x);
            this.commonBitsY.add(coord.y);
        }

        @NotNull
        public final Coordinate getCommonCoordinate() {
            return new Coordinate(this.commonBitsX.getCommon(), this.commonBitsY.getCommon());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/precision/CommonBitsRemover$Translater;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "trans", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;)V", "getTrans", "()Lorg/locationtech/jts/geom/Coordinate;", "setTrans", "filter", "", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "i", "", "isDone", "", "()Z", "isGeometryChanged", "kts-core"})
    public static final class Translater
    implements CoordinateSequenceFilter {
        @Nullable
        private Coordinate trans;

        public Translater(@Nullable Coordinate trans) {
            this.trans = trans;
        }

        @Nullable
        public final Coordinate getTrans() {
            return this.trans;
        }

        public final void setTrans(@Nullable Coordinate coordinate) {
            this.trans = coordinate;
        }

        @Override
        public void filter(@Nullable CoordinateSequence seq, int i) {
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            double d = coordinateSequence.getOrdinate(i, 0);
            Coordinate coordinate = this.trans;
            Intrinsics.checkNotNull((Object)coordinate);
            double xp = d + coordinate.x;
            double d2 = seq.getOrdinate(i, 1);
            Coordinate coordinate2 = this.trans;
            Intrinsics.checkNotNull((Object)coordinate2);
            double yp = d2 + coordinate2.y;
            seq.setOrdinate(i, 0, xp);
            seq.setOrdinate(i, 1, yp);
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return true;
        }
    }
}

