/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.distance.FacetSequence;
import org.locationtech.jts.operation.distance.FacetSequenceTreeBuilder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/precision/MinimumClearance;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "minClearance", "", "minClearancePts", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "distance", "getDistance", "()D", "line", "Lorg/locationtech/jts/geom/LineString;", "getLine", "()Lorg/locationtech/jts/geom/LineString;", "compute", "", "MinClearanceDistance", "Companion", "kts-core"})
public final class MinimumClearance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private double minClearance;
    @Nullable
    private Coordinate[] minClearancePts;

    public MinimumClearance(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
    }

    public final double getDistance() {
        this.compute();
        return this.minClearance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final LineString getLine() {
        LineString lineString;
        block3: {
            block2: {
                this.compute();
                if (this.minClearancePts == null) break block2;
                Intrinsics.checkNotNull((Object)this.minClearancePts);
                if (this.minClearancePts[0] != null) break block3;
            }
            lineString = GeometryFactory.createLineString$default(this.inputGeom.getFactory(), null, 1, null);
            return lineString;
        }
        lineString = this.inputGeom.getFactory().createLineString((Coordinate[])(this.minClearancePts != null ? (Coordinate[])ArraysKt.requireNoNulls((Object[])this.minClearancePts) : null));
        return lineString;
    }

    private final void compute() {
        if (this.minClearancePts != null) {
            return;
        }
        this.minClearancePts = new Coordinate[2];
        this.minClearance = Double.MAX_VALUE;
        if (this.inputGeom.isEmpty()) {
            return;
        }
        STRtree geomTree = FacetSequenceTreeBuilder.INSTANCE.build(this.inputGeom);
        Object[] nearest = geomTree.nearestNeighbour(new MinClearanceDistance());
        MinClearanceDistance mcd = new MinClearanceDistance();
        Intrinsics.checkNotNull((Object)nearest);
        Object object = nearest[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
        FacetSequence facetSequence = (FacetSequence)object;
        Object object2 = nearest[1];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
        this.minClearance = mcd.distance(facetSequence, (FacetSequence)object2);
        this.minClearancePts = mcd.getCoordinates();
    }

    @JvmStatic
    public static final double getDistance(@NotNull Geometry g) {
        return Companion.getDistance(g);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/precision/MinimumClearance$Companion;", "", "<init>", "()V", "getDistance", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "getLine", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double getDistance(@NotNull Geometry g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            MinimumClearance rp = new MinimumClearance(g);
            return rp.getDistance();
        }

        @NotNull
        public final Geometry getLine(@NotNull Geometry g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            MinimumClearance rp = new MinimumClearance(g);
            return rp.getLine();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/precision/MinimumClearance$MinClearanceDistance;", "Lorg/locationtech/jts/index/strtree/ItemDistance;", "<init>", "()V", "minDist", "", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "distance", "b1", "Lorg/locationtech/jts/index/strtree/ItemBoundable;", "b2", "fs1", "Lorg/locationtech/jts/operation/distance/FacetSequence;", "fs2", "vertexDistance", "segmentDistance", "updatePts", "", "p", "seg0", "seg1", "kts-core"})
    private static final class MinClearanceDistance
    implements ItemDistance {
        private double minDist = Double.MAX_VALUE;
        @NotNull
        private final Coordinate[] coordinates = new Coordinate[2];

        @NotNull
        public final Coordinate[] getCoordinates() {
            return this.coordinates;
        }

        @Override
        public double distance(@NotNull ItemBoundable b1, @NotNull ItemBoundable b2) {
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b2");
            Object object = b1.getItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
            FacetSequence fs1 = (FacetSequence)object;
            Object object2 = b2.getItem();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
            FacetSequence fs2 = (FacetSequence)object2;
            this.minDist = Double.MAX_VALUE;
            return this.distance(fs1, fs2);
        }

        public final double distance(@NotNull FacetSequence fs1, @NotNull FacetSequence fs2) {
            Intrinsics.checkNotNullParameter((Object)fs1, (String)"fs1");
            Intrinsics.checkNotNullParameter((Object)fs2, (String)"fs2");
            this.vertexDistance(fs1, fs2);
            if (fs1.size() == 1 && fs2.size() == 1) {
                return this.minDist;
            }
            if (this.minDist <= 0.0) {
                return this.minDist;
            }
            this.segmentDistance(fs1, fs2);
            if (this.minDist <= 0.0) {
                return this.minDist;
            }
            this.segmentDistance(fs2, fs1);
            return this.minDist;
        }

        private final double vertexDistance(FacetSequence fs1, FacetSequence fs2) {
            int n = fs1.size();
            for (int i1 = 0; i1 < n; ++i1) {
                int n2 = fs2.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    double d;
                    Coordinate p2;
                    Coordinate p1 = fs1.getCoordinate(i1);
                    if (p1.equals2D(p2 = fs2.getCoordinate(i2)) || !((d = p1.distance(p2)) < this.minDist)) continue;
                    this.minDist = d;
                    this.coordinates[0] = p1;
                    this.coordinates[1] = p2;
                    if (!(d == 0.0)) continue;
                    return d;
                }
            }
            return this.minDist;
        }

        private final double segmentDistance(FacetSequence fs1, FacetSequence fs2) {
            int n = fs1.size();
            for (int i1 = 0; i1 < n; ++i1) {
                int n2 = fs2.size();
                for (int i2 = 1; i2 < n2; ++i2) {
                    double d;
                    Coordinate p = fs1.getCoordinate(i1);
                    Coordinate seg0 = fs2.getCoordinate(i2 - 1);
                    Coordinate seg1 = fs2.getCoordinate(i2);
                    if (p.equals2D(seg0) || p.equals2D(seg1) || !((d = Distance.pointToSegment(p, seg0, seg1)) < this.minDist)) continue;
                    this.minDist = d;
                    this.updatePts(p, seg0, seg1);
                    if (!(d == 0.0)) continue;
                    return d;
                }
            }
            return this.minDist;
        }

        private final void updatePts(Coordinate p, Coordinate seg0, Coordinate seg1) {
            this.coordinates[0] = p;
            LineSegment seg = new LineSegment(seg0, seg1);
            this.coordinates[1] = new Coordinate(seg.closestPoint(p));
        }
    }
}

