/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\fR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/simplify/LinkedRing;", "", "coord", "", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "next", "", "prev", "size", "", "i", "getCoordinate", "index", "prevCoordinate", "nextCoordinate", "hasCoordinate", "", "remove", "", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "Companion", "kts-core"})
public final class LinkedRing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] coord;
    @Nullable
    private int[] next;
    @Nullable
    private int[] prev;
    private int size;
    private static final int NO_COORD_INDEX = -1;

    public LinkedRing(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        this.coord = coord;
        this.size = this.coord.length - 1;
        this.next = LinkedRing.Companion.createNextLinks(this.size);
        this.prev = LinkedRing.Companion.createPrevLinks(this.size);
    }

    public final int size() {
        return this.size;
    }

    public final int next(int i) {
        Intrinsics.checkNotNull((Object)this.next);
        return this.next[i];
    }

    public final int prev(int i) {
        Intrinsics.checkNotNull((Object)this.prev);
        return this.prev[i];
    }

    @NotNull
    public final Coordinate getCoordinate(int index) {
        return this.coord[index];
    }

    @NotNull
    public final Coordinate prevCoordinate(int index) {
        return this.coord[this.prev(index)];
    }

    @NotNull
    public final Coordinate nextCoordinate(int index) {
        return this.coord[this.next(index)];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCoordinate(int index) {
        if (index < 0) return false;
        Intrinsics.checkNotNull((Object)this.prev);
        if (index >= this.prev.length) return false;
        Intrinsics.checkNotNull((Object)this.prev);
        if (this.prev[index] == -1) return false;
        return true;
    }

    public final void remove(int index) {
        Intrinsics.checkNotNull((Object)this.prev);
        int iprev = this.prev[index];
        Intrinsics.checkNotNull((Object)this.next);
        int inext = this.next[index];
        Intrinsics.checkNotNull((Object)this.next);
        this.next[iprev] = inext;
        Intrinsics.checkNotNull((Object)this.prev);
        this.prev[inext] = iprev;
        Intrinsics.checkNotNull((Object)this.prev);
        this.prev[index] = -1;
        Intrinsics.checkNotNull((Object)this.next);
        this.next[index] = -1;
        int n = this.size;
        this.size = n + -1;
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        CoordinateList coords = new CoordinateList();
        int n = this.coord.length - 1;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.prev);
            if (this.prev[i] == -1) continue;
            coords.add(this.coord[i].copy(), false);
        }
        coords.closeRing();
        return coords.toCoordinateArray();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/simplify/LinkedRing$Companion;", "", "<init>", "()V", "NO_COORD_INDEX", "", "createNextLinks", "", "size", "createPrevLinks", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] createNextLinks(int size) {
            int[] next = new int[size];
            for (int i = 0; i < size; ++i) {
                next[i] = i + 1;
            }
            next[size - 1] = 0;
            return next;
        }

        private final int[] createPrevLinks(int size) {
            int[] prev = new int[size];
            for (int i = 0; i < size; ++i) {
                prev[i] = i - 1;
            }
            prev[0] = size - 1;
            return prev;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

