/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.triangulate.quadedge.TrianglePredicate;
import org.locationtech.jts.triangulate.tri.Tri;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/triangulate/polygon/TriDelaunayImprover;", "", "triList", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "<init>", "(Ljava/util/List;)V", "improve", "", "improveScan", "", "improveNonDelaunay", "", "tri", "index", "Companion", "kts-core"})
public final class TriDelaunayImprover {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Tri> triList;
    private static final int MAX_ITERATION = 200;

    private TriDelaunayImprover(List<? extends Tri> triList) {
        this.triList = triList;
    }

    private final void improve() {
        for (int i = 0; i < 200; ++i) {
            int improveCount = this.improveScan(this.triList);
            if (improveCount != 0) continue;
            return;
        }
    }

    private final int improveScan(List<? extends Tri> triList) {
        int improveCount = 0;
        int n = triList.size() - 1;
        for (int i = 0; i < n; ++i) {
            Tri tri = triList.get(i);
            for (int j = 0; j < 3; ++j) {
                if (!this.improveNonDelaunay(tri, j)) continue;
                ++improveCount;
            }
        }
        return improveCount;
    }

    private final boolean improveNonDelaunay(Tri tri, int index) {
        Coordinate opp1;
        Coordinate opp0;
        Coordinate adj1;
        if (tri == null) {
            return false;
        }
        Tri tri2 = tri.getAdjacent(index);
        if (tri2 == null) {
            return false;
        }
        Tri tri1 = tri2;
        int index1 = tri1.getIndex(tri);
        Coordinate adj0 = tri.getCoordinate(index);
        if (!TriDelaunayImprover.Companion.isConvex(adj0, adj1 = tri.getCoordinate(Tri.Companion.next(index)), opp0 = tri.getCoordinate(Tri.Companion.oppVertex(index)), opp1 = tri1.getCoordinate(Tri.Companion.oppVertex(index1)))) {
            return false;
        }
        if (!TriDelaunayImprover.Companion.isDelaunay(adj0, adj1, opp0, opp1)) {
            tri.flip(index);
            return true;
        }
        return false;
    }

    public /* synthetic */ TriDelaunayImprover(List triList, DefaultConstructorMarker $constructor_marker) {
        this(triList);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/triangulate/polygon/TriDelaunayImprover$Companion;", "", "<init>", "()V", "improve", "", "triList", "", "Lorg/locationtech/jts/triangulate/tri/Tri;", "MAX_ITERATION", "", "isConvex", "", "adj0", "Lorg/locationtech/jts/geom/Coordinate;", "adj1", "opp0", "opp1", "isDelaunay", "isInCircle", "a", "b", "c", "p", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void improve(@NotNull List<? extends Tri> triList) {
            Intrinsics.checkNotNullParameter(triList, (String)"triList");
            TriDelaunayImprover improver = new TriDelaunayImprover(triList, null);
            improver.improve();
        }

        private final boolean isConvex(Coordinate adj0, Coordinate adj1, Coordinate opp0, Coordinate opp1) {
            int dir1;
            int dir0 = Orientation.index(opp0, adj0, opp1);
            return dir0 == (dir1 = Orientation.index(opp1, adj1, opp0));
        }

        private final boolean isDelaunay(Coordinate adj0, Coordinate adj1, Coordinate opp0, Coordinate opp1) {
            if (this.isInCircle(adj0, adj1, opp0, opp1)) {
                return false;
            }
            return !this.isInCircle(adj1, adj0, opp1, opp0);
        }

        private final boolean isInCircle(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
            return TrianglePredicate.INSTANCE.isInCircleRobust(a, c, b, p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

