/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.math.DD;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J&\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002J&\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J:\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011J&\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J&\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J*\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/TrianglePredicate;", "", "<init>", "()V", "isInCircleNonRobust", "", "a", "Lorg/locationtech/jts/geom/Coordinate;", "b", "c", "p", "isInCircleNormalized", "triArea", "", "isInCircleRobust", "isInCircleDDSlow", "triAreaDDSlow", "Lorg/locationtech/jts/math/DD;", "ax", "ay", "bx", "by", "cx", "cy", "isInCircleDDFast", "triAreaDDFast", "isInCircleDDNormalized", "isInCircleCC", "kts-core"})
public final class TrianglePredicate {
    @NotNull
    public static final TrianglePredicate INSTANCE = new TrianglePredicate();

    private TrianglePredicate() {
    }

    public final boolean isInCircleNonRobust(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c, @NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return (a.x * a.x + a.y * a.y) * this.triArea(b, c, p) - (b.x * b.x + b.y * b.y) * this.triArea(a, c, p) + (c.x * c.x + c.y * c.y) * this.triArea(a, b, p) - (p.x * p.x + p.y * p.y) * this.triArea(a, b, c) > 0.0;
    }

    public final boolean isInCircleNormalized(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c, @NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double adx = a.x - p.x;
        double ady = a.y - p.y;
        double bdx = b.x - p.x;
        double bdy = b.y - p.y;
        double cdx = c.x - p.x;
        double cdy = c.y - p.y;
        double abdet = adx * bdy - bdx * ady;
        double bcdet = bdx * cdy - cdx * bdy;
        double cadet = cdx * ady - adx * cdy;
        double alift = adx * adx + ady * ady;
        double blift = bdx * bdx + bdy * bdy;
        double clift = cdx * cdx + cdy * cdy;
        double disc = alift * bcdet + blift * cadet + clift * abdet;
        return disc > 0.0;
    }

    private final double triArea(Coordinate a, Coordinate b, Coordinate c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
    }

    public final boolean isInCircleRobust(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c, @NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.isInCircleNormalized(a, b, c, p);
    }

    public final boolean isInCircleDDSlow(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c, @NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DD px = DD.Companion.valueOf(p.x);
        DD py = DD.Companion.valueOf(p.y);
        DD ax = DD.Companion.valueOf(a.x);
        DD ay = DD.Companion.valueOf(a.y);
        DD bx = DD.Companion.valueOf(b.x);
        DD by = DD.Companion.valueOf(b.y);
        DD cx = DD.Companion.valueOf(c.x);
        DD cy = DD.Companion.valueOf(c.y);
        DD aTerm = ax.multiply(ax).add(ay.multiply(ay)).multiply(this.triAreaDDSlow(bx, by, cx, cy, px, py));
        DD bTerm = bx.multiply(bx).add(by.multiply(by)).multiply(this.triAreaDDSlow(ax, ay, cx, cy, px, py));
        DD cTerm = cx.multiply(cx).add(cy.multiply(cy)).multiply(this.triAreaDDSlow(ax, ay, bx, by, px, py));
        DD pTerm = px.multiply(px).add(py.multiply(py)).multiply(this.triAreaDDSlow(ax, ay, bx, by, cx, cy));
        DD sum = aTerm.subtract(bTerm).add(cTerm).subtract(pTerm);
        return sum.doubleValue() > 0.0;
    }

    @NotNull
    public final DD triAreaDDSlow(@Nullable DD ax, @Nullable DD ay, @NotNull DD bx, @NotNull DD by, @NotNull DD cx, @NotNull DD cy) {
        Intrinsics.checkNotNullParameter((Object)bx, (String)"bx");
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        Intrinsics.checkNotNullParameter((Object)cy, (String)"cy");
        DD dD = ax;
        Intrinsics.checkNotNull((Object)dD);
        DD dD2 = bx.subtract(dD);
        DD dD3 = ay;
        Intrinsics.checkNotNull((Object)dD3);
        return dD2.multiply(cy.subtract(dD3)).subtract(by.subtract(ay).multiply(cx.subtract(ax)));
    }

    public final boolean isInCircleDDFast(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c, @NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DD aTerm = DD.Companion.sqr(a.x).selfAdd(DD.Companion.sqr(a.y)).selfMultiply(this.triAreaDDFast(b, c, p));
        DD bTerm = DD.Companion.sqr(b.x).selfAdd(DD.Companion.sqr(b.y)).selfMultiply(this.triAreaDDFast(a, c, p));
        DD cTerm = DD.Companion.sqr(c.x).selfAdd(DD.Companion.sqr(c.y)).selfMultiply(this.triAreaDDFast(a, b, p));
        DD pTerm = DD.Companion.sqr(p.x).selfAdd(DD.Companion.sqr(p.y)).selfMultiply(this.triAreaDDFast(a, b, c));
        DD sum = aTerm.selfSubtract(bTerm).selfAdd(cTerm).selfSubtract(pTerm);
        return sum.doubleValue() > 0.0;
    }

    @NotNull
    public final DD triAreaDDFast(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        DD t1 = DD.Companion.valueOf(b.x).selfSubtract(a.x).selfMultiply(DD.Companion.valueOf(c.y).selfSubtract(a.y));
        DD t2 = DD.Companion.valueOf(b.y).selfSubtract(a.y).selfMultiply(DD.Companion.valueOf(c.x).selfSubtract(a.x));
        return t1.selfSubtract(t2);
    }

    public final boolean isInCircleDDNormalized(@NotNull Coordinate a, @NotNull Coordinate b, @NotNull Coordinate c, @NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DD adx = DD.Companion.valueOf(a.x).selfSubtract(p.x);
        DD ady = DD.Companion.valueOf(a.y).selfSubtract(p.y);
        DD bdx = DD.Companion.valueOf(b.x).selfSubtract(p.x);
        DD bdy = DD.Companion.valueOf(b.y).selfSubtract(p.y);
        DD cdx = DD.Companion.valueOf(c.x).selfSubtract(p.x);
        DD cdy = DD.Companion.valueOf(c.y).selfSubtract(p.y);
        DD abdet = adx.multiply(bdy).selfSubtract(bdx.multiply(ady));
        DD bcdet = bdx.multiply(cdy).selfSubtract(cdx.multiply(bdy));
        DD cadet = cdx.multiply(ady).selfSubtract(adx.multiply(cdy));
        DD alift = adx.multiply(adx).selfAdd(ady.multiply(ady));
        DD blift = bdx.multiply(bdx).selfAdd(bdy.multiply(bdy));
        DD clift = cdx.multiply(cdx).selfAdd(cdy.multiply(cdy));
        DD sum = alift.selfMultiply(bcdet).selfAdd(blift.selfMultiply(cadet)).selfAdd(clift.selfMultiply(abdet));
        return sum.doubleValue() > 0.0;
    }

    public final boolean isInCircleCC(@NotNull Coordinate a, @Nullable Coordinate b, @Nullable Coordinate c, @NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Coordinate coordinate = b;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = c;
        Intrinsics.checkNotNull((Object)coordinate2);
        Coordinate cc = Triangle.Companion.circumcentre(a, coordinate, coordinate2);
        double ccRadius = a.distance(cc);
        double pRadiusDiff = p.distance(cc) - ccRadius;
        return pRadiusDiff <= 0.0;
    }
}

