/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0011J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0011R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/util/StringUtil;", "", "<init>", "()V", "split", "", "", "s", "separator", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "NEWLINE", "getNEWLINE", "()Ljava/lang/String;", "getStackTrace", "t", "", "depth", "", "toString", "d", "", "spaces", "n", "chars", "c", "", "kts-core"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();
    @NotNull
    private static final String NEWLINE;

    private StringUtil() {
    }

    @NotNull
    public final String[] split(@NotNull String s, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        int separatorlen = separator.length();
        ArrayList<Object> tokenList = new ArrayList<Object>();
        String tmpString = s;
        int pos = StringsKt.indexOf$default((CharSequence)tmpString, (String)separator, (int)0, (boolean)false, (int)6, null);
        while (pos >= 0) {
            String token;
            Intrinsics.checkNotNullExpressionValue((Object)tmpString.substring(0, pos), (String)"substring(...)");
            tokenList.add(token);
            Intrinsics.checkNotNullExpressionValue((Object)tmpString.substring(pos + separatorlen), (String)"substring(...)");
            pos = StringsKt.indexOf$default((CharSequence)tmpString, (String)separator, (int)0, (boolean)false, (int)6, null);
        }
        if (tmpString.length() > 0) {
            tokenList.add(tmpString);
        }
        String[] res = new String[tokenList.size()];
        int n = res.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull(tokenList.get(i), (String)"null cannot be cast to non-null type kotlin.String");
        }
        return res;
    }

    @NotNull
    public final String getNEWLINE() {
        return NEWLINE;
    }

    @JvmStatic
    @NotNull
    public static final String getStackTrace(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        String string = os.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getStackTrace(@NotNull Throwable t, int depth) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Object stackTrace = "";
        StringReader stringReader = new StringReader(StringUtil.getStackTrace(t));
        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
        for (int i = 0; i < depth; ++i) {
            try {
                stackTrace = (String)stackTrace + lineNumberReader.readLine() + NEWLINE;
                continue;
            }
            catch (IOException e) {
                Assert.shouldNeverReachHere$default(null, 1, null);
            }
        }
        return stackTrace;
    }

    @Deprecated(message="use {@link OrdinateFormat}")
    @NotNull
    public final String toString(double d) {
        return OrdinateFormat.DEFAULT.format(d);
    }

    @NotNull
    public final String spaces(int n) {
        return this.chars(' ', n);
    }

    @NotNull
    public final String chars(char c, int n) {
        char[] ch = new char[n];
        for (int i = 0; i < n; ++i) {
            ch[i] = c;
        }
        return StringsKt.concatToString((char[])ch);
    }

    static {
        String string = System.getProperty("line.separator");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        NEWLINE = string;
    }
}

