/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.collection;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B5\b\u0016\u0012\"\u0010\b\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\tj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0004`\n\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u001b\u001a\u00020\u0004J#\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010!\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\"J%\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000%\"\u00028\u0000\u00a2\u0006\u0002\u0010&R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\tj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0004`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/macrofocus/common/collection/ObjectIntMap;", "K", "", "initialCapacity", "", "noEntryValue", "<init>", "(II)V", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "(Ljava/util/HashMap;I)V", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)I", "isEmpty", "()Z", "put", "(Ljava/lang/Object;I)I", "remove", "size", "adjustOrPutValue", "adjust_amount", "put_amount", "(Ljava/lang/Object;II)I", "adjustValue", "amount", "(Ljava/lang/Object;I)Z", "copy", "keysToRemove", "", "([Ljava/lang/Object;)Lcom/macrofocus/common/collection/ObjectIntMap;", "macrofocus-common"})
public final class ObjectIntMap<K> {
    @NotNull
    private final HashMap<K, Integer> map;
    private final int noEntryValue;

    public ObjectIntMap(int initialCapacity, int noEntryValue) {
        this.noEntryValue = noEntryValue;
        this.map = new HashMap(initialCapacity);
    }

    public ObjectIntMap(@NotNull HashMap<K, Integer> map, int noEntryValue) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.map = map;
        this.noEntryValue = noEntryValue;
    }

    public final void clear() {
        this.map.clear();
    }

    public final boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public final boolean containsValue(int value) {
        return this.map.containsValue(value);
    }

    public final int get(K key) {
        Integer value;
        Integer n = value = this.map.get(key);
        return n != null ? n : this.noEntryValue;
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final int put(K key, int value) {
        Integer put;
        Integer n = put = this.map.put(key, value);
        return n != null ? n : this.noEntryValue;
    }

    public final int remove(K key) {
        Integer n = this.map.remove(key);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    public final int size() {
        return this.map.size();
    }

    public final int adjustOrPutValue(K key, int adjust_amount, int put_amount) {
        int n;
        if (this.map.containsKey(key)) {
            Integer n2 = this.map.get(key);
            Intrinsics.checkNotNull((Object)n2);
            int value = ((Number)n2).intValue();
            int adjustedValue = value + adjust_amount;
            this.map.put(key, adjustedValue);
            n = adjustedValue;
        } else {
            this.map.put(key, put_amount);
            n = put_amount;
        }
        return n;
    }

    public final boolean adjustValue(K key, int amount) {
        boolean bl;
        if (this.map.containsKey(key)) {
            Integer n = this.map.get(key);
            Intrinsics.checkNotNull((Object)n);
            int value = ((Number)n).intValue();
            this.map.put(key, value + amount);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final ObjectIntMap<K> copy(K ... keysToRemove) {
        Intrinsics.checkNotNullParameter(keysToRemove, (String)"keysToRemove");
        ObjectIntMap<K> map = new ObjectIntMap<K>(new HashMap(this.map), this.noEntryValue);
        for (K k : keysToRemove) {
            map.remove(k);
        }
        return map;
    }
}

