/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.json;

import com.macrofocus.common.json.JsonArray;
import com.macrofocus.common.json.JsonContext;
import com.macrofocus.common.json.JsonObject;
import com.macrofocus.common.json.JsonString;
import com.macrofocus.common.json.JsonType;
import com.macrofocus.common.json.JsonUtil;
import com.macrofocus.common.json.JsonValue;
import com.macrofocus.common.json.JsonVisitor;
import java.io.IOException;
import java.io.ObjectOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/macrofocus/common/json/JvmJsonString;", "Lcom/macrofocus/common/json/JsonString;", "string", "", "<init>", "(Ljava/lang/String;)V", "getString", "()Ljava/lang/String;", "setString", "asBoolean", "", "asNumber", "", "asString", "asJsonArray", "Lcom/macrofocus/common/json/JsonArray;", "asJsonObject", "Lcom/macrofocus/common/json/JsonObject;", "object", "", "getObject", "()Ljava/lang/Object;", "type", "Lcom/macrofocus/common/json/JsonType;", "getType", "()Lcom/macrofocus/common/json/JsonType;", "jsEquals", "value", "Lcom/macrofocus/common/json/JsonValue;", "toNative", "traverse", "", "visitor", "Lcom/macrofocus/common/json/JsonVisitor;", "ctx", "Lcom/macrofocus/common/json/JsonContext;", "toJson", "writeObject", "stream", "Ljava/io/ObjectOutputStream;", "Companion", "macrofocus-common"})
public final class JvmJsonString
implements JsonString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String string;
    private static final long serialVersionUID = 1L;

    public JvmJsonString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.string = string;
    }

    @Override
    @NotNull
    public String getString() {
        return this.string;
    }

    public void setString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.string = string;
    }

    @Override
    public boolean asBoolean() {
        return !(((CharSequence)this.getString()).length() == 0);
    }

    @Override
    public double asNumber() {
        double d;
        try {
            double d2;
            String string = this.asString();
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() == 0) {
                d2 = 0.0;
            } else {
                String string2 = this.asString();
                Intrinsics.checkNotNull((Object)string2);
                d2 = Double.parseDouble(string2);
            }
            d = d2;
        }
        catch (NumberFormatException nfe) {
            d = Double.NaN;
        }
        return d;
    }

    @Override
    @Nullable
    public String asString() {
        return this.getString();
    }

    @Override
    @Nullable
    public JsonArray asJsonArray() {
        return null;
    }

    @Override
    @Nullable
    public JsonObject asJsonObject() {
        return null;
    }

    @Override
    @NotNull
    public Object getObject() {
        return this.getString();
    }

    @Override
    @NotNull
    public JsonType getType() {
        return JsonType.STRING;
    }

    @Override
    public boolean jsEquals(@Nullable JsonValue value) {
        Object object = this.getObject();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.macrofocus.common.json.JsonValue");
        return Intrinsics.areEqual((Object)object, (Object)value.getObject());
    }

    @Override
    @Nullable
    public Object toNative() {
        return this;
    }

    @Override
    public void traverse(@NotNull JsonVisitor visitor, @NotNull JsonContext ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        visitor.visit(this.getString(), ctx);
    }

    @Override
    @NotNull
    public String toJson() throws IllegalStateException {
        return JsonUtil.INSTANCE.quote(this.getString());
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/macrofocus/common/json/JvmJsonString$Companion;", "", "<init>", "()V", "serialVersionUID", "", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

