/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.math;

import com.macrofocus.common.math.Float3;
import com.macrofocus.common.math.MatrixColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\u0019\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0017H\u0086\u0002J\u0019\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0014H\u0086\u0002J\u0019\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J!\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0015H\u0086\u0002J\u0019\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J!\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0015H\u0086\u0002J\t\u0010\u001c\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001d\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0015H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0015H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0015H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0015H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010#\u001a\u00020$J\n\u0010%\u001a\u00020&H\u0096\u0080\u0004J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J'\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010.\u001a\u00020\u0014H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\r\u00a8\u00060"}, d2={"Lcom/macrofocus/common/math/Mat3;", "", "x", "Lcom/macrofocus/common/math/Float3;", "y", "z", "<init>", "(Lcom/macrofocus/common/math/Float3;Lcom/macrofocus/common/math/Float3;Lcom/macrofocus/common/math/Float3;)V", "m", "(Lcom/macrofocus/common/math/Mat3;)V", "getX", "()Lcom/macrofocus/common/math/Float3;", "setX", "(Lcom/macrofocus/common/math/Float3;)V", "getY", "setY", "getZ", "setZ", "get", "column", "", "", "row", "Lcom/macrofocus/common/math/MatrixColumn;", "invoke", "", "v", "set", "unaryMinus", "inc", "dec", "plus", "minus", "times", "div", "toFloatArray", "", "toString", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "Companion", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/Mat3\n+ 2 Vector.kt\ncom/macrofocus/common/math/Float3\n*L\n1#1,559:1\n215#2,4:560\n308#2:564\n309#2:565\n310#2:566\n311#2:567\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\ncom/macrofocus/common/math/Mat3\n*L\n155#1:560,4\n175#1:564\n176#1:565\n177#1:566\n178#1:567\n*E\n"})
public final class Mat3 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Float3 x;
    @NotNull
    private Float3 y;
    @NotNull
    private Float3 z;

    public Mat3(@NotNull Float3 x, @NotNull Float3 y, @NotNull Float3 z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public /* synthetic */ Mat3(Float3 float3, Float3 float32, Float3 float33, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            float3 = new Float3(1.0f, 0.0f, 0.0f, 6, null);
        }
        if ((n & 2) != 0) {
            float32 = new Float3(0.0f, 1.0f, 0.0f, 5, null);
        }
        if ((n & 4) != 0) {
            float33 = new Float3(0.0f, 0.0f, 1.0f, 3, null);
        }
        this(float3, float32, float33);
    }

    @NotNull
    public final Float3 getX() {
        return this.x;
    }

    public final void setX(@NotNull Float3 float3) {
        Intrinsics.checkNotNullParameter((Object)float3, (String)"<set-?>");
        this.x = float3;
    }

    @NotNull
    public final Float3 getY() {
        return this.y;
    }

    public final void setY(@NotNull Float3 float3) {
        Intrinsics.checkNotNullParameter((Object)float3, (String)"<set-?>");
        this.y = float3;
    }

    @NotNull
    public final Float3 getZ() {
        return this.z;
    }

    public final void setZ(@NotNull Float3 float3) {
        Intrinsics.checkNotNullParameter((Object)float3, (String)"<set-?>");
        this.z = float3;
    }

    public Mat3(@NotNull Mat3 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this(Float3.copy$default(m.x, 0.0f, 0.0f, 0.0f, 7, null), Float3.copy$default(m.y, 0.0f, 0.0f, 0.0f, 7, null), Float3.copy$default(m.z, 0.0f, 0.0f, 0.0f, 7, null));
    }

    @NotNull
    public final Float3 get(int column) {
        return switch (column) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new IllegalArgumentException("column must be in 0..2");
        };
    }

    public final float get(int column, int row) {
        return this.get(column).get(row);
    }

    @NotNull
    public final Float3 get(@NotNull MatrixColumn column) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return switch (WhenMappings.$EnumSwitchMapping$0[column.ordinal()]) {
            case 1 -> this.x;
            case 2 -> this.y;
            case 3 -> this.z;
            default -> throw new IllegalArgumentException("column must be X, Y or Z");
        };
    }

    public final float get(@NotNull MatrixColumn column, int row) {
        Intrinsics.checkNotNullParameter((Object)((Object)column), (String)"column");
        return this.get(column).get(row);
    }

    public final float invoke(int row, int column) {
        return this.get(column - 1).get(row - 1);
    }

    public final void invoke(int row, int column, float v) {
        this.set(column - 1, row - 1, v);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int column, @NotNull Float3 v) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Float3 float3 = this.get(column);
        Float3 value$iv = v;
        boolean $i$f$setXyz = false;
        this_$iv.setX(value$iv.getX());
        this_$iv.setY(value$iv.getY());
        this_$iv.setZ(value$iv.getZ());
    }

    public final void set(int column, int row, float v) {
        this.get(column).set(row, v);
    }

    @NotNull
    public final Mat3 unaryMinus() {
        return new Mat3(this.x.unaryMinus(), this.y.unaryMinus(), this.z.unaryMinus());
    }

    @NotNull
    public final Mat3 inc() {
        Float3 float3 = this.x;
        this.x = float3.inc();
        float3 = this.y;
        this.y = float3.inc();
        float3 = this.z;
        this.z = float3.inc();
        return this;
    }

    @NotNull
    public final Mat3 dec() {
        Float3 float3 = this.x;
        this.x = float3.dec();
        float3 = this.y;
        this.y = float3.dec();
        float3 = this.z;
        this.z = float3.dec();
        return this;
    }

    @NotNull
    public final Mat3 plus(float v) {
        Float3 this_$iv;
        Float3 float3 = this.x;
        float v$iv = v;
        boolean $i$f$plus = false;
        Float3 float32 = new Float3(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv, this_$iv.getZ() + v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$plus = false;
        Float3 float33 = new Float3(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv, this_$iv.getZ() + v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$plus = false;
        return new Mat3(float32, float33, new Float3(this_$iv.getX() + v$iv, this_$iv.getY() + v$iv, this_$iv.getZ() + v$iv));
    }

    @NotNull
    public final Mat3 minus(float v) {
        Float3 this_$iv;
        Float3 float3 = this.x;
        float v$iv = v;
        boolean $i$f$minus = false;
        Float3 float32 = new Float3(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv, this_$iv.getZ() - v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$minus = false;
        Float3 float33 = new Float3(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv, this_$iv.getZ() - v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$minus = false;
        return new Mat3(float32, float33, new Float3(this_$iv.getX() - v$iv, this_$iv.getY() - v$iv, this_$iv.getZ() - v$iv));
    }

    @NotNull
    public final Mat3 times(float v) {
        Float3 this_$iv;
        Float3 float3 = this.x;
        float v$iv = v;
        boolean $i$f$times = false;
        Float3 float32 = new Float3(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$times = false;
        Float3 float33 = new Float3(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$times = false;
        return new Mat3(float32, float33, new Float3(this_$iv.getX() * v$iv, this_$iv.getY() * v$iv, this_$iv.getZ() * v$iv));
    }

    @NotNull
    public final Mat3 div(float v) {
        Float3 this_$iv;
        Float3 float3 = this.x;
        float v$iv = v;
        boolean $i$f$div = false;
        Float3 float32 = new Float3(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv, this_$iv.getZ() / v$iv);
        this_$iv = this.y;
        v$iv = v;
        $i$f$div = false;
        Float3 float33 = new Float3(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv, this_$iv.getZ() / v$iv);
        this_$iv = this.z;
        v$iv = v;
        $i$f$div = false;
        return new Mat3(float32, float33, new Float3(this_$iv.getX() / v$iv, this_$iv.getY() / v$iv, this_$iv.getZ() / v$iv));
    }

    @NotNull
    public final Mat3 times(@NotNull Mat3 m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return new Mat3(new Float3(this.x.getX() * m.x.getX() + this.y.getX() * m.x.getY() + this.z.getX() * m.x.getZ(), this.x.getY() * m.x.getX() + this.y.getY() * m.x.getY() + this.z.getY() * m.x.getZ(), this.x.getZ() * m.x.getX() + this.y.getZ() * m.x.getY() + this.z.getZ() * m.x.getZ()), new Float3(this.x.getX() * m.y.getX() + this.y.getX() * m.y.getY() + this.z.getX() * m.y.getZ(), this.x.getY() * m.y.getX() + this.y.getY() * m.y.getY() + this.z.getY() * m.y.getZ(), this.x.getZ() * m.y.getX() + this.y.getZ() * m.y.getY() + this.z.getZ() * m.y.getZ()), new Float3(this.x.getX() * m.z.getX() + this.y.getX() * m.z.getY() + this.z.getX() * m.z.getZ(), this.x.getY() * m.z.getX() + this.y.getY() * m.z.getY() + this.z.getY() * m.z.getZ(), this.x.getZ() * m.z.getX() + this.y.getZ() * m.z.getY() + this.z.getZ() * m.z.getZ()));
    }

    @NotNull
    public final Float3 times(@NotNull Float3 v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Float3(this.x.getX() * v.getX() + this.y.getX() * v.getY() + this.z.getX() * v.getZ(), this.x.getY() * v.getX() + this.y.getY() * v.getY() + this.z.getY() * v.getZ(), this.x.getZ() * v.getX() + this.y.getZ() * v.getY() + this.z.getZ() * v.getZ());
    }

    @NotNull
    public final float[] toFloatArray() {
        float[] fArray = new float[]{this.x.getX(), this.y.getX(), this.z.getX(), this.x.getY(), this.y.getY(), this.z.getY(), this.x.getZ(), this.y.getZ(), this.z.getZ()};
        return fArray;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            |" + this.x.getX() + " " + this.y.getX() + " " + this.z.getX() + "|\n            |" + this.x.getY() + " " + this.y.getY() + " " + this.z.getY() + "|\n            |" + this.x.getZ() + " " + this.y.getZ() + " " + this.z.getZ() + "|\n            "));
    }

    @NotNull
    public final Float3 component1() {
        return this.x;
    }

    @NotNull
    public final Float3 component2() {
        return this.y;
    }

    @NotNull
    public final Float3 component3() {
        return this.z;
    }

    @NotNull
    public final Mat3 copy(@NotNull Float3 x, @NotNull Float3 y, @NotNull Float3 z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return new Mat3(x, y, z);
    }

    public static /* synthetic */ Mat3 copy$default(Mat3 mat3, Float3 float3, Float3 float32, Float3 float33, int n, Object object) {
        if ((n & 1) != 0) {
            float3 = mat3.x;
        }
        if ((n & 2) != 0) {
            float32 = mat3.y;
        }
        if ((n & 4) != 0) {
            float33 = mat3.z;
        }
        return mat3.copy(float3, float32, float33);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = result * 31 + this.y.hashCode();
        result = result * 31 + this.z.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mat3)) {
            return false;
        }
        Mat3 mat3 = (Mat3)other;
        if (!Intrinsics.areEqual((Object)this.x, (Object)mat3.x)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.y, (Object)mat3.y)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.z, (Object)mat3.z);
    }

    public Mat3() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00020\u0007\"\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/macrofocus/common/math/Mat3$Companion;", "", "<init>", "()V", "of", "Lcom/macrofocus/common/math/Mat3;", "a", "", "", "identity", "macrofocus-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Mat3 of(float ... a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (!(a.length >= 9)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Mat3(new Float3(a[0], a[3], a[6]), new Float3(a[1], a[4], a[7]), new Float3(a[2], a[5], a[8]));
        }

        @NotNull
        public final Mat3 identity() {
            return new Mat3(null, null, null, 7, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatrixColumn.values().length];
            try {
                nArray[MatrixColumn.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MatrixColumn.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

