/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.selection;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.AbstractMutableSingleSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0017\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010\u0013\u001a\u00020\tH\u0016J)\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0019\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00020\u00102\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0019\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u0015\u0010!\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0096\u0082\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR(\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\r\u001a\u0004\u0018\u00018\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010\u0011R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lcom/macrofocus/common/selection/PropertySingleSelection;", "E", "Lcom/macrofocus/common/selection/AbstractMutableSingleSelection;", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "property", "Lcom/macrofocus/common/properties/MutableProperty;", "<init>", "(Lcom/macrofocus/common/properties/MutableProperty;)V", "clearSelection", "", "isActive", "()Z", "isSelected", "element", "(Ljava/lang/Object;)Z", "setSelectedElement", "", "(Ljava/lang/Object;)V", "setSelectedState", "selected", "(Ljava/lang/Object;Z)V", "setSelectedIterableState", "", "setSelectedElementsState", "elements", "", "(Z[Ljava/lang/Object;)Z", "setSelectedElements", "([Ljava/lang/Object;)V", "setSelectedIterable", "getSelected", "()Ljava/lang/Object;", "setSelected", "setSelectedOrNull", "selectedCount", "", "getSelectedCount", "()I", "selectedSet", "", "getSelectedSet", "()Ljava/util/Set;", "iterator", "", "macrofocus-common"})
public final class PropertySingleSelection<E>
extends AbstractMutableSingleSelection<E>
implements MutableSingleSelection<E> {
    @NotNull
    private final MutableProperty<E> property;

    public PropertySingleSelection(@NotNull MutableProperty<E> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this.property = property;
        final MutableSingleSelection self = this;
        this.property.addPropertyListener(new PropertyListener<E>(){

            @Override
            public void propertyChanged(PropertyEvent<E> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.notifySingleSelectedChanged(new SingleSelectionEvent(self, event.getOldValue() != null, event.getNewValue() != null, event.getOldValue(), event.getNewValue()));
            }
        });
    }

    @Override
    public boolean clearSelection() {
        boolean bl;
        if (this.isEnabled() && this.isActive()) {
            this.setSelectedOrNull(null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isActive() {
        return this.getSelected() != null && this.isEnabled();
    }

    @Override
    public boolean isSelected(@Nullable E element) {
        return Intrinsics.areEqual(this.property.getValue(), element);
    }

    @Override
    public void setSelectedElement(E element) {
        this.setSelected(element);
    }

    @Override
    public void setSelectedState(E element, boolean selected2) {
        if (this.isEnabled()) {
            if (selected2) {
                this.setSelected(element);
            } else if (this.isSelected(element)) {
                this.clearSelection();
            }
        }
    }

    @Override
    public boolean setSelectedIterableState(@NotNull Iterable<? extends E> element, boolean selected2) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setSelectedElementsState(boolean selected2, E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedElements(E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedIterable(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public E getSelected() {
        return this.property.getValue();
    }

    @Override
    public void setSelected(@Nullable E element) {
        this.setSelectedOrNull(element);
    }

    public final void setSelectedOrNull(@Nullable E element) {
        if (this.isEnabled() && this.getSelected() != element) {
            E previousSelected = this.getSelected();
            boolean previousActive = previousSelected != null;
            E e = element;
            Intrinsics.checkNotNull(e);
            this.property.setValue(e);
            this.notifySingleSelectedChanged(new SingleSelectionEvent<E>(this, previousActive, true, previousSelected, element));
        }
    }

    @Override
    public int getSelectedCount() {
        return this.isActive() ? 1 : 0;
    }

    @Override
    @NotNull
    public Set<E> getSelectedSet() {
        Set set;
        if (this.isActive()) {
            E e = this.getSelected();
            Intrinsics.checkNotNull(e);
            set = SetsKt.setOf(e);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(this){
            private boolean fetched;
            final /* synthetic */ PropertySingleSelection<E> this$0;
            {
                this.this$0 = $receiver;
                this.fetched = $receiver.isActive();
            }

            public final boolean getFetched() {
                return this.fetched;
            }

            public final void setFetched(boolean bl) {
                this.fetched = bl;
            }

            public boolean hasNext() {
                return !this.fetched;
            }

            public E next() {
                this.fetched = true;
                E e = this.this$0.getSelected();
                Intrinsics.checkNotNull(e);
                return e;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }
}

