/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.dom;

import com.macrofocus.dom.Writer;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/macrofocus/dom/AppendableWriter;", "Lcom/macrofocus/dom/Writer;", "", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "prettyPrint", "", "prettyPrintIndent", "", "<init>", "(Ljava/lang/Appendable;ZI)V", "tags", "Lkotlin/collections/ArrayDeque;", "hasChildren", "level", "indent", "newline", "beginElement", "", "tag", "namespace", "endElement", "writeAttribute", "name", "value", "result", "writeText", "text", "macrofocus-common"})
public final class AppendableWriter
implements Writer<String> {
    @NotNull
    private final Appendable appendable;
    private final boolean prettyPrint;
    private final int prettyPrintIndent;
    @NotNull
    private final ArrayDeque<String> tags;
    @NotNull
    private final ArrayDeque<Boolean> hasChildren;
    private int level;
    @NotNull
    private final String indent;
    @NotNull
    private final String newline;

    public AppendableWriter(@NotNull Appendable appendable, boolean prettyPrint, int prettyPrintIndent) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        this.appendable = appendable;
        this.prettyPrint = prettyPrint;
        this.prettyPrintIndent = prettyPrintIndent;
        this.tags = new ArrayDeque();
        this.hasChildren = new ArrayDeque();
        this.indent = this.prettyPrint ? StringsKt.repeat((CharSequence)" ", (int)this.prettyPrintIndent) : "";
        this.newline = this.prettyPrint ? "\n" : "";
    }

    @Override
    public void beginElement(@NotNull String tag, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!this.hasChildren.isEmpty()) {
            boolean currentHasChildren = (Boolean)this.hasChildren.removeFirst();
            if (!currentHasChildren) {
                this.appendable.append(">" + this.newline);
            }
            this.hasChildren.addFirst((Object)true);
        }
        ++this.level;
        this.appendable.append(this.indent() + "<" + tag);
        this.tags.addFirst((Object)tag);
        this.hasChildren.addFirst((Object)false);
    }

    @Override
    public void endElement() {
        String tag = (String)this.tags.removeFirst();
        Appendable appendable = (Boolean)this.hasChildren.removeFirst() == true ? this.appendable.append(this.indent() + "</" + tag + ">" + this.newline) : this.appendable.append(" />" + this.newline);
        --this.level;
    }

    @Override
    public void writeAttribute(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.appendable.append(" " + name + "=\"" + value + "\"");
    }

    @Override
    @NotNull
    public String result() {
        return this.appendable.toString();
    }

    @Override
    public void writeText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.appendable.append(text);
    }

    private final String indent() {
        return StringsKt.repeat((CharSequence)this.indent, (int)(this.level - 1));
    }
}

