/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.hierarchy;

import com.macrofocus.hierarchy.Hierarchy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u0013\u0014B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\r\u001a\u00020\u000eH\u0096\u0082\u0004J\u000f\u0010\u000f\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/macrofocus/hierarchy/BreadthFirstIterator;", "T", "", "hierarchy", "Lcom/macrofocus/hierarchy/Hierarchy;", "rootNode", "<init>", "(Lcom/macrofocus/hierarchy/Hierarchy;Ljava/lang/Object;)V", "queue", "Lcom/macrofocus/hierarchy/BreadthFirstIterator$Queue;", "", "getQueue", "()Lcom/macrofocus/hierarchy/BreadthFirstIterator$Queue;", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "Queue", "QNode", "macrofocus-common"})
public final class BreadthFirstIterator<T>
implements Iterator<T>,
KMutableIterator {
    @NotNull
    private final Hierarchy<T> hierarchy;
    @NotNull
    private final Queue<Iterator<T>> queue;

    public BreadthFirstIterator(@NotNull Hierarchy<T> hierarchy, T rootNode) {
        Intrinsics.checkNotNullParameter(hierarchy, (String)"hierarchy");
        this.hierarchy = hierarchy;
        List v = new ArrayList(1);
        v.add(rootNode);
        this.queue = new Queue();
        this.queue.enqueue(v.iterator());
    }

    @NotNull
    protected final Queue<Iterator<T>> getQueue() {
        return this.queue;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty() && this.queue.firstObject().hasNext();
    }

    @Override
    public T next() {
        Iterator<T> enumer = this.queue.firstObject();
        T node = enumer.next();
        Iterable<T> iterable = this.hierarchy.getChildren(node);
        Intrinsics.checkNotNull(iterable);
        Iterator<T> children = iterable.iterator();
        if (!enumer.hasNext()) {
            this.queue.dequeue();
        }
        if (children.hasNext()) {
            this.queue.enqueue(children);
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0080\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR,\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/hierarchy/BreadthFirstIterator$QNode;", "O", "", "object", "next", "Lcom/macrofocus/hierarchy/BreadthFirstIterator;", "<init>", "(Lcom/macrofocus/hierarchy/BreadthFirstIterator;Ljava/lang/Object;Lcom/macrofocus/hierarchy/BreadthFirstIterator$QNode;)V", "getObject", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getNext", "()Lcom/macrofocus/hierarchy/BreadthFirstIterator$QNode;", "setNext", "(Lcom/macrofocus/hierarchy/BreadthFirstIterator$QNode;)V", "macrofocus-common"})
    public final class QNode<O> {
        private final O object;
        @Nullable
        private QNode<O> next;

        public QNode(@Nullable O object, QNode<O> next) {
            this.object = object;
            this.next = next;
        }

        public final O getObject() {
            return this.object;
        }

        @Nullable
        public final QNode<O> getNext() {
            return this.next;
        }

        public final void setNext(@Nullable QNode<O> qNode) {
            this.next = qNode;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0012J\u000b\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0014J\u000b\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0014R,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR,\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/hierarchy/BreadthFirstIterator$Queue;", "O", "", "<init>", "(Lcom/macrofocus/hierarchy/BreadthFirstIterator;)V", "head", "Lcom/macrofocus/hierarchy/BreadthFirstIterator$QNode;", "Lcom/macrofocus/hierarchy/BreadthFirstIterator;", "getHead", "()Lcom/macrofocus/hierarchy/BreadthFirstIterator$QNode;", "setHead", "(Lcom/macrofocus/hierarchy/BreadthFirstIterator$QNode;)V", "tail", "getTail", "setTail", "enqueue", "", "anObject", "(Ljava/lang/Object;)V", "dequeue", "()Ljava/lang/Object;", "firstObject", "isEmpty", "", "()Z", "macrofocus-common"})
    public final class Queue<O> {
        @Nullable
        private QNode<O> head;
        @Nullable
        private QNode<O> tail;

        @Nullable
        public final QNode<O> getHead() {
            return this.head;
        }

        public final void setHead(@Nullable QNode<O> qNode) {
            this.head = qNode;
        }

        @Nullable
        public final QNode<O> getTail() {
            return this.tail;
        }

        public final void setTail(@Nullable QNode<O> qNode) {
            this.tail = qNode;
        }

        public final void enqueue(O anObject) {
            if (this.head == null) {
                this.tail = new QNode<O>(anObject, null);
                this.head = this.tail;
            } else {
                QNode<O> qNode = this.tail;
                Intrinsics.checkNotNull(qNode);
                qNode.setNext(new QNode<O>(anObject, null));
                QNode<O> qNode2 = this.tail;
                Intrinsics.checkNotNull(qNode2);
                this.tail = qNode2.getNext();
            }
        }

        public final O dequeue() {
            if (this.head == null) {
                throw new NoSuchElementException("No more elements");
            }
            QNode<O> qNode = this.head;
            Intrinsics.checkNotNull(qNode);
            O retval = qNode.getObject();
            QNode qNode2 = this.head;
            Intrinsics.checkNotNull(qNode2);
            QNode oldHead = qNode2;
            QNode<O> qNode3 = this.head;
            Intrinsics.checkNotNull(qNode3);
            this.head = qNode3.getNext();
            if (this.head == null) {
                this.tail = null;
            } else {
                oldHead.setNext(null);
            }
            return retval;
        }

        public final O firstObject() {
            if (this.head == null) {
                throw new NoSuchElementException("No more elements");
            }
            QNode<O> qNode = this.head;
            Intrinsics.checkNotNull(qNode);
            return qNode.getObject();
        }

        public final boolean isEmpty() {
            return this.head == null;
        }
    }
}

