/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.aggregation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000e\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0007\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation;", "T", "Lorg/molap/aggregates/aggregation/Aggregation;", "<init>", "()V", "as", "name", "", "getName", "()Ljava/lang/String;", "add", "", "aggregation", "substract", "multiply", "divide", "min", "max", "TwoAggregation", "AddAggregation", "SubstractAggregation", "MultiplyAggregation", "DivideAggregation", "MinAggregation", "MaxAggregation", "molap"})
public abstract class AbstractAggregation<T>
implements Aggregation<T> {
    @Override
    @NotNull
    public Aggregation<T> as(@Nullable String name) {
        return new AbstractAggregation<T>(name, this){
            final /* synthetic */ String $name;
            final /* synthetic */ AbstractAggregation<T> this$0;
            {
                this.$name = $name;
                this.this$0 = $receiver;
            }

            public String getName() {
                return this.$name;
            }

            public KClass<Object> getType() {
                return Reflection.getOrCreateKotlinClass(this.this$0.getClass());
            }

            public T compute(Cuboid cuboid, Group group) {
                return this.compute(cuboid, group);
            }
        };
    }

    @Override
    @Nullable
    public String getName() {
        return this.toString();
    }

    @Override
    @NotNull
    public Aggregation<Double> add(@NotNull Aggregation<T> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return new AddAggregation<T>(this, aggregation);
    }

    @Override
    @NotNull
    public Aggregation<Double> substract(@NotNull Aggregation<T> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return new SubstractAggregation<T>(this, aggregation);
    }

    @Override
    @NotNull
    public Aggregation<Double> multiply(@NotNull Aggregation<T> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return new MultiplyAggregation<T>(this, aggregation);
    }

    @Override
    @NotNull
    public Aggregation<Double> divide(@NotNull Aggregation<T> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return new DivideAggregation<T>(this, aggregation);
    }

    @Override
    @NotNull
    public Aggregation<Double> min(@NotNull Aggregation<T> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return new MinAggregation<T>(this, aggregation);
    }

    @Override
    @NotNull
    public Aggregation<Double> max(@NotNull Aggregation<T> aggregation) {
        Intrinsics.checkNotNullParameter(aggregation, (String)"aggregation");
        return new MaxAggregation<T>(this, aggregation);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation$AddAggregation;", "T", "Lorg/molap/aggregates/aggregation/AbstractAggregation$TwoAggregation;", "a1", "Lorg/molap/aggregates/aggregation/Aggregation;", "a2", "<init>", "(Lorg/molap/aggregates/aggregation/Aggregation;Lorg/molap/aggregates/aggregation/Aggregation;)V", "compute", "", "v1", "", "v2", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Double;", "name", "", "n1", "n2", "molap"})
    private static final class AddAggregation<T>
    extends TwoAggregation<T> {
        public AddAggregation(@NotNull Aggregation<T> a1, @NotNull Aggregation<T> a2) {
            Intrinsics.checkNotNullParameter(a1, (String)"a1");
            Intrinsics.checkNotNullParameter(a2, (String)"a2");
            super(a1, a2);
        }

        @Override
        @NotNull
        protected Double compute(@NotNull Number v1, @NotNull Number v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return v1.doubleValue() + v2.doubleValue();
        }

        @Override
        @Nullable
        protected String name(@Nullable String n1, @Nullable String n2) {
            return n1 + "+" + n2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation$DivideAggregation;", "T", "Lorg/molap/aggregates/aggregation/AbstractAggregation$TwoAggregation;", "a1", "Lorg/molap/aggregates/aggregation/Aggregation;", "a2", "<init>", "(Lorg/molap/aggregates/aggregation/Aggregation;Lorg/molap/aggregates/aggregation/Aggregation;)V", "compute", "", "v1", "", "v2", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Double;", "name", "", "n1", "n2", "molap"})
    private static final class DivideAggregation<T>
    extends TwoAggregation<T> {
        public DivideAggregation(@NotNull Aggregation<T> a1, @NotNull Aggregation<T> a2) {
            Intrinsics.checkNotNullParameter(a1, (String)"a1");
            Intrinsics.checkNotNullParameter(a2, (String)"a2");
            super(a1, a2);
        }

        @Override
        @Nullable
        protected Double compute(@NotNull Number v1, @NotNull Number v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return !(v2.doubleValue() == 0.0) ? Double.valueOf(v1.doubleValue() / v2.doubleValue()) : null;
        }

        @Override
        @Nullable
        protected String name(@Nullable String n1, @Nullable String n2) {
            return n1 + "/" + n2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation$MaxAggregation;", "T", "Lorg/molap/aggregates/aggregation/AbstractAggregation$TwoAggregation;", "a1", "Lorg/molap/aggregates/aggregation/Aggregation;", "a2", "<init>", "(Lorg/molap/aggregates/aggregation/Aggregation;Lorg/molap/aggregates/aggregation/Aggregation;)V", "compute", "", "v1", "", "v2", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Double;", "name", "", "n1", "n2", "molap"})
    private static final class MaxAggregation<T>
    extends TwoAggregation<T> {
        public MaxAggregation(@NotNull Aggregation<T> a1, @NotNull Aggregation<T> a2) {
            Intrinsics.checkNotNullParameter(a1, (String)"a1");
            Intrinsics.checkNotNullParameter(a2, (String)"a2");
            super(a1, a2);
        }

        @Override
        @NotNull
        protected Double compute(@NotNull Number v1, @NotNull Number v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return Math.max(v1.doubleValue(), v2.doubleValue());
        }

        @Override
        @Nullable
        protected String name(@Nullable String n1, @Nullable String n2) {
            return "max(" + n1 + "," + n2 + ")";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation$MinAggregation;", "T", "Lorg/molap/aggregates/aggregation/AbstractAggregation$TwoAggregation;", "a1", "Lorg/molap/aggregates/aggregation/Aggregation;", "a2", "<init>", "(Lorg/molap/aggregates/aggregation/Aggregation;Lorg/molap/aggregates/aggregation/Aggregation;)V", "compute", "", "v1", "", "v2", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Double;", "name", "", "n1", "n2", "molap"})
    private static final class MinAggregation<T>
    extends TwoAggregation<T> {
        public MinAggregation(@NotNull Aggregation<T> a1, @NotNull Aggregation<T> a2) {
            Intrinsics.checkNotNullParameter(a1, (String)"a1");
            Intrinsics.checkNotNullParameter(a2, (String)"a2");
            super(a1, a2);
        }

        @Override
        @NotNull
        protected Double compute(@NotNull Number v1, @NotNull Number v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return Math.min(v1.doubleValue(), v2.doubleValue());
        }

        @Override
        @Nullable
        protected String name(@Nullable String n1, @Nullable String n2) {
            return "min(" + n1 + "," + n2 + ")";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation$MultiplyAggregation;", "T", "Lorg/molap/aggregates/aggregation/AbstractAggregation$TwoAggregation;", "a1", "Lorg/molap/aggregates/aggregation/Aggregation;", "a2", "<init>", "(Lorg/molap/aggregates/aggregation/Aggregation;Lorg/molap/aggregates/aggregation/Aggregation;)V", "compute", "", "v1", "", "v2", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Double;", "name", "", "n1", "n2", "molap"})
    private static final class MultiplyAggregation<T>
    extends TwoAggregation<T> {
        public MultiplyAggregation(@NotNull Aggregation<T> a1, @NotNull Aggregation<T> a2) {
            Intrinsics.checkNotNullParameter(a1, (String)"a1");
            Intrinsics.checkNotNullParameter(a2, (String)"a2");
            super(a1, a2);
        }

        @Override
        @Nullable
        protected Double compute(@NotNull Number v1, @NotNull Number v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return v1.doubleValue() * v2.doubleValue();
        }

        @Override
        @Nullable
        protected String name(@Nullable String n1, @Nullable String n2) {
            return n1 + "*" + n2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation$SubstractAggregation;", "T", "Lorg/molap/aggregates/aggregation/AbstractAggregation$TwoAggregation;", "a1", "Lorg/molap/aggregates/aggregation/Aggregation;", "a2", "<init>", "(Lorg/molap/aggregates/aggregation/Aggregation;Lorg/molap/aggregates/aggregation/Aggregation;)V", "compute", "", "v1", "", "v2", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Double;", "name", "", "n1", "n2", "molap"})
    private static final class SubstractAggregation<T>
    extends TwoAggregation<T> {
        public SubstractAggregation(@NotNull Aggregation<T> a1, @NotNull Aggregation<T> a2) {
            Intrinsics.checkNotNullParameter(a1, (String)"a1");
            Intrinsics.checkNotNullParameter(a2, (String)"a2");
            super(a1, a2);
        }

        @Override
        @Nullable
        protected Double compute(@NotNull Number v1, @NotNull Number v2) {
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            return v1.doubleValue() - v2.doubleValue();
        }

        @Override
        @Nullable
        protected String name(@Nullable String n1, @Nullable String n2) {
            return n1 + "-" + n2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\"\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\u000e\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H$J\n\u0010\u001c\u001a\u00020\u0019H\u0096\u0080\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/molap/aggregates/aggregation/AbstractAggregation$TwoAggregation;", "T", "Lorg/molap/aggregates/aggregation/AbstractAggregation;", "", "a1", "Lorg/molap/aggregates/aggregation/Aggregation;", "a2", "<init>", "(Lorg/molap/aggregates/aggregation/Aggregation;Lorg/molap/aggregates/aggregation/Aggregation;)V", "type", "Lkotlin/reflect/KClass;", "", "getType", "()Lkotlin/reflect/KClass;", "compute", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "group", "Lorg/molap/aggregates/cube/Group;", "(Lorg/molap/aggregates/cuboid/Cuboid;Lorg/molap/aggregates/cube/Group;)Ljava/lang/Double;", "v1", "", "v2", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Double;", "name", "", "n1", "n2", "toString", "molap"})
    private static abstract class TwoAggregation<T>
    extends AbstractAggregation<Double> {
        @NotNull
        private final Aggregation<T> a1;
        @NotNull
        private final Aggregation<T> a2;

        public TwoAggregation(@NotNull Aggregation<T> a1, @NotNull Aggregation<T> a2) {
            Intrinsics.checkNotNullParameter(a1, (String)"a1");
            Intrinsics.checkNotNullParameter(a2, (String)"a2");
            this.a1 = a1;
            this.a2 = a2;
        }

        @Override
        @NotNull
        public KClass<Object> getType() {
            return Reflection.getOrCreateKotlinClass(Double.TYPE);
        }

        @Override
        @Nullable
        public Double compute(@Nullable Cuboid cuboid, @Nullable Group group) {
            T v1 = this.a1.compute(cuboid, group);
            T v2 = this.a2.compute(cuboid, group);
            return v1 != null && v2 != null ? (v1 instanceof Number && v2 instanceof Number ? this.compute((Number)v1, (Number)v2) : null) : null;
        }

        @Nullable
        protected abstract Double compute(@NotNull Number var1, @NotNull Number var2);

        @Nullable
        protected abstract String name(@Nullable String var1, @Nullable String var2);

        @NotNull
        public String toString() {
            String string = this.name(this.a1.getName(), this.a2.getName());
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
    }
}

