/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import com.macrofocus.common.collection.UniversalComparator;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.SortKey;
import org.molap.dataframe.SortOrder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B5\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\n\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ;\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0001\u0010\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u0002H\u00182\u0006\u0010\u001c\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\nH\u0096\u0082\u0004J\n\u0010!\u001a\u00020\u0017H\u0096\u0080\u0004R\u0016\u0010\u0003\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R.\u0010\b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\n\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/molap/dataframe/SingleSortKey;", "Column", "Lorg/molap/dataframe/SortKey;", "column", "sortOrder", "Lorg/molap/dataframe/SortOrder;", "<init>", "(Ljava/lang/Object;Lorg/molap/dataframe/SortOrder;)V", "comparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "(Ljava/lang/Object;Lorg/molap/dataframe/SortOrder;Ljava/util/Comparator;)V", "getColumn", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSortOrder", "()Lorg/molap/dataframe/SortOrder;", "getComparator", "()Ljava/util/Comparator;", "setComparator", "(Ljava/util/Comparator;)V", "compare", "", "Row", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "o1", "o2", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Object;)I", "equals", "", "other", "hashCode", "molap"})
public final class SingleSortKey<Column>
implements SortKey<Column> {
    private final Column column;
    @NotNull
    private final SortOrder sortOrder;
    @NotNull
    private Comparator<Object> comparator;

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    @NotNull
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    @NotNull
    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public void setComparator(@NotNull Comparator<Object> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"<set-?>");
        this.comparator = comparator;
    }

    public SingleSortKey(Column column, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        this.column = column;
        this.sortOrder = sortOrder;
        this.setComparator((Comparator)new UniversalComparator());
    }

    public SingleSortKey(Column column, @NotNull SortOrder sortOrder, @NotNull Comparator<Object> comparator) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.column = column;
        this.sortOrder = sortOrder;
        this.setComparator(comparator);
    }

    @Override
    public <Row> int compare(@NotNull DataFrame<Row, Column, ?> dataFrame, Row o1, Row o2) {
        int n;
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (this.getSortOrder() != SortOrder.UNSORTED) {
            Object v1 = dataFrame.getValueAt(o1, this.getColumn());
            Object v2 = dataFrame.getValueAt(o2, this.getColumn());
            int compare = this.getComparator().compare(v1, v2);
            n = this.getSortOrder() == SortOrder.ASCENDING ? compare : -compare;
        } else {
            n = -2;
        }
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SingleSortKey cfr_ignored_0 = (SingleSortKey)other;
        if (!Intrinsics.areEqual(this.getColumn(), ((SingleSortKey)other).getColumn())) {
            return false;
        }
        if (this.getSortOrder() != ((SingleSortKey)other).getSortOrder()) {
            return false;
        }
        return Intrinsics.areEqual(this.getComparator(), ((SingleSortKey)other).getComparator());
    }

    public int hashCode() {
        Column Column2 = this.getColumn();
        int result = Column2 != null ? Column2.hashCode() : 0;
        result = 31 * result + this.getSortOrder().hashCode();
        result = 31 * result + this.getComparator().hashCode();
        return result;
    }
}

