/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.DataFrameWriter;
import org.molap.exporter.DelimitedDataFrameExport;
import org.molap.exporter.DelimitedDataFrameWriter;
import org.molap.exporter.StringDataFrameOutput;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\nJA\u0010\u000b\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\rJ:\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u0007\"\u0004\b\u0002\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/molap/exporter/DataFrameExporter;", "", "<init>", "()V", "exportCSV", "", "R", "C", "V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "exportDelimited", "delimiter", "exportDelimited$molap", "export", "", "writer", "Lorg/molap/exporter/DataFrameWriter;", "molap"})
public final class DataFrameExporter {
    @NotNull
    public static final DataFrameExporter INSTANCE = new DataFrameExporter();

    private DataFrameExporter() {
    }

    @NotNull
    public final <R, C, V> String exportCSV(@NotNull DataFrame<R, C, V> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        return this.exportDelimited$molap(dataFrame, ",");
    }

    @NotNull
    public final <R, C, V> String exportDelimited$molap(@NotNull DataFrame<R, C, V> dataFrame, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        String newLine = "\n";
        StringBuilder sb = new StringBuilder("\ufeff");
        DataFrameWriter writer = new DelimitedDataFrameWriter(new StringDataFrameOutput(sb), delimiter, newLine);
        this.export(dataFrame, writer);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final <R, C, V> void export(@NotNull DataFrame<R, C, V> dataFrame, @NotNull DataFrameWriter writer) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        DelimitedDataFrameExport export = new DelimitedDataFrameExport(writer);
        export.write(dataFrame);
        export.close();
    }
}

