/*
 * Decompiled with CFR 0.152.
 */
package org.molap.subset;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.series.Series;
import org.molap.subset.Group;
import org.molap.subset.MultiBinningDimension;
import org.molap.subset.Reducer;
import org.molap.subset.SingleBinningDimension;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B9\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bBO\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f\u00a2\u0006\u0004\b\n\u0010\u0010BO\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011\u00a2\u0006\u0004\b\n\u0010\u0012J\u0010\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0004J\u001d\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010+\u001a\u00020\u0015H\u0002J\u0015\u0010,\u001a\u00020\u00152\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010-J\b\u00102\u001a\u00020%H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00028\u0001`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00028\u0001`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0015@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0014\u0010.\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010 R\u0014\u00100\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010 \u00a8\u00063"}, d2={"Lorg/molap/subset/DefaultGroup;", "Row", "Bin", "Lorg/molap/subset/Group;", "initialCapacity", "", "reducer", "Lorg/molap/subset/Reducer;", "series", "Lorg/molap/series/Series;", "<init>", "(ILorg/molap/subset/Reducer;Lorg/molap/series/Series;)V", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "binningStrategy", "Lorg/molap/subset/SingleBinningDimension$SingleBinningStrategy;", "(ILorg/molap/subset/Reducer;Lorg/molap/dataframe/DataFrame;Lorg/molap/subset/SingleBinningDimension$SingleBinningStrategy;)V", "Lorg/molap/subset/MultiBinningDimension$MultiBinningStrategy;", "(ILorg/molap/subset/Reducer;Lorg/molap/dataframe/DataFrame;Lorg/molap/subset/MultiBinningDimension$MultiBinningStrategy;)V", "map", "", "", "Lcom/macrofocus/common/collection/TObjectDoubleMap;", "activeMap", "max", "Ljava/lang/Double;", "activeMax", "initialized", "", "value", "sumValue", "getSumValue", "()D", "activeSumValue", "getActiveSumValue", "getReducer", "add", "", "bin", "row", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "key", "computeMaxValue", "getValue", "(Ljava/lang/Object;)D", "maxValue", "getMaxValue", "activeMaxValue", "getActiveMaxValue", "reset", "molap"})
@SourceDebugExtension(value={"SMAP\nDefaultGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultGroup.kt\norg/molap/subset/DefaultGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class DefaultGroup<Row, Bin>
implements Group<Row, Bin> {
    @NotNull
    private final Reducer<Row, Bin> reducer;
    @NotNull
    private Map<Bin, Double> map;
    @NotNull
    private Map<Bin, Double> activeMap;
    @Nullable
    private Double max;
    @Nullable
    private Double activeMax;
    private boolean initialized;
    private double sumValue;
    private double activeSumValue;

    @Override
    public double getSumValue() {
        return this.sumValue;
    }

    @Override
    public double getActiveSumValue() {
        return this.activeSumValue;
    }

    public DefaultGroup(int initialCapacity, @NotNull Reducer<Row, Bin> reducer, @NotNull Series<Row, Bin> series) {
        Intrinsics.checkNotNullParameter(reducer, (String)"reducer");
        Intrinsics.checkNotNullParameter(series, (String)"series");
        this.reducer = reducer;
        this.activeMap = MapsKt.withDefaultMutable((Map)new HashMap(initialCapacity, 0.5f), DefaultGroup::_init_$lambda$0);
        this.sumValue = 0.0;
        Iterable<Row> iterable = series.keys();
        Intrinsics.checkNotNull(iterable);
        for (Row row : iterable) {
            Bin value = series.get(row);
            this.add(value, row);
        }
        this.activeSumValue = this.getSumValue();
        this.map = new HashMap<Bin, Double>(this.activeMap);
        this.initialized = true;
    }

    public DefaultGroup(int initialCapacity, @NotNull Reducer<Row, Bin> reducer, @NotNull DataFrame<Row, ?, ?> dataFrame, @NotNull SingleBinningDimension.SingleBinningStrategy<Row, Bin> binningStrategy2) {
        Intrinsics.checkNotNullParameter(reducer, (String)"reducer");
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(binningStrategy2, (String)"binningStrategy");
        this.reducer = reducer;
        this.activeMap = MapsKt.withDefaultMutable((Map)new HashMap(initialCapacity, 0.5f), DefaultGroup::_init_$lambda$1);
        this.sumValue = 0.0;
        for (Row row : dataFrame.rows()) {
            if (!binningStrategy2.isBinnable(row)) continue;
            Bin value = binningStrategy2.rowToBin(row);
            this.add(value, row);
        }
        this.activeSumValue = this.getSumValue();
        this.map = new HashMap<Bin, Double>(this.activeMap);
        this.initialized = true;
    }

    public DefaultGroup(int initialCapacity, @NotNull Reducer<Row, Bin> reducer, @NotNull DataFrame<Row, ?, ?> dataFrame, @NotNull MultiBinningDimension.MultiBinningStrategy<Row, Bin> binningStrategy2) {
        Intrinsics.checkNotNullParameter(reducer, (String)"reducer");
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(binningStrategy2, (String)"binningStrategy");
        this.reducer = reducer;
        this.activeMap = MapsKt.withDefaultMutable((Map)new HashMap(initialCapacity, 0.5f), DefaultGroup::_init_$lambda$2);
        this.sumValue = 0.0;
        for (Row row : dataFrame.rows()) {
            if (!binningStrategy2.isBinnable(row)) continue;
            for (Bin value : binningStrategy2.rowToBins(row)) {
                this.add(value, row);
            }
        }
        this.activeSumValue = this.getSumValue();
        this.map = new HashMap<Bin, Double>(this.activeMap);
        this.initialized = true;
    }

    @NotNull
    protected final Reducer<?, ?> getReducer() {
        return this.reducer;
    }

    @Override
    public void add(Bin bin, Row row) {
        Double d;
        double sum = this.reducer.add(this.activeMap, bin, row);
        if (this.activeMax == null) {
            v0 = sum;
        } else {
            Double d2 = this.activeMax;
            Intrinsics.checkNotNull((Object)d2);
            v0 = this.activeMax = Double.valueOf(Math.max(d2, sum));
        }
        if (this.max == null) {
            d = sum;
        } else {
            Double d3 = this.max;
            Intrinsics.checkNotNull((Object)d3);
            d = Math.max(d3, sum);
        }
        this.max = d;
        Number number = this.reducer.getNumber(row);
        if (number != null) {
            double d4 = number.doubleValue();
            if (!this.initialized) {
                this.sumValue = this.getSumValue() + d4;
            }
            this.activeSumValue = this.getActiveSumValue() + d4;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void remove(Bin key, Row row) {
        if (this.activeMax == null) ** GOTO lbl-1000
        v0 = this.activeMax;
        Intrinsics.checkNotNull((Object)v0);
        v1 = v0;
        v2 = this.activeMap.get(key);
        Intrinsics.checkNotNull((Object)v2);
        if (v1 <= ((Number)v2).doubleValue()) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        max = v3;
        this.reducer.remove(this.activeMap, key, row);
        if (max) {
            this.activeMax = null;
        }
        if ((number = this.reducer.getNumber(row)) != null) {
            d = number.doubleValue();
            this.activeSumValue = this.getActiveSumValue() - d;
        }
    }

    private final double computeMaxValue() {
        Iterator iterator2 = ((Iterable)this.activeMap.entrySet()).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry it = (Map.Entry)iterator2.next();
        boolean bl = false;
        double d = ((Number)it.getValue()).doubleValue();
        while (iterator2.hasNext()) {
            Map.Entry it2 = (Map.Entry)iterator2.next();
            $i$a$-maxOf-DefaultGroup$computeMaxValue$1 = false;
            double d2 = ((Number)it2.getValue()).doubleValue();
            d = Math.max(d, d2);
        }
        return d;
    }

    @Override
    public double getValue(Bin key) {
        Double d = this.activeMap.get(key);
        Intrinsics.checkNotNull((Object)d);
        return ((Number)d).doubleValue();
    }

    @Override
    public double getMaxValue() {
        if (this.max == null) {
            this.max = this.computeMaxValue();
        }
        Double d = this.max;
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    @Override
    public double getActiveMaxValue() {
        if (this.activeMax == null) {
            this.activeMax = this.computeMaxValue();
        }
        Double d = this.activeMax;
        Intrinsics.checkNotNull((Object)d);
        return d;
    }

    @Override
    public void reset() {
        this.activeSumValue = this.getSumValue();
        this.activeMax = null;
        this.activeMap = new HashMap<Bin, Double>(this.map);
    }

    private static final double _init_$lambda$0(Object it) {
        return 0.0;
    }

    private static final double _init_$lambda$1(Object it) {
        return 0.0;
    }

    private static final double _init_$lambda$2(Object it) {
        return 0.0;
    }
}

