/*
 * Decompiled with CFR 0.152.
 */
package org.molap.subset;

import com.macrofocus.common.collection.ArrayFnKt;
import com.macrofocus.common.math.MathKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.subset.DistributionDimension;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 I*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002:\u0002HIB\t\b\u0014\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0017\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\nB'\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\rB'\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\u0010J\u000e\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003J\u0010\u0010/\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0015\u00101\u001a\u0002022\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00105J)\u00106\u001a\u0002072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00108\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ1\u00106\u001a\u0002072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00108\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u00109J\u000e\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\fJ\u000e\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u0003J\u000e\u0010@\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u0003J\u000e\u0010B\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u0003J\n\u0010C\u001a\u00020DH\u0096\u0080\u0004J+\u0010E\u001a\u00020\f2\u0006\u0010E\u001a\u00020\f2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010GR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R \u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u000e\u0010\"\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001fR\u001e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001fR\"\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u0014\u001a\u0004\u0018\u00010'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0017R\u0011\u0010<\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0017\u00a8\u0006J"}, d2={"Lorg/molap/subset/GenedataDistributionStrategy;", "Value", "Lorg/molap/subset/DistributionDimension$DistributionStrategy;", "", "<init>", "()V", "sortedValues", "", "", "count", "([Ljava/lang/Number;I)V", "coef", "", "([Ljava/lang/Number;ID)V", "centralValue", "binWidth", "([Ljava/lang/Number;DD)V", "virtualIndices", "", "counts", "value", "totalPopulation", "getTotalPopulation", "()I", "minPopulation", "getMinPopulation", "minNonZeroPopulation", "getMinNonZeroPopulation", "maxPopulation", "getMaxPopulation", "getBinWidth", "()D", "minValue", "getMinValue", "minimumMiddle", "minimumUpperBound", "maxValue", "getMaxValue", "getCentralValue", "Lorg/molap/subset/GenedataDistributionStrategy$Range;", "range", "getRange", "()Lorg/molap/subset/GenedataDistributionStrategy$Range;", "numberOfBins", "getNumberOfBins", "getCountAtBin", "index", "getBinStartValue", "getBinEndValue", "isBinnable", "", "(Ljava/lang/Object;)Z", "valueToBin", "(Ljava/lang/Object;)Ljava/lang/Integer;", "init", "", "valueCount", "([Ljava/lang/Number;IDD)V", "getBin", "v", "binCount", "getBinCount", "getBinMiddle", "i", "getLowerResidual", "getPopulationAt", "getUpperResidual", "toString", "", "quantile", "data", "(D[Ljava/lang/Number;I)D", "Range", "Companion", "molap"})
@SourceDebugExtension(value={"SMAP\nGenedataDistributionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenedataDistributionStrategy.kt\norg/molap/subset/GenedataDistributionStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
public final class GenedataDistributionStrategy<Value>
implements DistributionDimension.DistributionStrategy<Value, Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int[] virtualIndices;
    private int[] counts;
    private int totalPopulation;
    private int minPopulation;
    private int minNonZeroPopulation;
    private int maxPopulation;
    private double binWidth;
    private double minValue;
    private double minimumMiddle;
    private double minimumUpperBound;
    private double maxValue;
    private double centralValue;
    @Nullable
    private Range range;

    public final int getTotalPopulation() {
        return this.totalPopulation;
    }

    public final int getMinPopulation() {
        return this.minPopulation;
    }

    public final int getMinNonZeroPopulation() {
        return this.minNonZeroPopulation;
    }

    public final int getMaxPopulation() {
        return this.maxPopulation;
    }

    public final double getBinWidth() {
        return this.binWidth;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    public final double getCentralValue() {
        return this.centralValue;
    }

    @Nullable
    public final Range getRange() {
        return this.range;
    }

    public final int getNumberOfBins() {
        return this.getBinCount();
    }

    public final int getCountAtBin(int index) {
        return this.getPopulationAt(index);
    }

    @Override
    public double getBinStartValue(int index) {
        return this.getMinValue() + (this.getMaxValue() - this.getMinValue()) * (double)index / (double)this.getBinCount();
    }

    @Override
    public double getBinEndValue(int index) {
        return this.getMinValue() + (this.getMaxValue() - this.getMinValue()) * (double)(index + 1) / (double)this.getBinCount();
    }

    @Override
    public boolean isBinnable(Value value) {
        return value != null && value instanceof Number;
    }

    @Override
    @NotNull
    public Integer valueToBin(Value value) {
        Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Number");
        return this.getBin(((Number)value).doubleValue());
    }

    protected GenedataDistributionStrategy() {
    }

    @JvmOverloads
    public GenedataDistributionStrategy(@NotNull Number[] sortedValues, int count) {
        Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
        this.init(sortedValues, count, 2.0);
    }

    public /* synthetic */ GenedataDistributionStrategy(Number[] numberArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = numberArray.length;
        }
        this(numberArray, n);
    }

    public GenedataDistributionStrategy(@NotNull Number[] sortedValues, int count, double coef) {
        Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
        this.init(sortedValues, count, coef);
    }

    public GenedataDistributionStrategy(@NotNull Number[] sortedValues, double centralValue, double binWidth) {
        Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
        this.init(sortedValues, this.getBinCount(), centralValue, binWidth);
    }

    public final void init(@NotNull Number[] sortedValues, int valueCount, double coef) {
        Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
        if (!(valueCount != 0)) {
            boolean bl = false;
            String string = "Cannot make histogram from empty array.";
            throw new IllegalArgumentException(string.toString());
        }
        double median = this.quantile(0.5, sortedValues, valueCount);
        double iq = this.quantile(0.75, sortedValues, valueCount) - this.quantile(0.25, sortedValues, valueCount);
        double binWidth = coef * iq * Math.pow(valueCount, -0.3333333333333333);
        if ((binWidth == 0.0 || MathKt.isNaN((double)binWidth) || MathKt.isInfinite((double)binWidth)) && ((binWidth = (sortedValues[valueCount - 1].doubleValue() - sortedValues[0].doubleValue()) / (double)10) == 0.0 || MathKt.isNaN((double)binWidth) || MathKt.isInfinite((double)binWidth))) {
            binWidth = 1.0;
        }
        this.init(sortedValues, valueCount, median, binWidth);
    }

    public final void init(@NotNull Number[] sortedValues, int valueCount, double centralValue, double binWidth) {
        Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
        if (!(valueCount != 0)) {
            boolean bl = false;
            String string = "Cannot make histogram from empty array.";
            throw new IllegalArgumentException(string.toString());
        }
        this.range = new Range(sortedValues[0].doubleValue(), sortedValues[valueCount - 1].doubleValue());
        this.centralValue = centralValue;
        this.binWidth = binWidth;
        this.totalPopulation = valueCount;
        this.virtualIndices = new int[this.totalPopulation];
        this.counts = new int[this.totalPopulation];
        double centralValueRightBoundary = centralValue + 0.5 * binWidth;
        this.minimumUpperBound = centralValueRightBoundary - binWidth * Math.floor((centralValueRightBoundary - sortedValues[0].doubleValue()) / binWidth);
        if (sortedValues[0].doubleValue() > this.minimumUpperBound) {
            this.minimumUpperBound += binWidth;
        }
        this.minValue = this.minimumUpperBound - binWidth;
        this.minimumMiddle = this.minimumUpperBound - binWidth / 2.0;
        int k = 0;
        this.maxValue = this.minimumUpperBound;
        this.minPopulation = this.totalPopulation;
        this.minNonZeroPopulation = this.totalPopulation;
        this.maxPopulation = 0;
        for (int i = 0; i < valueCount; ++i) {
            if (sortedValues[i].doubleValue() > this.getMaxValue()) {
                int[] nArray = this.counts;
                if (this.counts == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                    nArray = null;
                }
                if (nArray[k] < this.minPopulation) {
                    int[] nArray2 = this.counts;
                    if (this.counts == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                        nArray2 = null;
                    }
                    this.minPopulation = nArray2[k];
                }
                int[] nArray3 = this.counts;
                if (this.counts == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                    nArray3 = null;
                }
                if (nArray3[k] < this.minNonZeroPopulation) {
                    int[] nArray4 = this.counts;
                    if (this.counts == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                        nArray4 = null;
                    }
                    if (nArray4[k] > 0) {
                        int[] nArray5 = this.counts;
                        if (this.counts == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                            nArray5 = null;
                        }
                        this.minNonZeroPopulation = nArray5[k];
                    }
                }
                int[] nArray6 = this.counts;
                if (this.counts == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                    nArray6 = null;
                }
                if (nArray6[k] > this.getMaxPopulation()) {
                    int[] nArray7 = this.counts;
                    if (this.counts == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                        nArray7 = null;
                    }
                    this.maxPopulation = nArray7[k];
                }
                int deltaIndex = 1 + (int)((sortedValues[i].doubleValue() - this.getMaxValue()) / binWidth);
                int[] nArray8 = this.virtualIndices;
                if (this.virtualIndices == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
                    nArray8 = null;
                }
                int[] nArray9 = this.virtualIndices;
                if (this.virtualIndices == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
                    nArray9 = null;
                }
                nArray8[k + 1] = nArray9[k] + deltaIndex;
                ++k;
                this.maxValue = this.getMaxValue() + (double)deltaIndex * binWidth;
            }
            int[] nArray = this.counts;
            if (this.counts == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                nArray = null;
            }
            int[] nArray10 = nArray;
            int n = k;
            int n2 = nArray10[n];
            nArray10[n] = n2 + 1;
        }
        if (this.getMaxPopulation() == 0) {
            this.maxPopulation = this.totalPopulation;
        }
        int[] nArray = this.virtualIndices;
        if (this.virtualIndices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
            nArray = null;
        }
        this.virtualIndices = Companion.trim(nArray, ++k);
        int[] nArray11 = this.counts;
        if (this.counts == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
            nArray11 = null;
        }
        this.counts = Companion.trim(nArray11, k);
    }

    public final int getBin(double v) {
        if (v < this.getMinValue()) {
            return -1;
        }
        return v > this.getMaxValue() ? -2 : (int)((v - this.getMinValue()) / this.binWidth);
    }

    public final int getBinCount() {
        int[] nArray = this.virtualIndices;
        if (this.virtualIndices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
            nArray = null;
        }
        int[] nArray2 = this.virtualIndices;
        if (this.virtualIndices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
            nArray2 = null;
        }
        return 1 + nArray[nArray2.length - 1];
    }

    public final double getBinMiddle(int i) {
        return this.minimumMiddle + (double)i * this.binWidth;
    }

    public final double getLowerResidual(int i) {
        if (i < 0) {
            return 0.0;
        }
        int s = 0;
        int k = 0;
        while (true) {
            int[] nArray = this.virtualIndices;
            if (this.virtualIndices == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
                nArray = null;
            }
            if (k >= nArray.length) break;
            int[] nArray2 = this.virtualIndices;
            if (this.virtualIndices == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
                nArray2 = null;
            }
            if (nArray2[k] >= i) break;
            int[] nArray3 = this.counts;
            if (this.counts == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                nArray3 = null;
            }
            s += nArray3[k];
            ++k;
        }
        return (double)s * (double)100 / (double)this.totalPopulation;
    }

    public final int getPopulationAt(int i) {
        int n;
        int k;
        int[] nArray = this.virtualIndices;
        if (this.virtualIndices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
            nArray = null;
        }
        if ((k = ArrayFnKt.binarySearch((int[])nArray, (int)i)) < 0) {
            n = 0;
        } else {
            int[] nArray2 = this.counts;
            if (this.counts == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                nArray2 = null;
            }
            n = nArray2[k];
        }
        return n;
    }

    public final double getUpperResidual(int i) {
        int k;
        int[] nArray = this.virtualIndices;
        if (this.virtualIndices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
            nArray = null;
        }
        int[] nArray2 = this.virtualIndices;
        if (this.virtualIndices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
            nArray2 = null;
        }
        if (i + 1 > nArray[nArray2.length - 1]) {
            return 0.0;
        }
        int s = 0;
        int[] nArray3 = this.virtualIndices;
        if (this.virtualIndices == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
            nArray3 = null;
        }
        if ((k = ArrayFnKt.binarySearch((int[])nArray3, (int)(i + 1))) < 0) {
            k = -(k + 1);
        }
        while (true) {
            int[] nArray4 = this.virtualIndices;
            if (this.virtualIndices == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"virtualIndices");
                nArray4 = null;
            }
            if (k >= nArray4.length) break;
            int[] nArray5 = this.counts;
            if (this.counts == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"counts");
                nArray5 = null;
            }
            s += nArray5[k];
            ++k;
        }
        return (double)s * (double)100 / (double)this.totalPopulation;
    }

    @NotNull
    public String toString() {
        int n = this.getBinCount();
        Range range = this.range;
        Intrinsics.checkNotNull((Object)range);
        double d = range.getMin();
        Range range2 = this.range;
        Intrinsics.checkNotNull((Object)range2);
        double d2 = range2.getMax();
        Range range3 = this.range;
        Intrinsics.checkNotNull((Object)range3);
        return "Histogram, range=" + this.range + ", total=" + this.totalPopulation + ", binWidth=" + this.binWidth + ", centralValue=" + this.centralValue + ", binCount=" + n + ", minRange=" + d + ", maxRange=" + d2 + ", range=" + range3.getRange() + ", binRange=" + this.binWidth * (double)this.getBinCount() + ", minimumLowerBound=" + this.getMinValue() + ", maximumUpperBound=" + this.getMaxValue() + ", binWidth=" + (this.getMaxValue() - this.getMinValue()) / (double)this.getBinCount();
    }

    private final double quantile(double quantile, Number[] data, int count) {
        double virtualIndex = (double)(count - 1) * quantile;
        int baseIndex = (int)virtualIndex;
        return baseIndex == count - 1 ? data[baseIndex].doubleValue() : data[baseIndex].doubleValue() * (1.0 - (virtualIndex -= (double)baseIndex)) + data[baseIndex + 1].doubleValue() * virtualIndex;
    }

    @JvmOverloads
    public GenedataDistributionStrategy(@NotNull Number[] sortedValues) {
        Intrinsics.checkNotNullParameter((Object)sortedValues, (String)"sortedValues");
        this(sortedValues, 0, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/molap/subset/GenedataDistributionStrategy$Companion;", "", "<init>", "()V", "trim", "", "vector", "len", "", "molap"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final int[] trim(@NotNull int[] vector, int len) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            if (vector.length == len) {
                nArray = vector;
            } else {
                void var3_3;
                int[] truncated = new int[len];
                ArrayFnKt.arraycopy((int[])vector, (int)0, (int[])truncated, (int)0, (int)len);
                nArray = var3_3;
            }
            return nArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\bB\u0017\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0004\b\u0005\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0005\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0005\u0010\u0011B\u0017\b\u0016\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u0005\u0010\u0012J\n\u0010\u0013\u001a\u00020\u0014H\u0096\u0080\u0004J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0000J\u001b\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\n2\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0011\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0086\u0002J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020*2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010)\u001a\u00020*2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010+\u001a\u00020\rR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010.R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010.\u00a8\u00061"}, d2={"Lorg/molap/subset/GenedataDistributionStrategy$Range;", "", "min", "", "max", "<init>", "(DD)V", "roleModel", "(Lorg/molap/subset/GenedataDistributionStrategy$Range;)V", "ranges", "", "([Lorg/molap/subset/GenedataDistributionStrategy$Range;)V", "data", "", "([D)V", "valids", "", "([D[I)V", "([[D)V", "toString", "", "range", "getRange", "()D", "scale", "log", "getSubRanges", "count", "", "(I)[Lorg/molap/subset/GenedataDistributionStrategy$Range;", "contains", "", "value", "getClippedValue", "makeSymmetrical", "ensureWidth", "width", "widenAbsolute", "extent", "widenRelative", "ratio", "widen", "", "toDoubleArray", "getMin", "setMin", "(D)V", "getMax", "setMax", "molap"})
    public static final class Range {
        private double min;
        private double max;

        @NotNull
        public String toString() {
            return "[" + this.min + ", " + this.max + "]";
        }

        public final double getRange() {
            return MathKt.isInfinite((double)(this.max - this.min)) ? Double.NaN : this.max - this.min;
        }

        public Range(double min, double max) {
            this.min = Double.NaN;
            this.max = Double.NaN;
            if (min <= max) {
                this.min = min;
                this.max = max;
            }
        }

        public Range(@NotNull Range roleModel) {
            Intrinsics.checkNotNullParameter((Object)roleModel, (String)"roleModel");
            this.min = Double.NaN;
            this.max = Double.NaN;
            this.min = roleModel.min;
            this.max = roleModel.max;
        }

        public Range(@NotNull Range[] ranges) {
            Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
            this.min = Double.NaN;
            this.max = Double.NaN;
            if (ranges.length >= 1) {
                this.min = ranges[0].min;
                this.max = ranges[0].max;
                int n = ranges.length;
                for (int i = 1; i < n; ++i) {
                    this.min = Math.min(this.min, ranges[i].min);
                    this.max = Math.max(this.max, ranges[i].max);
                }
            }
        }

        public Range(@NotNull double[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.min = Double.NaN;
            this.max = Double.NaN;
            this.widen(data);
        }

        public Range(@NotNull double[] data, @NotNull int[] valids) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)valids, (String)"valids");
            this.min = Double.NaN;
            this.max = Double.NaN;
            this.widen(data, valids);
        }

        public Range(@NotNull double[][] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.min = Double.NaN;
            this.max = Double.NaN;
            int n = ((Object[])data).length;
            for (int i = 0; i < n; ++i) {
                this.widen(data[i]);
            }
        }

        @NotNull
        public final Range scale(double scale) {
            return new Range(this.min * scale, this.max * scale);
        }

        @NotNull
        public final Range log() {
            return new Range(Math.log(this.min), Math.log(this.max));
        }

        @NotNull
        public final Range[] getSubRanges(int count) {
            Range[] result = new Range[count];
            double min = this.min;
            double range = this.getRange();
            int n = result.length;
            for (int i = 0; i < n; ++i) {
                result[i] = new Range(min + range * (double)i / (double)result.length, min + range * (Double)(i + 1) / (double)result.length);
            }
            return result;
        }

        public final boolean contains(double value) {
            return value >= this.min && value <= this.max;
        }

        public final double getClippedValue(double value) {
            return Math.min(this.max, Math.max(this.min, value));
        }

        @NotNull
        public final Range makeSymmetrical() {
            double extent = Math.max(-this.min, this.max);
            return new Range(-extent, extent);
        }

        @NotNull
        public final Range ensureWidth(double width) {
            double halfDiff = (width - this.getRange()) / (double)2.0f;
            return halfDiff <= 0.0 ? this : new Range(this.min - halfDiff, this.max + halfDiff);
        }

        @NotNull
        public final Range widenAbsolute(double extent) {
            return new Range(this.min - extent, this.max + extent);
        }

        @NotNull
        public final Range widenRelative(double ratio) {
            double extend = (this.max - this.min) * ratio;
            return this.widenAbsolute(extend);
        }

        public final void widen(@NotNull double[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                this.min = Math.min(data[i], this.min);
                this.max = Math.max(data[i], this.max);
            }
        }

        public final void widen(@NotNull double[] data, @NotNull int[] valids) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)valids, (String)"valids");
            int n = valids.length;
            for (int i = 0; i < n; ++i) {
                this.min = Math.min(data[valids[i]], this.min);
                this.max = Math.max(data[valids[i]], this.max);
            }
        }

        @NotNull
        public final double[] toDoubleArray() {
            double[] dArray = new double[]{this.min, this.max};
            return dArray;
        }

        public final double getMin() {
            return this.min;
        }

        public final void setMin(double d) {
            this.min = d;
        }

        public final double getMax() {
            return this.max;
        }

        public final void setMax(double d) {
            this.max = d;
        }
    }
}

