/*
 * Decompiled with CFR 0.152.
 */
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.treemap.AbstractTreeMap;
import com.treemap.AbstractTreeMapNode;
import com.treemap.Algorithm;
import com.treemap.AlgorithmFactory;
import com.treemap.DefaultTreeMap;
import com.treemap.Rendering;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.colormap.MutableColorMap;
import org.mkui.font.crossplatform.CPFont;
import org.mkui.palette.FixedPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteFactory;
import org.mkui.swing.HierarchicalComboBox;
import org.mkui.swing.Orientation;
import org.mkui.swing.SingleSelectionComboBoxModel;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.JsonDataFrame;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ>\u0010\n\u001a\u00020\u000b2&\u0010\f\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0018\u00010\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002JL\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u00152&\u0010\f\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0018\u00010\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002JF\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00172&\u0010\f\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0018\u00010\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002JF\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00172&\u0010\f\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0018\u00010\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u0010\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002\u00a8\u0006\u001e"}, d2={"LDemo;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "createConfiguration", "Ljavax/swing/JPanel;", "model", "Lcom/treemap/TreeMapModel;", "Lcom/treemap/AbstractTreeMapNode;", "", "settings", "Lcom/treemap/TreeMapSettings;", "createGroupBy", "Lorg/mkui/swing/HierarchicalComboBox;", "orientation", "Lorg/mkui/swing/Orientation;", "createSizeComboBox", "Ljavax/swing/JComboBox;", "createColorComboBox", "createAlgorithmComboBox", "Lcom/treemap/Algorithm;", "Lcom/treemap/TreeMapColumnSettings;", "createRenderingComboBox", "Lcom/treemap/Rendering;", "treemap-kotlin-swing"})
public final class Demo {
    @NotNull
    public static final Demo INSTANCE = new Demo();

    private Demo() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws IOException {
        MutableColorMap colorMap;
        TreeMapModel model;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        InputStream inputStream = Demo.class.getResourceAsStream("Forbes Global 2000 - 2021.json");
        Intrinsics.checkNotNull((Object)inputStream);
        DataFrame dataFrame = (DataFrame)JsonDataFrame.Companion.fromInputStream(inputStream);
        AbstractTreeMap treeMap = (AbstractTreeMap)new DefaultTreeMap(dataFrame);
        TreeMapModel treeMapModel = model = treeMap.getModel();
        Intrinsics.checkNotNull((Object)treeMapModel);
        TreeMapSettings settings = treeMapModel.getSettings();
        settings.setRendering(RenderingFactory.Companion.getFLAT());
        Object[] objectArray = new String[]{"Sector", "Industry"};
        settings.setGroupByColumns(CollectionsKt.listOf((Object[])objectArray));
        settings.setSizeColumn((Object)"Market Value");
        settings.setColorColumn((Object)"Profits");
        TreeMapColumnSettings profitsSettings = settings.getColumnSettings((Object)"Profits");
        PaletteFactory.Entry entry = PaletteFactory.Companion.getInstance().get("negpos");
        Intrinsics.checkNotNull((Object)entry);
        FixedPalette negpos = entry.getPalette();
        MutableColorMap mutableColorMap = colorMap = model.getColorMap((Object)"Profits");
        Intrinsics.checkNotNull((Object)mutableColorMap);
        mutableColorMap.setPalette((MutablePalette)negpos);
        MutableInterval mutableInterval = colorMap.getInterval();
        Intrinsics.checkNotNull((Object)mutableInterval);
        mutableInterval.setValue(-63.93, 127.86);
        TreeMapColumnSettings companySettings = settings.getColumnSettings((Object)"Company");
        companySettings.setLabelingFont(new CPFont(new Font("Helvetica", 0, 9)).getNativeFont());
        companySettings.setLabelingMinimumCharactersToDisplay(Integer.valueOf(5));
        companySettings.setLabelingResizeTextToFitShape(true);
        companySettings.setLabelingVerticalAlignment(0);
        companySettings.setLabelingHorizontalAlignment(0);
        TreeMapView treeMapView = treeMap.getView();
        Intrinsics.checkNotNull((Object)treeMapView);
        treeMapView.setShowTiming(true);
        JPanel configuration = INSTANCE.createConfiguration((TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String>)model, (TreeMapSettings<String>)settings);
        JSplitPane splitPane = new JSplitPane(1, true, configuration, treeMap.getComponent().getNativeComponent());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)INSTANCE.createGroupBy(Orientation.Horizontal, (TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String>)model, (TreeMapSettings<String>)settings), "North");
        mainPanel.add(splitPane);
        JFrame frame = new JFrame("TreeMap");
        frame.getContentPane().add(mainPanel);
        frame.setSize(1024, 768);
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private final JPanel createConfiguration(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        JPanel configuration = new JPanel();
        configuration.setLayout(new BoxLayout(configuration, 3));
        configuration.add((Component)this.createGroupBy(Orientation.Vertical, model, settings));
        configuration.add(this.createSizeComboBox(model, settings));
        configuration.add(this.createColorComboBox(model, settings));
        configuration.add(this.createAlgorithmComboBox(settings.getDefaultColumnSettings()));
        configuration.add(this.createRenderingComboBox(settings));
        configuration.add(Box.createGlue());
        return configuration;
    }

    private final HierarchicalComboBox<String> createGroupBy(Orientation orientation, TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        MutableSelection mutableSelection = settings.getGroupByColumnsSelection();
        TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> treeMapModel = model;
        Intrinsics.checkNotNull(treeMapModel);
        Iterable iterable = treeMapModel.getGroupByColumns();
        HierarchicalComboBox groupBy2 = (HierarchicalComboBox)new HierarchicalComboBox<String>(orientation, (MutableSelection<String>)mutableSelection, (Iterable<String>)iterable){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }
        };
        groupBy2.setBorder((Border)BorderFactory.createTitledBorder("Group by"));
        groupBy2.setAlignmentX(0.0f);
        return groupBy2;
    }

    private final JComboBox<String> createSizeComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        MutableSingleSelection mutableSingleSelection = settings.getSizeColumnSelection();
        TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> treeMapModel = model;
        Intrinsics.checkNotNull(treeMapModel);
        SingleSelectionComboBoxModel singleSelectionComboBoxModel = new SingleSelectionComboBoxModel(mutableSingleSelection, treeMapModel.getSizeColumns());
        JComboBox sizeComboBox2 = new JComboBox<String>((SingleSelectionComboBoxModel<String>)singleSelectionComboBoxModel){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }
        };
        sizeComboBox2.setBorder(BorderFactory.createTitledBorder("Size"));
        sizeComboBox2.setAlignmentX(0.0f);
        return sizeComboBox2;
    }

    private final JComboBox<String> createColorComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        MutableSingleSelection mutableSingleSelection = settings.getColorColumnSelection();
        TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> treeMapModel = model;
        Intrinsics.checkNotNull(treeMapModel);
        SingleSelectionComboBoxModel singleSelectionComboBoxModel = new SingleSelectionComboBoxModel(mutableSingleSelection, treeMapModel.getColorColumns());
        JComboBox sizeComboBox2 = new JComboBox<String>((SingleSelectionComboBoxModel<String>)singleSelectionComboBoxModel){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }
        };
        sizeComboBox2.setBorder(BorderFactory.createTitledBorder("Size"));
        sizeComboBox2.setAlignmentX(0.0f);
        return sizeComboBox2;
    }

    private final JComboBox<Algorithm> createAlgorithmComboBox(TreeMapColumnSettings settings) {
        SingleSelectionComboBoxModel singleSelectionComboBoxModel = new SingleSelectionComboBoxModel(settings.getAlgorithmProperty(), (Iterable)AlgorithmFactory.Companion.getInstance().getAlgorithms());
        JComboBox algorithmComboBox2 = new JComboBox<Algorithm>((SingleSelectionComboBoxModel<Algorithm>)singleSelectionComboBoxModel){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }
        };
        algorithmComboBox2.setBorder(BorderFactory.createTitledBorder("Algorithm"));
        algorithmComboBox2.setAlignmentX(0.0f);
        return algorithmComboBox2;
    }

    private final JComboBox<Rendering> createRenderingComboBox(TreeMapSettings<String> settings) {
        SingleSelectionComboBoxModel singleSelectionComboBoxModel = new SingleSelectionComboBoxModel(settings.getRenderingSelection(), (Iterable)RenderingFactory.Companion.getInstance().getRenderings());
        JComboBox renderingComboBox2 = new JComboBox<Rendering>((SingleSelectionComboBoxModel<Rendering>)singleSelectionComboBoxModel){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }
        };
        renderingComboBox2.setBorder(BorderFactory.createTitledBorder("Rendering"));
        renderingComboBox2.setAlignmentX(0.0f);
        return renderingComboBox2;
    }
}

